/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl.jmx;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.security.auth.Subject;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.json.JsonUtil;
import org.apache.jackrabbit.oak.spi.security.authentication.SystemSubject;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentity;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityException;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityProviderManager;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityRef;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalUser;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncContext;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncException;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncHandler;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncManager;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncResult;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncedIdentity;
import org.apache.jackrabbit.oak.spi.security.authentication.external.basic.DefaultSyncResultImpl;
import org.apache.jackrabbit.oak.spi.security.authentication.external.basic.DefaultSyncedIdentity;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.jmx.SynchronizationMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncMBeanImpl
implements SynchronizationMBean {
    private static final Logger log = LoggerFactory.getLogger(SyncMBeanImpl.class);
    private final Repository repository;
    private final SyncManager syncManager;
    private final String syncName;
    private final ExternalIdentityProviderManager idpManager;
    private final String idpName;

    public SyncMBeanImpl(Repository repository, SyncManager syncManager, String syncName, ExternalIdentityProviderManager idpManager, String idpName) {
        this.repository = repository;
        this.syncManager = syncManager;
        this.syncName = syncName;
        this.idpManager = idpManager;
        this.idpName = idpName;
    }

    @Nonnull
    private Delegatee getDelegatee() {
        SyncHandler handler = this.syncManager.getSyncHandler(this.syncName);
        if (handler == null) {
            log.error("No sync manager available for name {}.", (Object)this.syncName);
            throw new IllegalArgumentException("No sync manager available for name " + this.syncName);
        }
        ExternalIdentityProvider idp = this.idpManager.getProvider(this.idpName);
        if (idp == null) {
            log.error("No idp available for name", (Object)this.idpName);
            throw new IllegalArgumentException("No idp manager available for name " + this.idpName);
        }
        try {
            return new Delegatee(handler, idp);
        }
        catch (SyncException e) {
            throw new IllegalArgumentException("Unable to create delegatee", e);
        }
    }

    private static String getJSONString(@Nonnull SyncResult r) {
        String op;
        switch (r.getStatus()) {
            case NOP: {
                op = "nop";
                break;
            }
            case ADD: {
                op = "add";
                break;
            }
            case UPDATE: {
                op = "upd";
                break;
            }
            case DELETE: {
                op = "del";
                break;
            }
            case NO_SUCH_AUTHORIZABLE: {
                op = "nsa";
                break;
            }
            case NO_SUCH_IDENTITY: {
                op = "nsi";
                break;
            }
            case MISSING: {
                op = "mis";
                break;
            }
            case FOREIGN: {
                op = "for";
                break;
            }
            default: {
                op = "";
            }
        }
        SyncedIdentity syncedIdentity = r.getIdentity();
        String uid = JsonUtil.getJsonString((String)(syncedIdentity == null ? null : syncedIdentity.getId()));
        ExternalIdentityRef externalIdentityRef = syncedIdentity == null ? null : syncedIdentity.getExternalIdRef();
        String eid = externalIdentityRef == null ? "\"\"" : JsonUtil.getJsonString((String)externalIdentityRef.getString());
        return String.format("{op:\"%s\",uid:%s,eid:%s}", op, uid, eid);
    }

    private static String getJSONString(@Nonnull SyncedIdentity id, @Nonnull Exception e) {
        String uid = JsonUtil.getJsonString((String)id.getId());
        String eid = id.getExternalIdRef() == null ? "\"\"" : JsonUtil.getJsonString((String)id.getExternalIdRef().getString());
        String msg = JsonUtil.getJsonString((String)e.toString());
        return String.format("{op:\"ERR\",uid:%s,eid:%s,msg:%s}", uid, eid, msg);
    }

    private static String getJSONString(ExternalIdentityRef ref, Exception e) {
        String eid = JsonUtil.getJsonString((String)ref.getString());
        String msg = JsonUtil.getJsonString((String)e.toString());
        return String.format("{op:\"ERR\",uid:\"\",eid:%s,msg:%s}", eid, msg);
    }

    @Override
    @Nonnull
    public String getSyncHandlerName() {
        return this.syncName;
    }

    @Override
    @Nonnull
    public String getIDPName() {
        return this.idpName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public String[] syncUsers(@Nonnull String[] userIds, boolean purge) {
        Delegatee delegatee = this.getDelegatee();
        try {
            String[] stringArray = delegatee.syncUsers(userIds, purge);
            return stringArray;
        }
        finally {
            delegatee.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public String[] syncAllUsers(boolean purge) {
        Delegatee delegatee = this.getDelegatee();
        try {
            String[] stringArray = delegatee.syncAllUsers(purge);
            return stringArray;
        }
        finally {
            delegatee.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public String[] syncExternalUsers(@Nonnull String[] externalIds) {
        Delegatee delegatee = this.getDelegatee();
        try {
            String[] stringArray = delegatee.syncExternalUsers(externalIds);
            return stringArray;
        }
        finally {
            delegatee.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public String[] syncAllExternalUsers() {
        Delegatee delegatee = this.getDelegatee();
        try {
            String[] stringArray = delegatee.syncAllExternalUsers();
            return stringArray;
        }
        finally {
            delegatee.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public String[] listOrphanedUsers() {
        Delegatee delegatee = this.getDelegatee();
        try {
            String[] stringArray = delegatee.listOrphanedUsers();
            return stringArray;
        }
        finally {
            delegatee.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public String[] purgeOrphanedUsers() {
        Delegatee delegatee = this.getDelegatee();
        try {
            String[] stringArray = delegatee.purgeOrphanedUsers();
            return stringArray;
        }
        finally {
            delegatee.close();
        }
    }

    private final class Delegatee {
        private SyncHandler handler;
        private ExternalIdentityProvider idp;
        private SyncContext context;
        private UserManager userMgr;
        private Session systemSession;

        private Delegatee(@Nonnull SyncHandler handler, ExternalIdentityProvider idp) throws SyncException {
            this.handler = handler;
            this.idp = idp;
            try {
                this.systemSession = Subject.doAs(SystemSubject.INSTANCE, new PrivilegedExceptionAction<Session>(){

                    @Override
                    public Session run() throws RepositoryException {
                        if (SyncMBeanImpl.this.repository instanceof JackrabbitRepository) {
                            return ((JackrabbitRepository)SyncMBeanImpl.this.repository).login(null, null, null);
                        }
                        return SyncMBeanImpl.this.repository.login(null, null);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new SyncException(e);
            }
            try {
                this.userMgr = ((JackrabbitSession)this.systemSession).getUserManager();
                this.context = handler.createContext(idp, this.userMgr, this.systemSession.getValueFactory());
            }
            catch (Exception e) {
                this.systemSession.logout();
                throw new SyncException(e);
            }
            log.info("Created delegatee for SyncMBean with session: {} {}", (Object)this.systemSession, (Object)this.systemSession.getUserID());
        }

        private void close() {
            if (this.context != null) {
                this.context.close();
                this.context = null;
            }
            if (this.systemSession != null) {
                this.systemSession.logout();
            }
        }

        @Nonnull
        public String[] syncUsers(@Nonnull String[] userIds, boolean purge) {
            this.context.setKeepMissing(!purge).setForceGroupSync(true).setForceUserSync(true);
            ArrayList<String> result = new ArrayList<String>();
            for (String userId : userIds) {
                try {
                    SyncResult r = this.context.sync(userId);
                    this.systemSession.save();
                    result.add(SyncMBeanImpl.getJSONString(r));
                }
                catch (SyncException e) {
                    log.warn("Error while syncing user {}", (Object)userId, (Object)e);
                }
                catch (RepositoryException e) {
                    log.warn("Error while syncing user {}", (Object)userId, (Object)e);
                }
            }
            return result.toArray(new String[result.size()]);
        }

        @Nonnull
        public String[] syncAllUsers(boolean purge) {
            try {
                ArrayList<String> list = new ArrayList<String>();
                this.context.setKeepMissing(!purge).setForceGroupSync(true).setForceUserSync(true);
                Iterator<SyncedIdentity> iter = this.handler.listIdentities(this.userMgr);
                while (iter.hasNext()) {
                    SyncedIdentity id = iter.next();
                    if (!this.isMyIDP(id)) continue;
                    try {
                        SyncResult r = this.context.sync(id.getId());
                        this.systemSession.save();
                        list.add(SyncMBeanImpl.getJSONString(r));
                    }
                    catch (SyncException e) {
                        list.add(SyncMBeanImpl.getJSONString(id, e));
                    }
                    catch (RepositoryException e) {
                        list.add(SyncMBeanImpl.getJSONString(id, (Exception)((Object)e)));
                    }
                }
                return list.toArray(new String[list.size()]);
            }
            catch (RepositoryException e) {
                throw new IllegalStateException("Error retrieving users for syncing", e);
            }
        }

        @Nonnull
        public String[] syncExternalUsers(@Nonnull String[] externalIds) {
            ArrayList<String> list = new ArrayList<String>();
            this.context.setForceGroupSync(true).setForceUserSync(true);
            for (String externalId : externalIds) {
                ExternalIdentityRef ref = ExternalIdentityRef.fromString(externalId);
                try {
                    SyncResult r;
                    ExternalIdentity id = this.idp.getIdentity(ref);
                    if (id != null) {
                        r = this.context.sync(id);
                        this.systemSession.save();
                        list.add(SyncMBeanImpl.getJSONString(r));
                        continue;
                    }
                    r = new DefaultSyncResultImpl(new DefaultSyncedIdentity("", ref, false, -1L), SyncResult.Status.NO_SUCH_IDENTITY);
                    list.add(SyncMBeanImpl.getJSONString(r));
                }
                catch (ExternalIdentityException e) {
                    log.warn("error while fetching the external identity {}", (Object)externalId, (Object)e);
                    list.add(SyncMBeanImpl.getJSONString(ref, e));
                }
                catch (SyncException e) {
                    list.add(SyncMBeanImpl.getJSONString(ref, e));
                }
                catch (RepositoryException e) {
                    list.add(SyncMBeanImpl.getJSONString(ref, (Exception)((Object)e)));
                }
            }
            return list.toArray(new String[list.size()]);
        }

        @Nonnull
        public String[] syncAllExternalUsers() {
            ArrayList<String> list = new ArrayList<String>();
            this.context.setForceGroupSync(true).setForceUserSync(true);
            try {
                Iterator<ExternalUser> iter = this.idp.listUsers();
                while (iter.hasNext()) {
                    ExternalUser user = iter.next();
                    try {
                        SyncResult r = this.context.sync(user);
                        this.systemSession.save();
                        list.add(SyncMBeanImpl.getJSONString(r));
                    }
                    catch (SyncException e) {
                        list.add(SyncMBeanImpl.getJSONString(user.getExternalId(), e));
                    }
                    catch (RepositoryException e) {
                        list.add(SyncMBeanImpl.getJSONString(user.getExternalId(), (Exception)((Object)e)));
                    }
                }
                return list.toArray(new String[list.size()]);
            }
            catch (ExternalIdentityException e) {
                throw new IllegalArgumentException("Unable to retrieve external users", e);
            }
        }

        @Nonnull
        public String[] listOrphanedUsers() {
            ArrayList<String> list = new ArrayList<String>();
            try {
                Iterator<SyncedIdentity> iter = this.handler.listIdentities(this.userMgr);
                while (iter.hasNext()) {
                    ExternalIdentityRef exIdRef;
                    ExternalIdentity extId;
                    SyncedIdentity id = iter.next();
                    if (!this.isMyIDP(id) || (extId = (exIdRef = id.getExternalIdRef()) == null ? null : this.idp.getIdentity(exIdRef)) != null) continue;
                    list.add(id.getId());
                }
            }
            catch (RepositoryException e) {
                log.error("Error while listing orphaned users", (Throwable)e);
            }
            catch (ExternalIdentityException e) {
                log.error("Error while fetching external identity", (Throwable)e);
            }
            return list.toArray(new String[list.size()]);
        }

        @Nonnull
        public String[] purgeOrphanedUsers() {
            this.context.setKeepMissing(false);
            ArrayList<String> result = new ArrayList<String>();
            for (String userId : this.listOrphanedUsers()) {
                try {
                    SyncResult r = this.context.sync(userId);
                    this.systemSession.save();
                    result.add(SyncMBeanImpl.getJSONString(r));
                }
                catch (SyncException e) {
                    log.warn("Error while syncing user {}", (Object)userId, (Object)e);
                }
                catch (RepositoryException e) {
                    log.warn("Error while syncing user {}", (Object)userId, (Object)e);
                }
            }
            return result.toArray(new String[result.size()]);
        }

        private boolean isMyIDP(@Nonnull SyncedIdentity id) {
            String providerName = id.getExternalIdRef() == null ? null : id.getExternalIdRef().getProviderName();
            return providerName == null || providerName.isEmpty() || providerName.equals(this.idp.getName());
        }
    }
}

