/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.basic;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class DefaultSyncConfig {
    private final User user = new User();
    private final Group group = new Group();
    private String name = "default";

    @Nonnull
    public String getName() {
        return this.name;
    }

    public DefaultSyncConfig setName(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    public User user() {
        return this.user;
    }

    @Nonnull
    public Group group() {
        return this.group;
    }

    public static class Group
    extends Authorizable {
    }

    public static class User
    extends Authorizable {
        private long membershipExpirationTime;
        private long membershipNestingDepth;

        public long getMembershipExpirationTime() {
            return this.membershipExpirationTime;
        }

        @Nonnull
        public User setMembershipExpirationTime(long membershipExpirationTime) {
            this.membershipExpirationTime = membershipExpirationTime;
            return this;
        }

        public long getMembershipNestingDepth() {
            return this.membershipNestingDepth;
        }

        @Nonnull
        public User setMembershipNestingDepth(long membershipNestingDepth) {
            this.membershipNestingDepth = membershipNestingDepth;
            return this;
        }
    }

    public static abstract class Authorizable {
        private long expirationTime;
        private Set<String> autoMembership;
        private Map<String, String> propertyMapping;
        private String pathPrefix;

        public long getExpirationTime() {
            return this.expirationTime;
        }

        @Nonnull
        public Authorizable setExpirationTime(long expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        @Nonnull
        public Set<String> getAutoMembership() {
            return this.autoMembership == null ? Collections.emptySet() : this.autoMembership;
        }

        @Nonnull
        public Authorizable setAutoMembership(String ... autoMembership) {
            this.autoMembership = new HashSet<String>();
            for (String groupName : autoMembership) {
                if (groupName.trim().isEmpty()) continue;
                this.autoMembership.add(groupName.trim());
            }
            return this;
        }

        @Nonnull
        public Map<String, String> getPropertyMapping() {
            return this.propertyMapping == null ? Collections.emptyMap() : this.propertyMapping;
        }

        @Nonnull
        public Authorizable setPropertyMapping(Map<String, String> propertyMapping) {
            this.propertyMapping = propertyMapping;
            return this;
        }

        @Nonnull
        public String getPathPrefix() {
            return this.pathPrefix == null ? "" : this.pathPrefix;
        }

        @Nonnull
        public Authorizable setPathPrefix(String pathPrefix) {
            this.pathPrefix = pathPrefix;
            return this;
        }
    }
}

