/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal;

import java.security.Principal;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.DefaultValidator;
import org.apache.jackrabbit.oak.spi.commit.Validator;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.ExternalIdentityConstants;
import org.apache.jackrabbit.oak.spi.security.principal.SystemPrincipal;
import org.apache.jackrabbit.oak.spi.state.NodeState;

class ExternalIdentityValidatorProvider
extends ValidatorProvider
implements ExternalIdentityConstants {
    private final boolean isSystem;

    ExternalIdentityValidatorProvider(@Nonnull Set<Principal> principals) {
        this.isSystem = principals.contains(SystemPrincipal.INSTANCE);
    }

    private void checkAddModifyProperties(@Nonnull NodeState parent, @Nonnull String name, @Nonnull PropertyState propertyState) throws CommitFailedException {
        if ("rep:externalPrincipalNames".equals(name)) {
            if (!this.isSystem) {
                throw new CommitFailedException("Constraint", 70, "Attempt to create, modify or remove the system property " + name);
            }
            Type type = propertyState.getType();
            if (!Type.STRINGS.equals((Object)type) || !propertyState.isArray()) {
                throw new CommitFailedException("Constraint", 71, "Property rep:externalPrincipalNames must be multi-valued of type STRING.");
            }
            if (!parent.hasProperty("rep:externalId")) {
                throw new CommitFailedException("Constraint", 72, "Property rep:externalPrincipalNames requires rep:externalId to be present on the Node.");
            }
        }
    }

    private void checkRemoveProperties(@Nonnull NodeState parent, @Nonnull String name) throws CommitFailedException {
        if (RESERVED_PROPERTY_NAMES.contains(name)) {
            if ("rep:externalId".equals(name) && parent.hasProperty("rep:externalPrincipalNames")) {
                throw new CommitFailedException("Constraint", 73, "Property rep:externalId cannot be removed as long as rep:externalPrincipalNames is present.");
            }
            if ("rep:externalPrincipalNames".equals(name) && !this.isSystem) {
                throw new CommitFailedException("Constraint", 70, "Attempt to create, modify or remove the system property " + name);
            }
        }
    }

    protected Validator getRootValidator(@Nonnull NodeState before, @Nonnull NodeState after, @Nonnull CommitInfo info) {
        return new ExternalIdentityValidator(after);
    }

    private final class ExternalIdentityValidator
    extends DefaultValidator {
        private final NodeState parent;

        private ExternalIdentityValidator(NodeState parent) {
            this.parent = parent;
        }

        public void propertyAdded(PropertyState after) throws CommitFailedException {
            ExternalIdentityValidatorProvider.this.checkAddModifyProperties(this.parent, after.getName(), after);
        }

        public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
            ExternalIdentityValidatorProvider.this.checkAddModifyProperties(this.parent, before.getName(), after);
        }

        public void propertyDeleted(PropertyState before) throws CommitFailedException {
            ExternalIdentityValidatorProvider.this.checkRemoveProperties(this.parent, before.getName());
        }

        public Validator childNodeAdded(String name, NodeState after) throws CommitFailedException {
            return new ExternalIdentityValidator(after);
        }

        public Validator childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
            return new ExternalIdentityValidator(after);
        }

        public Validator childNodeDeleted(String name, NodeState before) throws CommitFailedException {
            return null;
        }
    }
}

