/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.security.Principal;
import java.security.acl.Group;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.api.security.principal.ItemBasedPrincipal;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.iterator.AbstractLazyIterator;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Result;
import org.apache.jackrabbit.oak.api.ResultRow;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.spi.query.PropertyValues;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityRef;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.ExternalIdentityConstants;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalImpl;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalProvider;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.apache.jackrabbit.oak.spi.security.user.util.UserUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExternalGroupPrincipalProvider
implements PrincipalProvider,
ExternalIdentityConstants {
    private static final Logger log = LoggerFactory.getLogger(ExternalGroupPrincipalProvider.class);
    private static final String BINDING_PRINCIPAL_NAMES = "principalNames";
    private final Root root;
    private final NamePathMapper namePathMapper;
    private final UserManager userManager;
    private final AutoMembershipPrincipals autoMembershipPrincipals;

    ExternalGroupPrincipalProvider(@Nonnull Root root, @Nonnull UserConfiguration uc, @Nonnull NamePathMapper namePathMapper, @Nonnull Map<String, String[]> autoMembershipMapping) {
        this.root = root;
        this.namePathMapper = namePathMapper;
        this.userManager = uc.getUserManager(root, namePathMapper);
        this.autoMembershipPrincipals = new AutoMembershipPrincipals(autoMembershipMapping);
    }

    public Principal getPrincipal(@Nonnull String principalName) {
        Result result = this.findPrincipals(principalName, true);
        if (result != null && result.getRows().iterator().hasNext()) {
            return new ExternalGroupPrincipal(principalName);
        }
        return null;
    }

    @Nonnull
    public Set<Group> getGroupMembership(@Nonnull Principal principal) {
        if (!(principal instanceof Group)) {
            try {
                if (principal instanceof ItemBasedPrincipal) {
                    Tree t = this.root.getTree(((ItemBasedPrincipal)principal).getPath());
                    return this.getGroupPrincipals(t);
                }
                return this.getGroupPrincipals(this.userManager.getAuthorizable(principal));
            }
            catch (RepositoryException e) {
                log.debug(e.getMessage());
            }
        }
        return ImmutableSet.of();
    }

    @Nonnull
    public Set<? extends Principal> getPrincipals(@Nonnull String userID) {
        try {
            return this.getGroupPrincipals(this.userManager.getAuthorizable(userID));
        }
        catch (RepositoryException e) {
            log.debug(e.getMessage());
            return ImmutableSet.of();
        }
    }

    @Nonnull
    public Iterator<? extends Principal> findPrincipals(@Nullable String nameHint, int searchType) {
        Result result;
        if (1 != searchType && (result = this.findPrincipals(Strings.nullToEmpty((String)nameHint), false)) != null) {
            return Iterators.filter((Iterator)((Object)new GroupPrincipalIterator(nameHint, result)), (Predicate)Predicates.notNull());
        }
        return Iterators.emptyIterator();
    }

    @Nonnull
    public Iterator<? extends Principal> findPrincipals(int searchType) {
        return this.findPrincipals(null, searchType);
    }

    @CheckForNull
    private String getIdpName(@Nonnull Tree userTree) {
        PropertyState ps = userTree.getProperty("rep:externalId");
        if (ps != null) {
            return ExternalIdentityRef.fromString((String)ps.getValue(Type.STRING)).getProviderName();
        }
        return null;
    }

    private Set<Group> getGroupPrincipals(@CheckForNull Authorizable authorizable) throws RepositoryException {
        if (authorizable != null && !authorizable.isGroup()) {
            Tree userTree = this.root.getTree(authorizable.getPath());
            return this.getGroupPrincipals(userTree);
        }
        return ImmutableSet.of();
    }

    private Set<Group> getGroupPrincipals(@Nonnull Tree userTree) {
        PropertyState ps;
        if (userTree.exists() && UserUtil.isType((Tree)userTree, (AuthorizableType)AuthorizableType.USER) && userTree.hasProperty("rep:externalPrincipalNames") && (ps = userTree.getProperty("rep:externalPrincipalNames")) != null) {
            HashSet groupPrincipals = Sets.newHashSet();
            for (String principalName : (Iterable)ps.getValue(Type.STRINGS)) {
                groupPrincipals.add(new ExternalGroupPrincipal(principalName));
            }
            groupPrincipals.addAll(this.autoMembershipPrincipals.get(this.getIdpName(userTree)));
            return groupPrincipals;
        }
        return ImmutableSet.of();
    }

    @CheckForNull
    private Result findPrincipals(@Nonnull String nameHint, boolean exactMatch) {
        try {
            Map<String, ? extends PropertyValue> bindings = ExternalGroupPrincipalProvider.buildBinding(nameHint, exactMatch);
            String op = exactMatch ? " = " : " LIKE ";
            String statement = "SELECT 'rep:externalPrincipalNames' FROM [rep:User] WHERE PROPERTY([rep:externalPrincipalNames], 'String')" + op + "$" + BINDING_PRINCIPAL_NAMES + " /* oak-internal */";
            return this.root.getQueryEngine().executeQuery(statement, "JCR-SQL2", Long.MAX_VALUE, 0L, bindings, this.namePathMapper.getSessionLocalMappings());
        }
        catch (ParseException e) {
            return null;
        }
    }

    @Nonnull
    private static Map<String, ? extends PropertyValue> buildBinding(@Nonnull String nameHint, boolean exactMatch) {
        String val = nameHint;
        if (!exactMatch) {
            if (nameHint.isEmpty()) {
                val = "%";
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append('%');
                sb.append(nameHint.replace("%", "\\%").replace("_", "\\_"));
                sb.append('%');
                val = sb.toString();
            }
        }
        return Collections.singletonMap(BINDING_PRINCIPAL_NAMES, PropertyValues.newString((String)val));
    }

    private final class AutoMembershipPrincipals {
        private final Map<String, String[]> autoMembershipMapping;
        private final Map<String, Set<Group>> principalMap;

        private AutoMembershipPrincipals(Map<String, String[]> autoMembershipMapping) {
            this.autoMembershipMapping = autoMembershipMapping;
            this.principalMap = new ConcurrentHashMap<String, Set<Group>>(autoMembershipMapping.size());
        }

        @Nonnull
        private Collection<Group> get(@CheckForNull String idpName) {
            ImmutableSet principals;
            if (idpName == null) {
                return ImmutableSet.of();
            }
            if (!this.principalMap.containsKey(idpName)) {
                String[] vs = this.autoMembershipMapping.get(idpName);
                if (vs == null) {
                    principals = ImmutableSet.of();
                } else {
                    ImmutableSet.Builder builder = ImmutableSet.builder();
                    for (String groupId : this.autoMembershipMapping.get(idpName)) {
                        try {
                            Authorizable gr = ExternalGroupPrincipalProvider.this.userManager.getAuthorizable(groupId);
                            if (gr != null && gr.isGroup()) {
                                Principal grPrincipal = gr.getPrincipal();
                                if (grPrincipal instanceof Group) {
                                    builder.add((Object)((Group)grPrincipal));
                                    continue;
                                }
                                log.warn("Principal of group {} is not of type java.security.acl.Group -> Ignoring", (Object)groupId);
                                continue;
                            }
                            log.warn("Configured auto-membership group {} does not exist -> Ignoring", (Object)groupId);
                        }
                        catch (RepositoryException e) {
                            log.debug("Failed to retrieved 'auto-membership' group with id {}", (Object)groupId, (Object)e);
                        }
                    }
                    principals = builder.build();
                }
                this.principalMap.put(idpName, (Set<Group>)principals);
            } else {
                principals = this.principalMap.get(idpName);
            }
            return principals;
        }
    }

    private final class MemberIterator
    extends AbstractLazyIterator<Principal> {
        private final Iterator<? extends ResultRow> rows;

        private MemberIterator(Result queryResult) {
            this.rows = queryResult.getRows().iterator();
        }

        protected Principal getNext() {
            while (this.rows.hasNext()) {
                String userPath = this.rows.next().getPath();
                try {
                    Authorizable authorizable = ExternalGroupPrincipalProvider.this.userManager.getAuthorizableByPath(userPath);
                    if (authorizable == null) continue;
                    return authorizable.getPrincipal();
                }
                catch (RepositoryException e) {
                    log.debug("{}", (Object)e.getMessage());
                }
            }
            return null;
        }
    }

    private final class GroupPrincipalIterator
    extends AbstractLazyIterator<Principal> {
        private final Set<String> processed = new HashSet<String>();
        private final String queryString;
        private final Iterator<? extends ResultRow> rows;
        private Iterator<String> propValues = Iterators.emptyIterator();

        private GroupPrincipalIterator(@Nonnull String queryString, Result queryResult) {
            this.queryString = queryString;
            this.rows = queryResult.getRows().iterator();
        }

        protected Principal getNext() {
            if (!this.propValues.hasNext()) {
                this.propValues = this.rows.hasNext() ? ((Iterable)this.rows.next().getValue("rep:externalPrincipalNames").getValue(Type.STRINGS)).iterator() : Iterators.emptyIterator();
            }
            while (this.propValues.hasNext()) {
                String principalName = this.propValues.next();
                if (principalName == null || this.processed.contains(principalName) || !this.matchesQuery(principalName)) continue;
                this.processed.add(principalName);
                return new ExternalGroupPrincipal(principalName);
            }
            return null;
        }

        private boolean matchesQuery(@Nonnull String principalName) {
            if (this.queryString == null) {
                return true;
            }
            return principalName.contains(this.queryString);
        }
    }

    private final class ExternalGroupPrincipal
    extends PrincipalImpl
    implements Group {
        public ExternalGroupPrincipal(String principalName) {
            super(principalName);
        }

        public boolean addMember(Principal user) {
            if (this.isMember(user)) {
                return false;
            }
            throw new UnsupportedOperationException("Adding members to external group principals is not supported.");
        }

        public boolean removeMember(Principal user) {
            if (!this.isMember(user)) {
                return false;
            }
            throw new UnsupportedOperationException("Removing members from external group principals is not supported.");
        }

        public boolean isMember(Principal member) {
            if (member instanceof Group) {
                return false;
            }
            try {
                String name = this.getName();
                if (member instanceof ItemBasedPrincipal) {
                    Tree tree = ExternalGroupPrincipalProvider.this.root.getTree(((ItemBasedPrincipal)member).getPath());
                    if (UserUtil.isType((Tree)tree, (AuthorizableType)AuthorizableType.USER)) {
                        PropertyState ps = tree.getProperty("rep:externalPrincipalNames");
                        return ps != null && Iterables.contains((Iterable)((Iterable)ps.getValue(Type.STRINGS)), (Object)name);
                    }
                } else {
                    Value[] vs;
                    Authorizable a = ExternalGroupPrincipalProvider.this.userManager.getAuthorizable(member);
                    if (a != null && !a.isGroup() && (vs = a.getProperty("rep:externalPrincipalNames")) != null) {
                        for (Value v : vs) {
                            if (!name.equals(v.getString())) continue;
                            return true;
                        }
                    }
                }
            }
            catch (RepositoryException e) {
                log.debug(e.getMessage());
            }
            return false;
        }

        public Enumeration<? extends Principal> members() {
            Result result = ExternalGroupPrincipalProvider.this.findPrincipals(this.getName(), true);
            if (result != null) {
                return Iterators.asEnumeration((Iterator)((Object)new MemberIterator(result)));
            }
            return Iterators.asEnumeration((Iterator)Iterators.emptyIterator());
        }
    }
}

