/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.iterator.AbstractLazyIterator;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalGroup;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentity;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityException;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityRef;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalUser;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncContext;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncException;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncHandler;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncResult;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncedIdentity;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.DebugTimer;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.DefaultSyncConfig;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.SyncResultImpl;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.SyncedIdentityImpl;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(policy=ConfigurationPolicy.REQUIRE)
@Service
public class DefaultSyncHandler
implements SyncHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultSyncHandler.class);
    public static final String REP_EXTERNAL_ID = "rep:externalId";
    public static final String REP_LAST_SYNCED = "rep:lastSynced";
    private DefaultSyncConfig config;

    public DefaultSyncHandler() {
    }

    public DefaultSyncHandler(DefaultSyncConfig config) {
        this.config = config;
    }

    @Activate
    private void activate(Map<String, Object> properties) {
        ConfigurationParameters cfg = ConfigurationParameters.of(properties);
        this.config = DefaultSyncConfig.of(cfg);
    }

    @Override
    @Nonnull
    public String getName() {
        return this.config.getName();
    }

    @Override
    @Nonnull
    public SyncContext createContext(@Nonnull ExternalIdentityProvider idp, @Nonnull UserManager userManager, @Nonnull ValueFactory valueFactory) throws SyncException {
        return new ContextImpl(idp, userManager, valueFactory);
    }

    @Override
    public SyncedIdentity findIdentity(@Nonnull UserManager userManager, @Nonnull String id) throws RepositoryException {
        return DefaultSyncHandler.createSyncedIdentity(userManager.getAuthorizable(id));
    }

    @Override
    public Iterator<SyncedIdentity> listIdentities(@Nonnull UserManager userManager) throws RepositoryException {
        final Iterator iter = userManager.findAuthorizables("jcr:primaryType", null);
        return new AbstractLazyIterator<SyncedIdentity>(){

            protected SyncedIdentity getNext() {
                while (iter.hasNext()) {
                    try {
                        SyncedIdentityImpl id = DefaultSyncHandler.createSyncedIdentity((Authorizable)iter.next());
                        if (id == null) continue;
                        return id;
                    }
                    catch (RepositoryException e) {
                        log.error("Error while fetching authorizables", (Throwable)e);
                        break;
                    }
                }
                return null;
            }
        };
    }

    @CheckForNull
    private static SyncedIdentityImpl createSyncedIdentity(@Nullable Authorizable auth) throws RepositoryException {
        ExternalIdentityRef ref;
        ExternalIdentityRef externalIdentityRef = ref = auth == null ? null : DefaultSyncHandler.getIdentityRef(auth);
        if (ref == null) {
            return null;
        }
        Value[] lmValues = auth.getProperty(REP_LAST_SYNCED);
        long lastModified = -1L;
        if (lmValues != null && lmValues.length > 0) {
            lastModified = lmValues[0].getLong();
        }
        return new SyncedIdentityImpl(auth.getID(), ref, auth.isGroup(), lastModified);
    }

    @CheckForNull
    private static ExternalIdentityRef getIdentityRef(@Nullable Authorizable auth) throws RepositoryException {
        if (auth == null) {
            return null;
        }
        Value[] v = auth.getProperty(REP_EXTERNAL_ID);
        if (v == null || v.length == 0) {
            return null;
        }
        return ExternalIdentityRef.fromString(v[0].getString());
    }

    private static String joinPaths(String ... paths) {
        StringBuilder result = new StringBuilder();
        for (String path : paths) {
            int i0;
            if (path == null || path.isEmpty()) continue;
            int i1 = path.length();
            for (i0 = 0; i0 < i1 && path.charAt(i0) == '/'; ++i0) {
            }
            while (i1 > i0 && path.charAt(i1 - 1) == '/') {
                --i1;
            }
            if (i1 <= i0) continue;
            if (result.length() > 0) {
                result.append('/');
            }
            result.append(path.substring(i0, i1));
        }
        return result.length() == 0 ? null : result.toString();
    }

    private class ContextImpl
    implements SyncContext {
        private final ExternalIdentityProvider idp;
        private final UserManager userManager;
        private final ValueFactory valueFactory;
        private boolean keepMissing;
        private boolean forceUserSync;
        private boolean forceGroupSync;
        private final long now;
        private final Value nowValue;

        private ContextImpl(ExternalIdentityProvider idp, UserManager userManager, ValueFactory valueFactory) {
            this.idp = idp;
            this.userManager = userManager;
            this.valueFactory = valueFactory;
            Calendar nowCal = Calendar.getInstance();
            this.nowValue = valueFactory.createValue(nowCal);
            this.now = nowCal.getTimeInMillis();
        }

        @Override
        public void close() {
        }

        @Override
        public boolean isKeepMissing() {
            return this.keepMissing;
        }

        @Override
        public SyncContext setKeepMissing(boolean keepMissing) {
            this.keepMissing = keepMissing;
            return this;
        }

        @Override
        public boolean isForceUserSync() {
            return this.forceUserSync;
        }

        @Override
        public SyncContext setForceUserSync(boolean forceUserSync) {
            this.forceUserSync = forceUserSync;
            return this;
        }

        @Override
        public boolean isForceGroupSync() {
            return this.forceGroupSync;
        }

        @Override
        public SyncContext setForceGroupSync(boolean forceGroupSync) {
            this.forceGroupSync = forceGroupSync;
            return this;
        }

        @Override
        public SyncResult sync(@Nonnull ExternalIdentity identity) throws SyncException {
            try {
                SyncResultImpl ret;
                DebugTimer timer = new DebugTimer();
                boolean created = false;
                if (identity instanceof ExternalUser) {
                    User user = this.getAuthorizable(identity, User.class);
                    timer.mark("find");
                    if (user == null) {
                        user = this.createUser((ExternalUser)identity);
                        timer.mark("create");
                        created = true;
                    }
                    ret = this.syncUser((ExternalUser)identity, user);
                    timer.mark("sync");
                } else if (identity instanceof ExternalGroup) {
                    Group group = this.getAuthorizable(identity, Group.class);
                    timer.mark("find");
                    if (group == null) {
                        group = this.createGroup((ExternalGroup)identity);
                        timer.mark("create");
                        created = true;
                    }
                    ret = this.syncGroup((ExternalGroup)identity, group);
                    timer.mark("sync");
                } else {
                    throw new IllegalArgumentException("identity must be user or group but was: " + identity);
                }
                if (log.isDebugEnabled()) {
                    log.debug("sync({}) -> {} {}", new Object[]{identity.getExternalId().getString(), identity.getId(), timer.getString()});
                }
                if (created) {
                    ret.setStatus(SyncResult.Status.ADD);
                }
                return ret;
            }
            catch (RepositoryException e) {
                throw new SyncException(e);
            }
        }

        @Override
        public SyncResult sync(@Nonnull String id) throws SyncException {
            try {
                SyncResultImpl ret;
                DebugTimer timer = new DebugTimer();
                Authorizable auth = this.userManager.getAuthorizable(id);
                if (auth == null) {
                    return new SyncResultImpl(new SyncedIdentityImpl(id, null, false, -1L), SyncResult.Status.NO_SUCH_AUTHORIZABLE);
                }
                ExternalIdentityRef ref = DefaultSyncHandler.getIdentityRef(auth);
                if (ref == null || !this.idp.getName().equals(ref.getProviderName())) {
                    return new SyncResultImpl(new SyncedIdentityImpl(id, null, false, -1L), SyncResult.Status.FOREIGN);
                }
                if (auth instanceof Group) {
                    Group group = (Group)auth;
                    ExternalGroup external = this.idp.getGroup(id);
                    timer.mark("retrieve");
                    if (external == null) {
                        SyncedIdentityImpl syncId = DefaultSyncHandler.createSyncedIdentity(auth);
                        if (group.getDeclaredMembers().hasNext()) {
                            log.info("won't remove local group with members: {}", (Object)id);
                            ret = new SyncResultImpl(syncId, SyncResult.Status.NOP);
                        } else if (!this.keepMissing) {
                            auth.remove();
                            log.debug("removing authorizable '{}' that no longer exists on IDP {}", (Object)id, (Object)this.idp.getName());
                            timer.mark("remove");
                            ret = new SyncResultImpl(syncId, SyncResult.Status.DELETE);
                        } else {
                            ret = new SyncResultImpl(syncId, SyncResult.Status.MISSING);
                            log.info("external identity missing for {}, but purge == false.", (Object)id);
                        }
                    } else {
                        ret = this.syncGroup(external, group);
                        timer.mark("sync");
                    }
                } else {
                    ExternalUser external = this.idp.getUser(id);
                    timer.mark("retrieve");
                    if (external == null) {
                        SyncedIdentityImpl syncId = DefaultSyncHandler.createSyncedIdentity(auth);
                        if (!this.keepMissing) {
                            auth.remove();
                            log.debug("removing authorizable '{}' that no longer exists on IDP {}", (Object)id, (Object)this.idp.getName());
                            timer.mark("remove");
                            ret = new SyncResultImpl(syncId, SyncResult.Status.DELETE);
                        } else {
                            ret = new SyncResultImpl(syncId, SyncResult.Status.MISSING);
                            log.info("external identity missing for {}, but purge == false.", (Object)id);
                        }
                    } else {
                        ret = this.syncUser(external, (User)auth);
                        timer.mark("sync");
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("sync({}) -> {} {}", new Object[]{id, ref.getString(), timer.getString()});
                }
                return ret;
            }
            catch (RepositoryException e) {
                throw new SyncException(e);
            }
            catch (ExternalIdentityException e) {
                throw new SyncException(e);
            }
        }

        @CheckForNull
        private <T extends Authorizable> T getAuthorizable(@Nonnull ExternalIdentity external, Class<T> type) throws RepositoryException, SyncException {
            Authorizable authorizable = this.userManager.getAuthorizable(external.getId());
            if (authorizable == null) {
                authorizable = this.userManager.getAuthorizable(external.getPrincipalName());
            }
            if (authorizable == null) {
                return null;
            }
            if (type.isInstance(authorizable)) {
                return (T)authorizable;
            }
            log.error("Unable to process external {}: {}. Colliding authorizable exists in repository.", (Object)type.getSimpleName(), (Object)external.getId());
            throw new SyncException("Unexpected authorizable: " + authorizable);
        }

        @CheckForNull
        private User createUser(ExternalUser externalUser) throws RepositoryException {
            PrincipalImpl principal = new PrincipalImpl(externalUser.getPrincipalName());
            User user = this.userManager.createUser(externalUser.getId(), null, (Principal)principal, DefaultSyncHandler.joinPaths(new String[]{DefaultSyncHandler.this.config.user().getPathPrefix(), externalUser.getIntermediatePath()}));
            user.setProperty(DefaultSyncHandler.REP_EXTERNAL_ID, this.valueFactory.createValue(externalUser.getExternalId().getString()));
            return user;
        }

        @CheckForNull
        private Group createGroup(ExternalGroup externalGroup) throws RepositoryException {
            PrincipalImpl principal = new PrincipalImpl(externalGroup.getPrincipalName());
            Group group = this.userManager.createGroup(externalGroup.getId(), (Principal)principal, DefaultSyncHandler.joinPaths(new String[]{DefaultSyncHandler.this.config.group().getPathPrefix(), externalGroup.getIntermediatePath()}));
            group.setProperty(DefaultSyncHandler.REP_EXTERNAL_ID, this.valueFactory.createValue(externalGroup.getExternalId().getString()));
            return group;
        }

        private SyncResultImpl syncUser(@Nonnull ExternalUser external, @Nonnull User user) throws RepositoryException {
            if (!this.forceUserSync && !this.isExpired((Authorizable)user, DefaultSyncHandler.this.config.user().getExpirationTime(), "Properties")) {
                SyncedIdentityImpl syncId = DefaultSyncHandler.createSyncedIdentity((Authorizable)user);
                return new SyncResultImpl(syncId, SyncResult.Status.NOP);
            }
            this.syncProperties(external, (Authorizable)user, DefaultSyncHandler.this.config.user().getPropertyMapping());
            this.applyMembership((Authorizable)user, DefaultSyncHandler.this.config.user().getAutoMembership());
            if (this.isExpired((Authorizable)user, DefaultSyncHandler.this.config.user().getMembershipExpirationTime(), "Membership")) {
                this.syncMembership(external, (Authorizable)user, DefaultSyncHandler.this.config.user().getMembershipNestingDepth());
            }
            user.setProperty(DefaultSyncHandler.REP_LAST_SYNCED, this.nowValue);
            SyncedIdentityImpl syncId = DefaultSyncHandler.createSyncedIdentity((Authorizable)user);
            return new SyncResultImpl(syncId, SyncResult.Status.UPDATE);
        }

        private SyncResultImpl syncGroup(ExternalGroup external, Group group) throws RepositoryException {
            if (!this.forceGroupSync && !this.isExpired((Authorizable)group, DefaultSyncHandler.this.config.group().getExpirationTime(), "Properties")) {
                SyncedIdentityImpl syncId = DefaultSyncHandler.createSyncedIdentity((Authorizable)group);
                return new SyncResultImpl(syncId, SyncResult.Status.NOP);
            }
            this.syncProperties(external, (Authorizable)group, DefaultSyncHandler.this.config.group().getPropertyMapping());
            this.applyMembership((Authorizable)group, DefaultSyncHandler.this.config.group().getAutoMembership());
            group.setProperty(DefaultSyncHandler.REP_LAST_SYNCED, this.nowValue);
            SyncedIdentityImpl syncId = DefaultSyncHandler.createSyncedIdentity((Authorizable)group);
            return new SyncResultImpl(syncId, SyncResult.Status.UPDATE);
        }

        private void syncMembership(ExternalIdentity external, Authorizable auth, long depth) throws RepositoryException {
            Iterable<ExternalIdentityRef> externalGroups;
            if (depth <= 0L) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Syncing membership '{}' -> '{}'", (Object)external.getExternalId().getString(), (Object)auth.getID());
            }
            DebugTimer timer = new DebugTimer();
            try {
                externalGroups = external.getDeclaredGroups();
            }
            catch (ExternalIdentityException e) {
                log.error("Error while retrieving external declared groups for '{}'", (Object)external.getId(), (Object)e);
                return;
            }
            timer.mark("fetching");
            HashMap<String, Group> declaredExternalGroups = new HashMap<String, Group>();
            Iterator grpIter = auth.declaredMemberOf();
            while (grpIter.hasNext()) {
                Group grp = (Group)grpIter.next();
                if (!this.isSameIDP((Authorizable)grp)) continue;
                declaredExternalGroups.put(grp.getID(), grp);
            }
            timer.mark("reading");
            for (ExternalIdentityRef ref : externalGroups) {
                Group grp;
                ExternalGroup extGroup;
                log.debug("- processing membership {}", (Object)ref.getId());
                try {
                    extGroup = (ExternalGroup)this.idp.getIdentity(ref);
                }
                catch (ClassCastException e) {
                    log.warn("External identity '{}' is not a group, but should be one.", (Object)ref.getString());
                    continue;
                }
                catch (ExternalIdentityException e) {
                    log.warn("Unable to retrieve external group '{}' from provider.", (Object)ref.getString(), (Object)e);
                    continue;
                }
                if (extGroup == null) {
                    log.warn("External group for ref '{}' could not be retrieved from provider.", (Object)ref);
                    continue;
                }
                log.debug("- idp returned '{}'", (Object)extGroup.getId());
                try {
                    grp = (Group)this.userManager.getAuthorizable(extGroup.getId());
                }
                catch (ClassCastException e) {
                    log.warn("Authorizable '{}' is not a group, but should be one.", (Object)extGroup.getId());
                    continue;
                }
                log.debug("- user manager returned '{}'", (Object)grp);
                if (grp == null) {
                    grp = this.createGroup(extGroup);
                    log.debug("- created new group");
                }
                this.syncGroup(extGroup, grp);
                grp.addMember(auth);
                log.debug("- added '{}' as member to '{}'", (Object)auth, (Object)grp);
                declaredExternalGroups.remove(grp.getID());
                if (depth > 1L) {
                    log.debug("- recursively sync group membership of '{}' (depth = {}).", (Object)grp.getID(), (Object)depth);
                    this.syncMembership(extGroup, (Authorizable)grp, depth - 1L);
                    continue;
                }
                log.debug("- group nesting level for '{}' reached", (Object)grp.getID());
            }
            timer.mark("adding");
            for (Group grp : declaredExternalGroups.values()) {
                grp.removeMember(auth);
                log.debug("- removing member '{}' for group '{}'", (Object)auth.getID(), (Object)grp.getID());
            }
            if (log.isDebugEnabled()) {
                timer.mark("removing");
                log.debug("syncMembership({}) {}", (Object)external.getId(), (Object)timer.getString());
            }
        }

        private void applyMembership(Authorizable member, Set<String> groups) throws RepositoryException {
            for (String groupName : groups) {
                Authorizable group = this.userManager.getAuthorizable(groupName);
                if (group == null) {
                    log.warn("Unable to apply auto-membership to {}. No such group: {}", (Object)member.getID(), (Object)groupName);
                    continue;
                }
                if (group instanceof Group) {
                    ((Group)group).addMember(member);
                    continue;
                }
                log.warn("Unable to apply auto-membership to {}. Authorizable '{}' is not a group.", (Object)member.getID(), (Object)groupName);
            }
        }

        private void syncProperties(ExternalIdentity ext, Authorizable auth, Map<String, String> mapping) throws RepositoryException {
            Map<String, ?> properties = ext.getProperties();
            for (Map.Entry<String, String> entry : mapping.entrySet()) {
                String relPath = entry.getKey();
                String name = entry.getValue();
                Object obj = properties.get(name);
                if (obj == null) {
                    int nameLen = name.length();
                    if (nameLen > 1 && name.charAt(0) == '\"' && name.charAt(nameLen - 1) == '\"') {
                        auth.setProperty(relPath, this.valueFactory.createValue(name.substring(1, nameLen - 1)));
                        continue;
                    }
                    auth.removeProperty(relPath);
                    continue;
                }
                if (obj instanceof Collection) {
                    auth.setProperty(relPath, this.createValues((Collection)obj));
                    continue;
                }
                if (obj instanceof byte[] || obj instanceof char[]) {
                    auth.setProperty(relPath, this.createValue(obj));
                    continue;
                }
                if (obj instanceof Object[]) {
                    auth.setProperty(relPath, this.createValues(Arrays.asList((Object[])obj)));
                    continue;
                }
                auth.setProperty(relPath, this.createValue(obj));
            }
        }

        private boolean isExpired(Authorizable auth, long expirationTime, String type) throws RepositoryException {
            Value[] values = auth.getProperty(DefaultSyncHandler.REP_LAST_SYNCED);
            if (values == null || values.length == 0) {
                if (log.isDebugEnabled()) {
                    log.debug("{} of {} '{}' need sync. rep:lastSynced not set.", new Object[]{type, auth.isGroup() ? "group" : "user", auth.getID()});
                }
                return true;
            }
            if (this.now - values[0].getLong() > expirationTime) {
                if (log.isDebugEnabled()) {
                    log.debug("{} of {} '{}' need sync. rep:lastSynced expired ({} > {})", new Object[]{type, auth.isGroup() ? "group" : "user", auth.getID(), this.now - values[0].getLong(), expirationTime});
                }
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug("{} of {} '{}' do not need sync.", new Object[]{type, auth.isGroup() ? "group" : "user", auth.getID()});
            }
            return false;
        }

        @CheckForNull
        private Value createValue(@Nullable Object v) throws RepositoryException {
            if (v == null) {
                return null;
            }
            if (v instanceof Boolean) {
                return this.valueFactory.createValue(((Boolean)v).booleanValue());
            }
            if (v instanceof Byte || v instanceof Short || v instanceof Integer || v instanceof Long) {
                return this.valueFactory.createValue(((Number)v).longValue());
            }
            if (v instanceof Float || v instanceof Double) {
                return this.valueFactory.createValue(((Number)v).doubleValue());
            }
            if (v instanceof BigDecimal) {
                return this.valueFactory.createValue((BigDecimal)v);
            }
            if (v instanceof Calendar) {
                return this.valueFactory.createValue((Calendar)v);
            }
            if (v instanceof Date) {
                Calendar cal = Calendar.getInstance();
                cal.setTime((Date)v);
                return this.valueFactory.createValue(cal);
            }
            if (v instanceof byte[]) {
                Binary bin = this.valueFactory.createBinary((InputStream)new ByteArrayInputStream((byte[])v));
                return this.valueFactory.createValue(bin);
            }
            if (v instanceof char[]) {
                return this.valueFactory.createValue(new String((char[])v));
            }
            return this.valueFactory.createValue(String.valueOf(v));
        }

        @CheckForNull
        private Value[] createValues(Collection<?> propValues) throws RepositoryException {
            ArrayList<Value> values = new ArrayList<Value>();
            for (Object obj : propValues) {
                Value v = this.createValue(obj);
                if (v == null) continue;
                values.add(v);
            }
            return values.toArray(new Value[values.size()]);
        }

        private boolean isSameIDP(@Nullable Authorizable auth) throws RepositoryException {
            ExternalIdentityRef ref = DefaultSyncHandler.getIdentityRef(auth);
            return ref != null && this.idp.getName().equals(ref.getProviderName());
        }
    }
}

