/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.api.AuthInfo;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.authentication.AbstractLoginModule;
import org.apache.jackrabbit.oak.spi.security.authentication.AuthInfoImpl;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityException;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityProviderManager;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalUser;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncContext;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncException;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncHandler;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncManager;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalLoginModule
extends AbstractLoginModule {
    private static final Logger log = LoggerFactory.getLogger(ExternalLoginModule.class);
    public static final String PARAM_IDP_NAME = "idp.name";
    public static final String PARAM_SYNC_HANDLER_NAME = "sync.handlerName";
    private ConfigurationParameters osgiConfig;
    private ExternalIdentityProvider idp;
    private SyncHandler syncHandler;
    private ExternalUser externalUser;
    private Credentials credentials;

    public ExternalLoginModule() {
    }

    public ExternalLoginModule(ConfigurationParameters osgiConfig) {
        this.osgiConfig = osgiConfig;
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> ss, Map<String, ?> opts) {
        Whiteboard whiteboard;
        super.initialize(subject, callbackHandler, ss, opts);
        if (this.osgiConfig != null) {
            this.options = ConfigurationParameters.of((ConfigurationParameters[])new ConfigurationParameters[]{this.osgiConfig, this.options});
        }
        if ((whiteboard = this.getWhiteboard()) == null) {
            log.error("External login module needs whiteboard. Will not be used for login.");
            return;
        }
        String idpName = (String)this.options.getConfigValue(PARAM_IDP_NAME, (Object)"");
        if (idpName.length() == 0) {
            log.error("External login module needs IPD name. Will not be used for login.");
        } else {
            ExternalIdentityProviderManager idpMgr = (ExternalIdentityProviderManager)WhiteboardUtils.getService((Whiteboard)whiteboard, ExternalIdentityProviderManager.class);
            if (idpMgr == null) {
                log.error("External login module needs IDPManager. Will not be used for login.");
            } else {
                this.idp = idpMgr.getProvider(idpName);
                if (this.idp == null) {
                    log.error("No IDP found with name {}. Will not be used for login.", (Object)idpName);
                }
            }
        }
        String syncHandlerName = (String)this.options.getConfigValue(PARAM_SYNC_HANDLER_NAME, (Object)"");
        if (syncHandlerName.length() == 0) {
            log.error("External login module needs SyncHandler name. Will not be used for login.");
        } else {
            SyncManager syncMgr = (SyncManager)WhiteboardUtils.getService((Whiteboard)whiteboard, SyncManager.class);
            if (syncMgr == null) {
                log.error("External login module needs SyncManager. Will not be used for login.");
            } else {
                this.syncHandler = syncMgr.getSyncHandler(syncHandlerName);
                if (this.syncHandler == null) {
                    log.error("No SyncHandler found with name {}. Will not be used for login.", (Object)syncHandlerName);
                }
            }
        }
    }

    public boolean login() throws LoginException {
        if (this.idp == null || this.syncHandler == null) {
            return false;
        }
        this.credentials = this.getCredentials();
        if (this.credentials == null) {
            log.debug("No credentials found for external login module. ignoring.");
            return false;
        }
        try {
            this.externalUser = this.idp.authenticate(this.credentials);
            if (this.externalUser != null) {
                if (log.isDebugEnabled()) {
                    log.debug("IDP {} returned valid user {}", (Object)this.idp.getName(), (Object)this.externalUser);
                }
                this.sharedState.put("org.apache.jackrabbit.credentials", this.credentials);
                this.sharedState.put("javax.security.auth.login.name", this.externalUser.getId());
                return true;
            }
            if (log.isDebugEnabled()) {
                if (this.credentials instanceof SimpleCredentials) {
                    log.debug("IDP {} returned null for simple creds of {}", (Object)this.idp.getName(), (Object)((SimpleCredentials)this.credentials).getUserID());
                } else {
                    log.debug("IDP {} returned null for {}", (Object)this.idp.getName(), (Object)this.credentials);
                }
            }
        }
        catch (ExternalIdentityException e) {
            log.error("Error while authenticating credentials {} with {}: {}", new Object[]{this.credentials, this.idp.getName(), e.toString()});
            return false;
        }
        catch (LoginException e) {
            if (log.isDebugEnabled()) {
                log.debug("IDP {} throws login exception for {}", (Object)this.idp.getName(), (Object)this.credentials);
            }
            throw e;
        }
        return false;
    }

    protected Set<Class> getSupportedCredentials() {
        Class<SimpleCredentials> scClass = SimpleCredentials.class;
        return Collections.singleton(scClass);
    }

    public boolean commit() throws LoginException {
        if (this.externalUser == null || this.syncHandler == null) {
            return false;
        }
        SyncContext context = null;
        try {
            Root root = this.getRoot();
            UserManager userManager = this.getUserManager();
            if (root == null || userManager == null) {
                throw new LoginException("Cannot synchronize user.");
            }
            context = this.syncHandler.createContext(this.idp, userManager, root);
            context.sync(this.externalUser);
            root.commit();
            Set principals = this.getPrincipals(this.externalUser.getId());
            if (!principals.isEmpty()) {
                if (!this.subject.isReadOnly()) {
                    this.subject.getPrincipals().addAll(principals);
                    this.subject.getPublicCredentials().add(this.credentials);
                    ExternalLoginModule.setAuthInfo((AuthInfo)new AuthInfoImpl(this.externalUser.getId(), null, principals), (Subject)this.subject);
                } else {
                    log.debug("Could not add information to read only subject {}", (Object)this.subject);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SyncException e) {
            throw new LoginException("User synchronization failed: " + e);
        }
        catch (CommitFailedException e) {
            throw new LoginException("User synchronization failed: " + (Object)((Object)e));
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    protected void clearState() {
        super.clearState();
        this.externalUser = null;
        this.credentials = null;
    }
}

