/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.api;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.Blob;

public final class Type<T>
implements Comparable<Type<?>> {
    private static final Map<String, Type<?>> TYPES = new HashMap();
    public static final Type<String> STRING = Type.create(1, false, "STRING");
    public static final Type<Blob> BINARY = Type.create(2, false, "BINARY");
    public static final Type<Long> LONG = Type.create(3, false, "LONG");
    public static final Type<Double> DOUBLE = Type.create(4, false, "DOUBLE");
    public static final Type<String> DATE = Type.create(5, false, "DATE");
    public static final Type<Boolean> BOOLEAN = Type.create(6, false, "BOOLEAN");
    public static final Type<String> NAME = Type.create(7, false, "NAME");
    public static final Type<String> PATH = Type.create(8, false, "PATH");
    public static final Type<String> REFERENCE = Type.create(9, false, "REFERENCE");
    public static final Type<String> WEAKREFERENCE = Type.create(10, false, "WEAKREFERENCE");
    public static final Type<String> URI = Type.create(11, false, "URI");
    public static final Type<BigDecimal> DECIMAL = Type.create(12, false, "DECIMAL");
    public static final Type<Iterable<String>> STRINGS = Type.create(1, true, "STRINGS");
    public static final Type<Iterable<Blob>> BINARIES = Type.create(2, true, "BINARIES");
    public static final Type<Iterable<Long>> LONGS = Type.create(3, true, "LONGS");
    public static final Type<Iterable<Double>> DOUBLES = Type.create(4, true, "DOUBLES");
    public static final Type<Iterable<String>> DATES = Type.create(5, true, "DATES");
    public static final Type<Iterable<Boolean>> BOOLEANS = Type.create(6, true, "BOOLEANS");
    public static final Type<Iterable<String>> NAMES = Type.create(7, true, "NAMES");
    public static final Type<Iterable<String>> PATHS = Type.create(8, true, "PATHS");
    public static final Type<Iterable<String>> REFERENCES = Type.create(9, true, "REFERENCES");
    public static final Type<Iterable<String>> WEAKREFERENCES = Type.create(10, true, "WEAKREFERENCES");
    public static final Type<Iterable<String>> URIS = Type.create(11, true, "URIS");
    public static final Type<Iterable<BigDecimal>> DECIMALS = Type.create(12, true, "DECIMALS");
    public static final Type<Void> UNDEFINED = Type.create(0, false, "UNDEFINED");
    public static final Type<Iterable<Void>> UNDEFINEDS = Type.create(0, true, "UNDEFINEDS");
    private final int tag;
    private final boolean array;
    private final String string;

    private static <T> Type<T> create(int tag, boolean array, String string) {
        Type<T> type = new Type<T>(tag, array, string);
        TYPES.put(string, type);
        return type;
    }

    private Type(int tag, boolean array, String string) {
        this.tag = tag;
        this.array = array;
        this.string = string;
    }

    public int tag() {
        return this.tag;
    }

    public boolean isArray() {
        return this.array;
    }

    public static Type<?> fromTag(int tag, boolean array) {
        switch (tag) {
            case 1: {
                return array ? STRINGS : STRING;
            }
            case 2: {
                return array ? BINARIES : BINARY;
            }
            case 3: {
                return array ? LONGS : LONG;
            }
            case 4: {
                return array ? DOUBLES : DOUBLE;
            }
            case 5: {
                return array ? DATES : DATE;
            }
            case 6: {
                return array ? BOOLEANS : BOOLEAN;
            }
            case 7: {
                return array ? NAMES : NAME;
            }
            case 8: {
                return array ? PATHS : PATH;
            }
            case 9: {
                return array ? REFERENCES : REFERENCE;
            }
            case 10: {
                return array ? WEAKREFERENCES : WEAKREFERENCE;
            }
            case 11: {
                return array ? URIS : URI;
            }
            case 12: {
                return array ? DECIMALS : DECIMAL;
            }
            case 0: {
                return array ? UNDEFINEDS : UNDEFINED;
            }
        }
        throw new IllegalArgumentException("Invalid type tag: " + tag);
    }

    public static Type<?> fromString(String string) {
        Type<?> type = TYPES.get(string);
        if (type == null) {
            throw new IllegalArgumentException("Invalid type name: " + string);
        }
        return type;
    }

    public Type<?> getBaseType() {
        this.checkState(this.isArray(), "Not an array");
        return Type.fromTag(this.tag, false);
    }

    public Type<?> getArrayType() {
        this.checkState(!this.isArray(), "Not a simply type");
        return Type.fromTag(this.tag, true);
    }

    @Override
    public int compareTo(@Nonnull Type<?> that) {
        if (this.tag < that.tag) {
            return -1;
        }
        if (this.tag > that.tag) {
            return 1;
        }
        if (!this.array && that.array) {
            return -1;
        }
        if (this.array && !that.array) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.string;
    }

    public int hashCode() {
        int result = 1;
        result += 31 * this.tag;
        return result += 31 * this.hashCode(this.array);
    }

    private int hashCode(boolean value) {
        return value ? 1231 : 1237;
    }

    private void checkState(boolean condition, String message) {
        if (!condition) {
            throw new IllegalStateException(message);
        }
    }

    public boolean equals(Object other) {
        return this == other;
    }
}

