/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.extractor;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.jackrabbit.extractor.AbstractTextExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.textmining.text.extraction.WordExtractor;

public class MsWordTextExtractor
extends AbstractTextExtractor {
    private static final Logger logger = LoggerFactory.getLogger((Class)MsWordTextExtractor.class);

    public MsWordTextExtractor() {
        super(new String[]{"application/vnd.ms-word", "application/msword"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader extractText(InputStream stream, String type, String encoding) throws IOException {
        try {
            WordExtractor extractor = new WordExtractor();
            String text = extractor.extractText(stream);
            StringReader stringReader = new StringReader(text);
            return stringReader;
        }
        catch (Exception e) {
            logger.warn("Failed to extract Word text content", (Throwable)e);
            StringReader stringReader = new StringReader("");
            return stringReader;
        }
        finally {
            stream.close();
        }
    }

    static {
        WordExtractor.class.getName();
    }
}

