/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.jcr;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Item;
import javax.jcr.Property;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jackrabbit.server.io.IOUtil;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceIteratorImpl;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.io.InputContext;
import org.apache.jackrabbit.webdav.io.OutputContext;
import org.apache.jackrabbit.webdav.jcr.AbstractItemResource;
import org.apache.jackrabbit.webdav.jcr.JcrDavException;
import org.apache.jackrabbit.webdav.jcr.JcrDavSession;
import org.apache.jackrabbit.webdav.jcr.property.LengthsProperty;
import org.apache.jackrabbit.webdav.jcr.property.ValuesProperty;
import org.apache.jackrabbit.webdav.lock.ActiveLock;
import org.apache.jackrabbit.webdav.lock.Scope;
import org.apache.jackrabbit.webdav.lock.Type;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class DefaultItemResource
extends AbstractItemResource {
    private static Logger log = LoggerFactory.getLogger((Class)DefaultItemResource.class);

    public DefaultItemResource(DavResourceLocator locator, JcrDavSession session, DavResourceFactory factory, Item item) {
        super(locator, session, factory, item);
    }

    public boolean isCollection() {
        return false;
    }

    public long getModificationTime() {
        return new Date().getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spool(OutputContext outputContext) throws IOException {
        super.spool(outputContext);
        InputStream in = null;
        try {
            OutputStream out = outputContext.getOutputStream();
            if (out != null && this.exists()) {
                if (this.isMultiple()) {
                    Document doc = DomUtil.BUILDER_FACTORY.newDocumentBuilder().newDocument();
                    doc.appendChild(this.getProperty(JCR_VALUES).toXml(doc));
                    OutputFormat format = new OutputFormat("xml", "UTF-8", false);
                    XMLSerializer serializer = new XMLSerializer(out, format);
                    serializer.setNamespaces(true);
                    serializer.asDOMSerializer().serialize(doc);
                } else {
                    in = ((Property)this.item).getStream();
                    if (in != null) {
                        IOUtil.spool(in, out);
                    }
                }
            }
        }
        catch (ParserConfigurationException e) {
            log.error("Error while spooling multivalued resource: " + e.getMessage());
        }
        catch (ValueFormatException e) {
            log.error("Cannot obtain stream from resource: " + e.getMessage());
        }
        catch (RepositoryException e) {
            log.error("Cannot obtain stream from resource: " + e.getMessage());
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public void setProperty(DavProperty property) throws DavException {
        this.internalSetProperty(property);
        this.complete();
    }

    private void internalSetProperty(DavProperty property) throws DavException {
        block5: {
            if (!this.exists()) {
                throw new DavException(404);
            }
            try {
                Property prop = (Property)this.item;
                int defaultType = prop.getType();
                ValueFactory vfact = this.getRepositorySession().getValueFactory();
                ValuesProperty vp = new ValuesProperty(property, defaultType, vfact);
                if (property.getName().equals((Object)JCR_VALUE)) {
                    prop.setValue(vp.getJcrValue(vp.getValueType(), vfact));
                    break block5;
                }
                if (property.getName().equals((Object)JCR_VALUES)) {
                    prop.setValue(vp.getJcrValues());
                    break block5;
                }
                throw new DavException(409);
            }
            catch (RepositoryException e) {
                throw new JcrDavException(e);
            }
        }
    }

    public void removeProperty(DavPropertyName propertyName) throws DavException {
        if (!this.exists()) {
            throw new DavException(404);
        }
        throw new DavException(403);
    }

    public MultiStatusResponse alterProperties(List changeList) throws DavException {
        Iterator it = changeList.iterator();
        while (it.hasNext()) {
            Object propEntry = it.next();
            if (propEntry instanceof DavPropertyName) {
                throw new DavException(403);
            }
            if (propEntry instanceof DavProperty) {
                DavProperty prop = (DavProperty)propEntry;
                this.internalSetProperty(prop);
                continue;
            }
            throw new IllegalArgumentException("unknown object in change list: " + propEntry.getClass().getName());
        }
        this.complete();
        return new MultiStatusResponse(this.getHref(), 200);
    }

    public void addMember(DavResource resource, InputContext inputContext) throws DavException {
        throw new DavException(405, "Cannot add members to a non-collection resource");
    }

    public DavResourceIterator getMembers() {
        log.warn("A non-collection resource never has internal members.");
        return new DavResourceIteratorImpl(new ArrayList(0));
    }

    public void removeMember(DavResource member) throws DavException {
        throw new DavException(405, "Cannot remove members from a non-collection resource");
    }

    public ActiveLock getLock(Type type, Scope scope) {
        if (Type.WRITE.equals((Object)type)) {
            return this.getCollection().getLock(type, scope);
        }
        return super.getLock(type, scope);
    }

    protected void initProperties() {
        super.initProperties();
        if (this.exists()) {
            try {
                Property prop = (Property)this.item;
                int type = prop.getType();
                String contentType = !this.isMultiple() ? (type == 2 ? "application/octet-stream" : "text/plain") : "text/xml";
                this.properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.GETCONTENTTYPE, (Object)contentType));
                this.properties.add((DavProperty)new DefaultDavProperty(JCR_TYPE, (Object)PropertyType.nameFromValue((int)type)));
                if (this.isMultiple()) {
                    this.properties.add((DavProperty)new ValuesProperty(prop.getValues()));
                    this.properties.add((DavProperty)new LengthsProperty(prop.getLengths()));
                } else {
                    this.properties.add((DavProperty)new ValuesProperty(prop.getValue()));
                    long length = prop.getLength();
                    this.properties.add((DavProperty)new DefaultDavProperty(JCR_LENGTH, (Object)String.valueOf(length), true));
                    if (prop.getLength() > -1L) {
                        this.properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.GETCONTENTLENGTH, (Object)String.valueOf(length)));
                    }
                }
            }
            catch (RepositoryException e) {
                log.error("Failed to retrieve resource properties: " + e.getMessage());
            }
        }
    }

    private boolean isMultiple() {
        try {
            if (this.exists() && ((Property)this.item).getDefinition().isMultiple()) {
                return true;
            }
        }
        catch (RepositoryException e) {
            log.error("Error while retrieving property definition: " + e.getMessage());
        }
        return false;
    }
}

