/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.ocm.repository;

import org.apache.jackrabbit.ocm.exception.JcrMappingException;
import org.apache.jackrabbit.ocm.exception.ObjectContentManagerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeUtil {
    public static final String PATH_SEPARATOR = "/";
    private static final Logger log = LoggerFactory.getLogger(NodeUtil.class);

    public static boolean isValidPath(String path) {
        return path != null && !path.equals(PATH_SEPARATOR) && !path.endsWith(PATH_SEPARATOR) && path.startsWith(PATH_SEPARATOR) && !path.equals("");
    }

    public static String getParentPath(String path) throws ObjectContentManagerException {
        String parentPath = "";
        if (!NodeUtil.isValidPath(path)) {
            throw new JcrMappingException("Invalid path : " + path);
        }
        String[] pathElements = path.split(PATH_SEPARATOR);
        if (pathElements.length == 2) {
            return PATH_SEPARATOR;
        }
        for (int i = 0; i < pathElements.length - 1; ++i) {
            if (pathElements[i].equals("")) continue;
            parentPath = parentPath + PATH_SEPARATOR + pathElements[i];
        }
        return parentPath;
    }

    public static String getNodeName(String path) throws ObjectContentManagerException {
        String[] pathElements = path.split(PATH_SEPARATOR);
        if (!NodeUtil.isValidPath(path)) {
            throw new JcrMappingException("Invalid path : " + path);
        }
        return pathElements[pathElements.length - 1];
    }
}

