/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.ocm.query.impl;

import java.util.Map;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.ocm.manager.impl.ObjectContentManagerImpl;
import org.apache.jackrabbit.ocm.mapper.Mapper;
import org.apache.jackrabbit.ocm.mapper.model.ClassDescriptor;
import org.apache.jackrabbit.ocm.query.Filter;
import org.apache.jackrabbit.ocm.query.Query;
import org.apache.jackrabbit.ocm.query.QueryManager;
import org.apache.jackrabbit.ocm.query.impl.FilterImpl;
import org.apache.jackrabbit.ocm.query.impl.QueryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryManagerImpl
implements QueryManager {
    private static final Logger log = LoggerFactory.getLogger(ObjectContentManagerImpl.class);
    private Mapper mapper;
    private Map atomicTypeConverters;
    private ValueFactory valueFactory;

    public QueryManagerImpl(Mapper mapper, Map atomicTypeConverters, ValueFactory valueFactory) {
        this.mapper = mapper;
        this.atomicTypeConverters = atomicTypeConverters;
        this.valueFactory = valueFactory;
    }

    public Filter createFilter(Class classQuery) {
        return new FilterImpl(this.mapper.getClassDescriptorByClass(classQuery), this.atomicTypeConverters, classQuery, this.valueFactory);
    }

    public Query createQuery(Filter filter) {
        return new QueryImpl(filter, this.mapper);
    }

    public String buildJCRExpression(Query query) {
        Filter filter = query.getFilter();
        ClassDescriptor classDescriptor = this.mapper.getClassDescriptorByClass(filter.getFilterClass());
        if (classDescriptor.hasDiscriminator()) {
            Filter discrininatorFilter = this.buildDiscriminatorFilter(query, classDescriptor);
            filter = filter.addAndFilter(discrininatorFilter);
        }
        String jcrExp = "";
        jcrExp = filter.getScope() != null && !filter.getScope().equals("") ? jcrExp + "/jcr:root" + filter.getScope() + "element(" + filter.getNodeName() + ", " : jcrExp + "//element(" + filter.getNodeName() + ", ";
        jcrExp = jcrExp + this.getNodeType(filter) + ") ";
        String filterExp = ((FilterImpl)filter).getJcrExpression();
        if (filterExp != null && !filterExp.equals("")) {
            jcrExp = jcrExp + "[" + filterExp + "]";
        }
        jcrExp = jcrExp + ((QueryImpl)query).getOrderByExpression();
        log.debug(jcrExp);
        return jcrExp;
    }

    private Filter buildDiscriminatorFilter(Query query, ClassDescriptor classDescriptor) {
        Filter discriminatorFilter = this.createFilter(query.getFilter().getFilterClass());
        if (!classDescriptor.isAbstract() && !classDescriptor.isInterface()) {
            discriminatorFilter.addJCRExpression("@ocm_classname='" + classDescriptor.getClassName() + "'");
        }
        if (classDescriptor.hasDescendants()) {
            for (ClassDescriptor descendantClassDescriptor : classDescriptor.getDescendantClassDescriptors()) {
                discriminatorFilter = discriminatorFilter.addOrFilter(this.buildDiscriminatorFilter(query, descendantClassDescriptor));
            }
        }
        return discriminatorFilter;
    }

    private String getNodeType(Filter filter) {
        ClassDescriptor classDescriptor = this.mapper.getClassDescriptorByClass(filter.getFilterClass());
        String jcrNodeType = classDescriptor.getJcrType();
        if (jcrNodeType == null || jcrNodeType.equals("")) {
            return "nt:unstructured";
        }
        return jcrNodeType;
    }
}

