/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.ocm.manager.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.LockException;
import javax.jcr.lock.LockManager;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionManager;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.ocm.exception.IllegalUnlockException;
import org.apache.jackrabbit.ocm.exception.IncorrectPersistentClassException;
import org.apache.jackrabbit.ocm.exception.InvalidQueryException;
import org.apache.jackrabbit.ocm.exception.JcrMappingException;
import org.apache.jackrabbit.ocm.exception.LockedException;
import org.apache.jackrabbit.ocm.exception.ObjectContentManagerException;
import org.apache.jackrabbit.ocm.exception.RepositoryException;
import org.apache.jackrabbit.ocm.exception.VersionException;
import org.apache.jackrabbit.ocm.lock.Lock;
import org.apache.jackrabbit.ocm.manager.ObjectContentManager;
import org.apache.jackrabbit.ocm.manager.atomictypeconverter.impl.DefaultAtomicTypeConverterProvider;
import org.apache.jackrabbit.ocm.manager.cache.ObjectCache;
import org.apache.jackrabbit.ocm.manager.cache.impl.RequestObjectCacheImpl;
import org.apache.jackrabbit.ocm.manager.impl.ObjectIterator;
import org.apache.jackrabbit.ocm.manager.objectconverter.ObjectConverter;
import org.apache.jackrabbit.ocm.manager.objectconverter.impl.ObjectConverterImpl;
import org.apache.jackrabbit.ocm.manager.objectconverter.impl.ProxyManagerImpl;
import org.apache.jackrabbit.ocm.mapper.Mapper;
import org.apache.jackrabbit.ocm.mapper.impl.digester.DigesterMapperImpl;
import org.apache.jackrabbit.ocm.mapper.model.ClassDescriptor;
import org.apache.jackrabbit.ocm.query.QueryManager;
import org.apache.jackrabbit.ocm.query.impl.QueryManagerImpl;
import org.apache.jackrabbit.ocm.repository.NodeUtil;
import org.apache.jackrabbit.ocm.version.Version;
import org.apache.jackrabbit.ocm.version.VersionIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectContentManagerImpl
implements ObjectContentManager {
    private static final Logger log = LoggerFactory.getLogger(ObjectContentManagerImpl.class);
    protected Session session;
    protected Mapper mapper;
    protected QueryManager queryManager;
    protected ObjectConverter objectConverter;
    protected ObjectCache requestObjectCache;

    public ObjectContentManagerImpl(Session session, Mapper mapper) {
        try {
            this.session = session;
            this.mapper = mapper;
            DefaultAtomicTypeConverterProvider converterProvider = new DefaultAtomicTypeConverterProvider();
            Map atomicTypeConverters = converterProvider.getAtomicTypeConverters();
            this.queryManager = new QueryManagerImpl(mapper, atomicTypeConverters, session.getValueFactory());
            this.requestObjectCache = new RequestObjectCacheImpl();
            this.objectConverter = new ObjectConverterImpl(mapper, converterProvider, new ProxyManagerImpl(), this.requestObjectCache);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to instantiate the object content manager", e);
        }
    }

    public ObjectContentManagerImpl(Session session, String[] xmlMappingFiles) {
        try {
            this.session = session;
            this.mapper = new DigesterMapperImpl(xmlMappingFiles);
            DefaultAtomicTypeConverterProvider converterProvider = new DefaultAtomicTypeConverterProvider();
            Map atomicTypeConverters = converterProvider.getAtomicTypeConverters();
            this.queryManager = new QueryManagerImpl(this.mapper, atomicTypeConverters, session.getValueFactory());
            this.requestObjectCache = new RequestObjectCacheImpl();
            this.objectConverter = new ObjectConverterImpl(this.mapper, converterProvider, new ProxyManagerImpl(), this.requestObjectCache);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to instantiate the object content manager", e);
        }
    }

    public ObjectContentManagerImpl(Session session, InputStream[] xmlMappingFiles) {
        try {
            this.session = session;
            this.mapper = new DigesterMapperImpl(xmlMappingFiles);
            DefaultAtomicTypeConverterProvider converterProvider = new DefaultAtomicTypeConverterProvider();
            Map atomicTypeConverters = converterProvider.getAtomicTypeConverters();
            this.queryManager = new QueryManagerImpl(this.mapper, atomicTypeConverters, session.getValueFactory());
            this.requestObjectCache = new RequestObjectCacheImpl();
            this.objectConverter = new ObjectConverterImpl(this.mapper, converterProvider, new ProxyManagerImpl(), this.requestObjectCache);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to instantiate the object content manager", e);
        }
    }

    public ObjectContentManagerImpl(Mapper mapper, ObjectConverter converter, QueryManager queryManager, ObjectCache requestObjectCache, Session session) {
        this.mapper = mapper;
        this.session = session;
        this.objectConverter = converter;
        this.queryManager = queryManager;
        this.requestObjectCache = requestObjectCache;
    }

    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    public void setObjectConverter(ObjectConverter objectConverter) {
        this.objectConverter = objectConverter;
    }

    public void setQueryManager(QueryManager queryManager) {
        this.queryManager = queryManager;
    }

    public void setRequestObjectCache(ObjectCache requestObjectCache) {
        this.requestObjectCache = requestObjectCache;
    }

    public Object getObject(String path) {
        try {
            if (!this.session.nodeExists(path)) {
                return null;
            }
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to get the object at " + path, e);
        }
        Object object = this.objectConverter.getObject(this.session, path);
        this.requestObjectCache.clear();
        return object;
    }

    public Object getObjectByUuid(String uuid) {
        try {
            Node node = this.session.getNodeByIdentifier(uuid);
            Object object = this.objectConverter.getObject(this.session, node.getPath());
            this.requestObjectCache.clear();
            return object;
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to get the object with uuid : " + uuid, e);
        }
    }

    public Object getObject(String path, String versionName) {
        String pathVersion;
        try {
            if (!this.session.nodeExists(path)) {
                return null;
            }
            Version version = this.getVersion(path, versionName);
            pathVersion = version.getPath() + "/jcr:frozenNode";
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to get the object at " + path + " - version :" + versionName, e);
        }
        Object object = this.objectConverter.getObject(this.session, pathVersion);
        this.requestObjectCache.clear();
        return object;
    }

    public Object getObject(Class objectClass, String path) {
        try {
            if (!this.session.nodeExists(path)) {
                return null;
            }
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to get the object at " + path, e);
        }
        Object object = this.objectConverter.getObject(this.session, objectClass, path);
        this.requestObjectCache.clear();
        return object;
    }

    public Object getObject(Class objectClass, String path, String versionName) {
        String pathVersion = null;
        try {
            if (!this.session.nodeExists(path)) {
                return null;
            }
            Version version = this.getVersion(path, versionName);
            pathVersion = version.getPath() + "/jcr:frozenNode";
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to get the object at " + path + " - version :" + versionName, e);
        }
        Object object = this.objectConverter.getObject(this.session, objectClass, pathVersion);
        this.requestObjectCache.clear();
        return object;
    }

    public void retrieveAllMappedAttributes(Object object) {
        this.objectConverter.retrieveAllMappedAttributes(this.session, object);
        this.requestObjectCache.clear();
    }

    public void retrieveMappedAttribute(Object object, String attributeName) {
        this.objectConverter.retrieveMappedAttribute(this.session, object, attributeName);
        this.requestObjectCache.clear();
    }

    public void insert(Object object) {
        String path = this.objectConverter.getPath(this.session, object);
        try {
            Node node;
            if (this.session.nodeExists(path) && !(node = this.session.getNode(path)).getDefinition().allowsSameNameSiblings()) {
                throw new ObjectContentManagerException("Path already exists and it is not supporting the same name sibling : " + path);
            }
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to insert the object at " + path, e);
        }
        this.objectConverter.insert(this.session, object);
    }

    public void update(Object object) {
        String path = this.objectConverter.getPath(this.session, object);
        try {
            if (!this.session.nodeExists(path)) {
                throw new ObjectContentManagerException("Path is not existing : " + path);
            }
            this.checkIfNodeLocked(path);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to update", e);
        }
        this.objectConverter.update(this.session, object);
    }

    public void remove(String path) {
        try {
            if (!this.session.nodeExists(path)) {
                throw new ObjectContentManagerException("Path does not exist : " + path);
            }
            this.checkIfNodeLocked(path);
            Item item = this.session.getItem(path);
            item.remove();
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to remove the object at " + path);
        }
    }

    public void remove(Object object) {
        this.remove(this.objectConverter.getPath(this.session, object));
    }

    public void remove(org.apache.jackrabbit.ocm.query.Query query) {
        try {
            String jcrExpression = this.queryManager.buildJCRExpression(query);
            log.debug("Remove Objects with expression : " + jcrExpression);
            NodeIterator nodeIterator = this.getNodeIterator(jcrExpression, "xpath");
            ArrayList<Node> nodes = new ArrayList<Node>();
            while (nodeIterator.hasNext()) {
                Node node = nodeIterator.nextNode();
                if (node == null) continue;
                log.debug("Remove node : " + node.getPath());
                nodes.add(node);
            }
            for (int i = 0; i < nodes.size(); ++i) {
                Node node = (Node)nodes.get(i);
                this.checkIfNodeLocked(node.getPath());
                try {
                    node.remove();
                    continue;
                }
                catch (javax.jcr.RepositoryException re) {
                    throw new ObjectContentManagerException("Cannot remove node at path " + node.getPath() + " returned from query " + jcrExpression, re);
                }
            }
        }
        catch (javax.jcr.query.InvalidQueryException iqe) {
            throw new RepositoryException("Invalid query expression", iqe);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to get the object collection", e);
        }
    }

    public boolean objectExists(String path) {
        try {
            return this.session.nodeExists(path);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to check if the object exist", e);
        }
    }

    public boolean isPersistent(Class clazz) {
        try {
            ClassDescriptor classDescriptor = this.mapper.getClassDescriptorByClass(clazz);
            return classDescriptor != null;
        }
        catch (IncorrectPersistentClassException e) {
            return false;
        }
    }

    public Object getObject(org.apache.jackrabbit.ocm.query.Query query) {
        String jcrExpression = this.queryManager.buildJCRExpression(query);
        Collection result = this.getObjects(jcrExpression, "xpath");
        if (result.size() > 1) {
            throw new ObjectContentManagerException("Impossible to get the object - the query returns more than one object");
        }
        return result.isEmpty() ? null : result.iterator().next();
    }

    public Collection getObjects(org.apache.jackrabbit.ocm.query.Query query) {
        String jcrExpression = this.queryManager.buildJCRExpression(query);
        return this.getObjects(jcrExpression, "xpath");
    }

    public Collection getObjects(Class objectClass, String path) throws ObjectContentManagerException {
        ClassDescriptor classDescriptorByClass = this.mapper.getClassDescriptorByClass(objectClass);
        if (classDescriptorByClass == null) {
            log.debug("Cannot get objects because no descriptor class exists for '{}'", (Object)objectClass.getClass().getName());
            return Collections.emptyList();
        }
        try {
            if (!this.session.nodeExists(path)) {
                log.debug("Cannot get objects '{}' because no node exists at '{}'", (Object)objectClass.getClass().getName(), (Object)path);
                return Collections.emptyList();
            }
            Node parentNode = this.session.getNode(path).getParent();
            String nodeName = NodeUtil.getNodeName(path);
            if (StringUtils.isBlank((String)nodeName)) {
                nodeName = null;
            }
            NodeIterator candidates = parentNode.getNodes();
            ArrayList<Node> validated = new ArrayList<Node>();
            while (candidates.hasNext()) {
                Node child = candidates.nextNode();
                if (nodeName != null && !child.getName().equals(nodeName)) continue;
                if (child.hasProperty("ocm_classname")) {
                    if (!child.getProperty("ocm_classname").getString().equals(classDescriptorByClass.getClassName())) continue;
                    validated.add(child);
                    continue;
                }
                if (!child.getPrimaryNodeType().getName().equals(classDescriptorByClass.getJcrType())) continue;
                validated.add(child);
            }
            ArrayList<Object> result = new ArrayList<Object>();
            for (Node n : validated) {
                Object object = this.objectConverter.getObject(this.session, n.getPath());
                if (object == null) {
                    log.debug("Could not get object for '{}'", (Object)n.getPath());
                    continue;
                }
                if (!objectClass.isAssignableFrom(object.getClass())) continue;
                result.add(object);
            }
            return result;
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to get the objects at " + path, e);
        }
    }

    public Iterator getObjectIterator(org.apache.jackrabbit.ocm.query.Query query) {
        String jcrExpression = this.queryManager.buildJCRExpression(query);
        log.debug("Get Object with expression : " + jcrExpression);
        NodeIterator nodeIterator = this.getNodeIterator(jcrExpression, "xpath");
        return new ObjectIterator(nodeIterator, this.objectConverter, this.session);
    }

    public Iterator getObjectIterator(String query, String language) {
        log.debug("Get Object with expression : " + query);
        NodeIterator nodeIterator = this.getNodeIterator(query, language);
        return new ObjectIterator(nodeIterator, this.objectConverter, this.session);
    }

    public Collection getObjects(String query, String language) {
        try {
            log.debug("Get Objects with expression : " + query + " and language " + language);
            NodeIterator nodeIterator = this.getNodeIterator(query, language);
            ArrayList<Object> result = new ArrayList<Object>();
            while (nodeIterator.hasNext()) {
                Node node = nodeIterator.nextNode();
                log.debug("Node found : " + node.getPath());
                result.add(this.objectConverter.getObject(this.session, node.getPath()));
            }
            this.requestObjectCache.clear();
            return result;
        }
        catch (javax.jcr.query.InvalidQueryException iqe) {
            throw new RepositoryException("Invalid query expression", iqe);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to get the object collection", e);
        }
    }

    private NodeIterator getNodeIterator(String query, String language) {
        if (log.isDebugEnabled()) {
            log.debug("Get Node Iterator with expression " + query + " and language " + language);
        }
        try {
            Query jcrQuery = this.session.getWorkspace().getQueryManager().createQuery(query, language);
            QueryResult queryResult = jcrQuery.execute();
            NodeIterator nodeIterator = queryResult.getNodes();
            return nodeIterator;
        }
        catch (javax.jcr.query.InvalidQueryException iqe) {
            throw new InvalidQueryException(iqe);
        }
        catch (javax.jcr.RepositoryException re) {
            throw new ObjectContentManagerException(re.getMessage(), re);
        }
    }

    public void checkin(String path) {
        this.checkin(path, null);
    }

    public void checkin(String path, String[] versionLabels) {
        try {
            Node node = (Node)this.session.getItem(path);
            this.checkIfNodeLocked(node.getPath());
            if (!node.isNodeType("mix:versionable")) {
                throw new VersionException("The object " + path + "is not versionable");
            }
            javax.jcr.version.Version newVersion = this.getVersionManager().checkin(path);
            if (versionLabels != null) {
                VersionHistory versionHistory = this.getVersionManager().getVersionHistory(path);
                for (int i = 0; i < versionLabels.length; ++i) {
                    versionHistory.addVersionLabel(newVersion.getName(), versionLabels[i], false);
                }
            }
        }
        catch (ClassCastException cce) {
            throw new ObjectContentManagerException("Cannot retrieve an object from a property path " + path);
        }
        catch (PathNotFoundException pnfe) {
            throw new ObjectContentManagerException("Cannot retrieve an object at path " + path, pnfe);
        }
        catch (InvalidItemStateException iise) {
            throw new ObjectContentManagerException("Cannot checking modified object at path " + path, iise);
        }
        catch (javax.jcr.version.VersionException ve) {
            throw new VersionException("Impossible to checkin the object " + path, ve);
        }
        catch (UnsupportedRepositoryOperationException uroe) {
            throw new VersionException("Cannot checkin unversionable node at path " + path, uroe);
        }
        catch (LockException le) {
            throw new VersionException("Cannot checkin locked node at path " + path, le);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to checkin the object " + path, e);
        }
    }

    public void checkout(String path) {
        try {
            Node node = (Node)this.session.getItem(path);
            if (!node.isNodeType("mix:versionable")) {
                throw new VersionException("The object " + path + "is not versionable");
            }
            this.getVersionManager().checkout(path);
        }
        catch (ClassCastException cce) {
            throw new ObjectContentManagerException("Cannot retrieve an object from a property path " + path);
        }
        catch (PathNotFoundException pnfe) {
            throw new ObjectContentManagerException("Cannot retrieve an object at path " + path, pnfe);
        }
        catch (UnsupportedRepositoryOperationException uroe) {
            throw new VersionException("Cannot checkout unversionable node at path " + path, uroe);
        }
        catch (LockException le) {
            throw new VersionException("Cannot checkout locked node at path " + path, le);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to checkout the object " + path, e);
        }
    }

    public void addVersionLabel(String path, String versionName, String versionLabel) {
        try {
            Node node = (Node)this.session.getItem(path);
            this.checkIfNodeLocked(path);
            if (!node.isNodeType("mix:versionable")) {
                throw new VersionException("The object " + path + "is not versionable");
            }
            VersionHistory history = this.getVersionManager().getVersionHistory(path);
            history.addVersionLabel(versionName, versionLabel, false);
        }
        catch (ClassCastException cce) {
            throw new ObjectContentManagerException("Cannot retrieve an object from a property path " + path);
        }
        catch (PathNotFoundException pnfe) {
            throw new ObjectContentManagerException("Cannot retrieve an object at path " + path, pnfe);
        }
        catch (javax.jcr.version.VersionException ve) {
            throw new VersionException("Impossible to add a new version label to  " + path + " - version name : " + versionName, ve);
        }
        catch (UnsupportedRepositoryOperationException uroe) {
            throw new VersionException("Impossible to add a new version label to  " + path + " - version name : " + versionName, uroe);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e);
        }
    }

    public Version getVersion(String path, String versionName) {
        try {
            Node node = (Node)this.session.getItem(path);
            if (!node.isNodeType("mix:versionable")) {
                throw new VersionException("The object " + path + "is not versionable");
            }
            VersionHistory history = this.getVersionManager().getVersionHistory(path);
            return new Version(history.getVersion(versionName));
        }
        catch (ClassCastException cce) {
            throw new ObjectContentManagerException("Cannot retrieve an object from a property path " + path);
        }
        catch (PathNotFoundException pnfe) {
            throw new ObjectContentManagerException("Cannot retrieve an object at path " + path, pnfe);
        }
        catch (javax.jcr.version.VersionException ve) {
            throw new VersionException("The version name " + versionName + "does not exist", ve);
        }
        catch (UnsupportedRepositoryOperationException uroe) {
            throw new VersionException("Impossible to retrieve versions for path " + path, uroe);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e);
        }
    }

    public String[] getVersionLabels(String path, String versionName) {
        try {
            Node node = (Node)this.session.getItem(path);
            if (!node.isNodeType("mix:versionable")) {
                throw new VersionException("The object " + path + "is not versionable");
            }
            VersionHistory history = this.getVersionManager().getVersionHistory(path);
            javax.jcr.version.Version version = history.getVersion(versionName);
            return history.getVersionLabels(version);
        }
        catch (ClassCastException cce) {
            throw new ObjectContentManagerException("Cannot retrieve an object from a property path " + path);
        }
        catch (PathNotFoundException pnfe) {
            throw new ObjectContentManagerException("Cannot retrieve an object at path " + path, pnfe);
        }
        catch (javax.jcr.version.VersionException ve) {
            throw new VersionException("Impossible to get the version labels : " + path + " - version name : " + versionName, ve);
        }
        catch (UnsupportedRepositoryOperationException uroe) {
            throw new VersionException("Impossible to retrieve versions for path " + path, uroe);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e);
        }
    }

    public String[] getAllVersionLabels(String path) {
        try {
            Node node = this.session.getNode(path);
            if (!node.isNodeType("mix:versionable")) {
                throw new VersionException("The object " + path + "is not versionable");
            }
            VersionHistory history = this.getVersionManager().getVersionHistory(path);
            return history.getVersionLabels();
        }
        catch (ClassCastException cce) {
            throw new ObjectContentManagerException("Cannot retrieve an object from a property path " + path);
        }
        catch (PathNotFoundException pnfe) {
            throw new ObjectContentManagerException("Cannot retrieve an object at path " + path, pnfe);
        }
        catch (UnsupportedRepositoryOperationException uroe) {
            throw new VersionException("Impossible to retrieve version history for path " + path, uroe);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e);
        }
    }

    public VersionIterator getAllVersions(String path) {
        try {
            Node node = this.session.getNode(path);
            if (!node.isNodeType("mix:versionable")) {
                throw new VersionException("The object " + path + "is not versionable");
            }
            VersionHistory history = this.getVersionManager().getVersionHistory(path);
            return new VersionIterator(history.getAllVersions());
        }
        catch (ClassCastException cce) {
            throw new ObjectContentManagerException("Cannot retrieve an object from a property path " + path);
        }
        catch (PathNotFoundException pnfe) {
            throw new ObjectContentManagerException("Cannot retrieve an object at path " + path, pnfe);
        }
        catch (UnsupportedRepositoryOperationException uroe) {
            throw new VersionException("Impossible to retrieve version history for path " + path, uroe);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e);
        }
    }

    public Version getRootVersion(String path) {
        try {
            Node node = this.session.getNode(path);
            if (!node.isNodeType("mix:versionable")) {
                throw new VersionException("The object " + path + "is not versionable");
            }
            VersionHistory history = this.getVersionManager().getVersionHistory(path);
            return new Version(history.getRootVersion());
        }
        catch (ClassCastException cce) {
            throw new ObjectContentManagerException("Cannot retrieve an object from a property path " + path);
        }
        catch (PathNotFoundException pnfe) {
            throw new ObjectContentManagerException("Cannot retrieve an object at path " + path, pnfe);
        }
        catch (UnsupportedRepositoryOperationException uroe) {
            throw new VersionException("Impossible to get the root version  for the object " + path, uroe);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e);
        }
    }

    public Version getBaseVersion(String path) {
        try {
            Node node = this.session.getNode(path);
            if (!node.isNodeType("mix:versionable")) {
                throw new VersionException("The object " + path + "is not versionable");
            }
            return new Version(this.getVersionManager().getBaseVersion(path));
        }
        catch (ClassCastException cce) {
            throw new ObjectContentManagerException("Cannot retrieve an object from a property path " + path);
        }
        catch (PathNotFoundException pnfe) {
            throw new ObjectContentManagerException("Cannot retrieve an object at path " + path, pnfe);
        }
        catch (UnsupportedRepositoryOperationException uroe) {
            throw new VersionException("Impossible to get the base version for the object " + path, uroe);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e);
        }
    }

    public Lock lock(String absPath, boolean isDeep, boolean isSessionScoped) throws LockedException {
        try {
            this.checkIfNodeLocked(absPath);
            javax.jcr.lock.Lock lock = this.getLockManager().lock(absPath, isDeep, isSessionScoped, 0L, this.session.getUserID());
            return new Lock(lock);
        }
        catch (LockException e) {
            throw new RepositoryException("Node of type is not type mix:lockable", e);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
    }

    public void unlock(String absPath, String lockToken) throws IllegalUnlockException {
        String lockOwner = null;
        try {
            this.maybeAddLockToken(lockToken, absPath);
            Node node = this.getNode(absPath);
            if (!node.isLocked()) {
                return;
            }
            javax.jcr.lock.Lock lock = this.getLockManager().getLock(absPath);
            lockOwner = lock.getLockOwner();
            this.getLockManager().unlock(absPath);
        }
        catch (LockException e) {
            log.error("Cannot unlock path: " + absPath + " Jcr user: " + this.session.getUserID() + " has no lock token to do this. Lock was placed with user: " + lockOwner);
            throw new IllegalUnlockException(lockOwner, absPath);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
    }

    public boolean isLocked(String absPath) {
        try {
            Node node = this.getNode(absPath);
            return node.isLocked();
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("An exception was thrown while checking the lock at path : " + absPath, e);
        }
    }

    public QueryManager getQueryManager() {
        return this.queryManager;
    }

    protected void checkIfNodeLocked(String absPath) throws javax.jcr.RepositoryException, LockedException {
        Node node = this.getNode(absPath);
        if (node.isLocked()) {
            javax.jcr.lock.Lock lock = this.getLockManager().getLock(absPath);
            String lockOwner = lock.getLockOwner();
            if (!this.session.getUserID().equals(lockOwner)) {
                String path = lock.getNode().getPath();
                throw new LockedException(lockOwner, path);
            }
        }
    }

    protected void maybeAddLockToken(String lockToken, String path) {
        block9: {
            if (lockToken == null) break block9;
            String[] lockTokens = null;
            try {
                lockTokens = this.getLockManager().getLockTokens();
            }
            catch (UnsupportedRepositoryOperationException ex) {
                throw new LockedException(this.session.getUserID(), path);
            }
            catch (javax.jcr.RepositoryException ex) {
                throw new RepositoryException(ex.getMessage(), ex);
            }
            if (lockTokens != null) {
                for (int i = 0; i < lockTokens.length && !lockTokens[i].equals(lockToken); ++i) {
                }
            } else {
                try {
                    this.getLockManager().addLockToken(lockToken);
                }
                catch (UnsupportedRepositoryOperationException ex) {
                    throw new LockedException(this.session.getUserID(), path);
                }
                catch (javax.jcr.RepositoryException ex) {
                    throw new RepositoryException(ex.getMessage(), ex);
                }
            }
        }
    }

    protected Node getNode(String absPath) throws PathNotFoundException, javax.jcr.RepositoryException {
        if (!this.session.nodeExists(absPath)) {
            throw new ObjectContentManagerException("No object stored on path: " + absPath);
        }
        return this.session.getNode(absPath);
    }

    public void logout() {
        try {
            log.debug("Logout. Persisting current session changes.");
            this.session.save();
            this.session.logout();
            log.debug("Session closed");
        }
        catch (NoSuchNodeTypeException nsnte) {
            throw new JcrMappingException("Cannot persist current session changes. An unknown node type was used.", nsnte);
        }
        catch (javax.jcr.version.VersionException ve) {
            throw new VersionException("Cannot persist current session changes. Attempt to overwrite checked-in node", ve);
        }
        catch (LockException le) {
            throw new ObjectContentManagerException("Cannot persist current session changes. Violation of a lock detected", le);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new ObjectContentManagerException("Cannot persist current session changes.", e);
        }
    }

    public void save() {
        try {
            this.session.save();
        }
        catch (NoSuchNodeTypeException nsnte) {
            throw new JcrMappingException("Cannot persist current session changes. An unknown node type was used.", nsnte);
        }
        catch (javax.jcr.version.VersionException ve) {
            throw new VersionException("Cannot persist current session changes. Attempt to overwrite checked-in node", ve);
        }
        catch (LockException le) {
            throw new ObjectContentManagerException("Cannot persist current session changes. Violation of a lock detected", le);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new ObjectContentManagerException("Cannot persist current session changes.", e);
        }
        finally {
            this.requestObjectCache.clear();
        }
    }

    public Session getSession() {
        return this.session;
    }

    public void refresh(boolean keepChanges) {
        try {
            this.session.refresh(keepChanges);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new ObjectContentManagerException("Cannot refresh current session ", e);
        }
    }

    public void move(String srcPath, String destPath) {
        try {
            this.session.move(srcPath, destPath);
        }
        catch (ConstraintViolationException cve) {
            throw new ObjectContentManagerException("Cannot move the object from " + srcPath + " to " + destPath + "." + " Violation of a nodetype or attempt to move under a property detected", cve);
        }
        catch (javax.jcr.version.VersionException ve) {
            throw new VersionException("Cannot move the object from " + srcPath + " to " + destPath + "." + " Parent node of source or destination is versionable and checked in ", ve);
        }
        catch (AccessDeniedException ade) {
            throw new ObjectContentManagerException("Cannot move the object from " + srcPath + " to " + destPath + "." + " Session does not have access permissions", ade);
        }
        catch (PathNotFoundException pnf) {
            throw new ObjectContentManagerException("Cannot move the object from " + srcPath + " to " + destPath + "." + " Node at source or destination does not exist ", pnf);
        }
        catch (ItemExistsException ie) {
            throw new ObjectContentManagerException("Cannot move the object from " + srcPath + " to " + destPath + "." + " It might already exist at destination path.", ie);
        }
        catch (LockException le) {
            throw new ObjectContentManagerException("Cannot move the object from " + srcPath + " to " + destPath + "." + "Violation of a lock detected", le);
        }
        catch (javax.jcr.RepositoryException re) {
            throw new ObjectContentManagerException("Cannot move the object from " + srcPath + " to " + destPath + ".", re);
        }
    }

    public void copy(String srcPath, String destPath) throws ObjectContentManagerException {
        try {
            Node destNode;
            if (StringUtils.isBlank((String)srcPath) || StringUtils.isBlank((String)destPath) || !srcPath.startsWith("/") || !destPath.startsWith("/")) {
                throw new ObjectContentManagerException("scrPath " + srcPath + " or destPath " + destPath + " is not valid");
            }
            Node srcNode = this.session.getNode(srcPath);
            if (this.session.nodeExists(destPath)) {
                destNode = this.session.getNode(destPath);
            } else {
                while (destPath.endsWith("/")) {
                    destPath = destPath.substring(0, destPath.length() - 1);
                }
                int indexOfLastSlash = destPath.lastIndexOf("/");
                String parentDestPath = destPath.substring(0, indexOfLastSlash);
                String destNodeName = destPath.substring(indexOfLastSlash + 1);
                Node parentDestNode = StringUtils.isBlank((String)parentDestPath) ? this.session.getRootNode() : this.session.getNode(parentDestPath);
                destNode = parentDestNode.addNode(destNodeName, srcNode.getPrimaryNodeType().getName());
            }
            this.copy(srcNode, destNode);
        }
        catch (ConstraintViolationException cve) {
            throw new ObjectContentManagerException("Cannot copy the object from " + srcPath + " to " + destPath + "." + "Violation of a nodetype or attempt to copy under property detected ", cve);
        }
        catch (javax.jcr.version.VersionException ve) {
            throw new VersionException("Cannot copy the object from " + srcPath + " to " + destPath + "." + "Parent node of source or destination is versionable and checked in ", ve);
        }
        catch (AccessDeniedException ade) {
            throw new ObjectContentManagerException("Cannot copy the object from " + srcPath + " to " + destPath + "." + " Session does not have access permissions", ade);
        }
        catch (PathNotFoundException pnf) {
            throw new ObjectContentManagerException("Cannot copy the object from " + srcPath + " to " + destPath + "." + "Node at source or parent of destination does not exist ", pnf);
        }
        catch (ItemExistsException ie) {
            throw new ObjectContentManagerException("Cannot copy the object from " + srcPath + " to " + destPath + "." + "It might already exist at destination path.", ie);
        }
        catch (LockException le) {
            throw new ObjectContentManagerException("Cannot copy the object from " + srcPath + " to " + destPath + "." + "Violation of a lock detected", le);
        }
        catch (javax.jcr.RepositoryException re) {
            throw new ObjectContentManagerException("Cannot copy the node from " + srcPath + " to " + destPath + ".", re);
        }
    }

    private LockManager getLockManager() throws UnsupportedRepositoryOperationException, javax.jcr.RepositoryException {
        return this.session.getWorkspace().getLockManager();
    }

    private VersionManager getVersionManager() throws UnsupportedRepositoryOperationException, javax.jcr.RepositoryException {
        return this.session.getWorkspace().getVersionManager();
    }

    private void copy(Node srcNode, Node destNode) throws javax.jcr.RepositoryException {
        NodeType[] mixinNodeTypes = srcNode.getMixinNodeTypes();
        for (int i = 0; i < mixinNodeTypes.length; ++i) {
            destNode.addMixin(mixinNodeTypes[i].getName());
        }
        PropertyIterator iter = srcNode.getProperties();
        while (iter.hasNext()) {
            Property property = iter.nextProperty();
            PropertyDefinition definition = property.getDefinition();
            if (definition.isProtected()) continue;
            if (definition.isMultiple()) {
                destNode.setProperty(property.getName(), property.getValues(), property.getType());
                continue;
            }
            destNode.setProperty(property.getName(), property.getValue());
        }
        iter = srcNode.getNodes();
        while (iter.hasNext()) {
            Node node = iter.nextNode();
            Node child = !node.getDefinition().isAutoCreated() && destNode.hasNode(node.getName()) ? destNode.getNode(node.getName()) : destNode.addNode(node.getName(), node.getPrimaryNodeType().getName());
            this.copy(node, child);
        }
    }
}

