/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.ocm.manager.enumconverter;

import java.io.InvalidClassException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.ocm.manager.atomictypeconverter.AtomicTypeConverter;

public class EnumTypeConverter
implements AtomicTypeConverter {
    public Object getObject(Value value) {
        try {
            String propertyValue = value.getString();
            String[] enumerationDef = StringUtils.split((String)propertyValue, (char)':');
            String enumerationClass = enumerationDef[0];
            String enumerationValue = enumerationDef[1];
            Enum[] enumerations = (Enum[])Class.forName(enumerationClass).getEnumConstants();
            int size = enumerations.length;
            for (int i = 0; i < size; ++i) {
                if (!enumerations[i].name().equals(enumerationValue)) continue;
                return enumerations[i];
            }
            throw new RuntimeException(new InvalidClassException(enumerationClass + " Does not contain an enumeration " + enumerationValue));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Value getValue(ValueFactory valueFactory, Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof Enum)) {
            throw new RuntimeException(new InvalidClassException(EnumTypeConverter.class.getSimpleName() + " Can only convert simple Enumerations"));
        }
        Enum anEnum = (Enum)object;
        String value = anEnum.getDeclaringClass().getName() + ":" + anEnum.name();
        return valueFactory.createValue(value);
    }

    public String getXPathQueryValue(ValueFactory valueFactory, Object object) {
        Value value = this.getValue(valueFactory, object);
        try {
            return "'" + value.getString() + "'";
        }
        catch (Exception e) {
            throw new RuntimeException(e.fillInStackTrace());
        }
    }
}

