/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.ocm.manager.collectionconverter.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.ocm.exception.JcrMappingException;
import org.apache.jackrabbit.ocm.manager.collectionconverter.ManageableCollection;
import org.apache.jackrabbit.ocm.manager.collectionconverter.ManageableMap;
import org.apache.jackrabbit.ocm.manager.collectionconverter.ManageableObjects;
import org.apache.jackrabbit.ocm.manager.collectionconverter.ManageableObjectsUtil;
import org.apache.jackrabbit.ocm.manager.collectionconverter.impl.AbstractCollectionConverterImpl;
import org.apache.jackrabbit.ocm.manager.objectconverter.ObjectConverter;
import org.apache.jackrabbit.ocm.mapper.Mapper;
import org.apache.jackrabbit.ocm.mapper.model.ClassDescriptor;
import org.apache.jackrabbit.ocm.mapper.model.CollectionDescriptor;
import org.apache.jackrabbit.ocm.reflection.ReflectionUtils;

public class DefaultCollectionConverterImpl
extends AbstractCollectionConverterImpl {
    protected static final String COLLECTION_ELEMENT_NAME = "collection-element";

    public DefaultCollectionConverterImpl(Map atomicTypeConverters, ObjectConverter objectConverter, Mapper mapper) {
        super(atomicTypeConverters, objectConverter, mapper);
    }

    protected void doInsertCollection(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, ManageableObjects objects) throws RepositoryException {
        if (objects == null) {
            return;
        }
        String jcrName = collectionDescriptor.getJcrName();
        if (jcrName == null) {
            throw new JcrMappingException("The JcrName attribute is not defined for the CollectionDescriptor : " + collectionDescriptor.getFieldName() + " for the classdescriptor : " + collectionDescriptor.getClassDescriptor().getClassName());
        }
        Node collectionNode = !StringUtils.isBlank((String)collectionDescriptor.getJcrType()) ? parentNode.addNode(jcrName, collectionDescriptor.getJcrType()) : parentNode.addNode(jcrName);
        ClassDescriptor elementClassDescriptor = this.mapper.getClassDescriptorByClass(ReflectionUtils.forName(collectionDescriptor.getElementClassName()));
        if (objects instanceof ManageableCollection) {
            this.insertManageableCollection(session, objects, collectionNode, elementClassDescriptor, collectionDescriptor);
        } else {
            this.insertManageableMap(session, objects, collectionNode);
        }
    }

    private void insertManageableCollection(Session session, ManageableObjects objects, Node collectionNode, ClassDescriptor elementClassDescriptor, CollectionDescriptor collectionDescriptor) {
        Iterator collectionIterator = objects.getIterator();
        while (collectionIterator.hasNext()) {
            Object item = collectionIterator.next();
            String elementJcrName = null;
            if (elementClassDescriptor.hasIdField()) {
                String idFieldName = elementClassDescriptor.getIdFieldDescriptor().getFieldName();
                elementJcrName = ReflectionUtils.getNestedProperty(item, idFieldName).toString();
            } else {
                elementJcrName = collectionDescriptor.getJcrElementName();
                if (elementJcrName == null) {
                    elementJcrName = COLLECTION_ELEMENT_NAME;
                }
            }
            this.objectConverter.insert(session, collectionNode, elementJcrName, item);
        }
    }

    private void insertManageableMap(Session session, ManageableObjects objects, Node collectionNode) {
        Map map = (Map)objects.getObjects();
        for (Object key : map.keySet()) {
            Object item = map.get(key);
            this.objectConverter.insert(session, collectionNode, key.toString(), item);
        }
    }

    protected void doUpdateCollection(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, ManageableObjects objects) throws RepositoryException {
        String jcrName = this.getCollectionJcrName(collectionDescriptor);
        boolean hasNode = parentNode.hasNode(jcrName);
        if (objects == null) {
            if (hasNode) {
                parentNode.getNode(jcrName).remove();
            }
            return;
        }
        if (!hasNode) {
            this.doInsertCollection(session, parentNode, collectionDescriptor, objects);
            return;
        }
        if (objects instanceof ManageableCollection) {
            this.updateManagableCollection(session, parentNode, collectionDescriptor, objects, jcrName);
        } else {
            this.updateManagableMap(session, parentNode, collectionDescriptor, objects, jcrName);
        }
    }

    private void updateManagableCollection(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, ManageableObjects objects, String jcrName) throws PathNotFoundException, RepositoryException, VersionException, LockException, ConstraintViolationException, ItemExistsException {
        ArrayList<Node> removeNodes;
        NodeIterator nodeIterator;
        ClassDescriptor elementClassDescriptor = this.mapper.getClassDescriptorByClass(ReflectionUtils.forName(collectionDescriptor.getElementClassName()));
        Node collectionNode = parentNode.getNode(jcrName);
        if (!elementClassDescriptor.hasIdField() && !elementClassDescriptor.hasUUIdField()) {
            String primaryNodeTypeName = collectionNode.getPrimaryNodeType().getName();
            collectionNode.remove();
            collectionNode = parentNode.addNode(jcrName, primaryNodeTypeName);
        }
        Iterator collectionIterator = objects.getIterator();
        HashMap updatedItems = new HashMap();
        ArrayList<String> validUuidsForTheNode = new ArrayList<String>();
        while (collectionIterator.hasNext()) {
            Object item = collectionIterator.next();
            String elementJcrName = null;
            if (elementClassDescriptor.hasUUIdField()) {
                String currentItemUuid;
                elementJcrName = collectionDescriptor.getJcrElementName();
                elementJcrName = elementJcrName == null ? COLLECTION_ELEMENT_NAME : elementJcrName;
                String uuidFieldName = elementClassDescriptor.getUuidFieldDescriptor().getFieldName();
                Object objUuid = ReflectionUtils.getNestedProperty(item, uuidFieldName);
                String string = currentItemUuid = objUuid == null ? null : objUuid.toString();
                if (currentItemUuid != null) {
                    Node nodeToUpdate = collectionNode.getSession().getNodeByIdentifier(currentItemUuid);
                    this.objectConverter.update(session, currentItemUuid, item);
                    validUuidsForTheNode.add(currentItemUuid);
                    continue;
                }
                this.objectConverter.insert(session, collectionNode, elementJcrName, item);
                validUuidsForTheNode.add(ReflectionUtils.getNestedProperty(item, uuidFieldName).toString());
                continue;
            }
            if (elementClassDescriptor.hasIdField()) {
                String idFieldName = elementClassDescriptor.getIdFieldDescriptor().getFieldName();
                elementJcrName = ReflectionUtils.getNestedProperty(item, idFieldName).toString();
                if (collectionNode.hasNode(elementJcrName)) {
                    this.objectConverter.update(session, collectionNode, elementJcrName, item);
                } else {
                    this.objectConverter.insert(session, collectionNode, elementJcrName, item);
                }
                updatedItems.put(elementJcrName, item);
                continue;
            }
            elementJcrName = collectionDescriptor.getJcrElementName();
            if (elementJcrName == null) {
                elementJcrName = COLLECTION_ELEMENT_NAME;
            }
            this.objectConverter.insert(session, collectionNode, elementJcrName, item);
        }
        if (elementClassDescriptor.hasUUIdField()) {
            nodeIterator = collectionNode.getNodes();
            removeNodes = new ArrayList<Node>();
            while (nodeIterator.hasNext()) {
                Node currentNode = nodeIterator.nextNode();
                if (validUuidsForTheNode.contains(currentNode.getIdentifier())) continue;
                removeNodes.add(currentNode);
            }
            for (Node aNode : removeNodes) {
                aNode.remove();
            }
            return;
        }
        if (elementClassDescriptor.hasIdField()) {
            nodeIterator = collectionNode.getNodes();
            removeNodes = new ArrayList();
            while (nodeIterator.hasNext()) {
                Node child = nodeIterator.nextNode();
                if (updatedItems.containsKey(child.getName())) continue;
                removeNodes.add(child);
            }
            for (int i = 0; i < removeNodes.size(); ++i) {
                ((Node)removeNodes.get(i)).remove();
            }
        }
    }

    private void updateManagableMap(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, ManageableObjects objects, String jcrName) throws PathNotFoundException, RepositoryException, VersionException, LockException, ConstraintViolationException, ItemExistsException {
        ClassDescriptor elementClassDescriptor = this.mapper.getClassDescriptorByClass(ReflectionUtils.forName(collectionDescriptor.getElementClassName()));
        Node collectionNode = parentNode.getNode(jcrName);
        Map map = (Map)objects.getObjects();
        HashMap updatedItems = new HashMap();
        for (Object key : map.keySet()) {
            Object item = map.get(key);
            if (collectionNode.hasNode(key.toString())) {
                this.objectConverter.update(session, collectionNode, key.toString(), item);
            } else {
                this.objectConverter.insert(session, collectionNode, key.toString(), item);
            }
            updatedItems.put(key.toString(), item);
        }
        NodeIterator nodeIterator = collectionNode.getNodes();
        ArrayList<Node> removeNodes = new ArrayList<Node>();
        while (nodeIterator.hasNext()) {
            Node child = nodeIterator.nextNode();
            if (updatedItems.containsKey(child.getName())) continue;
            removeNodes.add(child);
        }
        for (int i = 0; i < removeNodes.size(); ++i) {
            ((Node)removeNodes.get(i)).remove();
        }
    }

    protected ManageableObjects doGetCollection(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, Class collectionFieldClass) throws RepositoryException {
        String jcrName = this.getCollectionJcrName(collectionDescriptor);
        if (parentNode == null || !parentNode.hasNode(jcrName)) {
            return null;
        }
        ManageableObjects objects = ManageableObjectsUtil.getManageableObjects(collectionFieldClass);
        Node collectionNode = parentNode.getNode(jcrName);
        NodeIterator children = collectionNode.getNodes();
        Class elementClass = ReflectionUtils.forName(collectionDescriptor.getElementClassName());
        while (children.hasNext()) {
            Node itemNode = children.nextNode();
            Object item = this.objectConverter.getObject(session, elementClass, itemNode.getPath());
            if (objects instanceof ManageableCollection) {
                ((ManageableCollection)objects).addObject(item);
                continue;
            }
            ((ManageableMap)objects).addObject(itemNode.getName(), item);
        }
        return objects;
    }

    protected boolean doIsNull(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, Class collectionFieldClass) throws RepositoryException {
        String jcrName = this.getCollectionJcrName(collectionDescriptor);
        return parentNode == null || !parentNode.hasNode(jcrName);
    }
}

