/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.h2console.ui.services;

import javax.annotation.Priority;
import javax.inject.Inject;
import org.apache.isis.applib.IsisModuleApplib;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.applib.annotation.MemberSupport;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.RestrictTo;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.value.LocalResourcePath;
import org.apache.isis.testing.h2console.ui.webmodule.WebModuleH2Console;

@DomainService(nature=NatureOfService.VIEW, logicalTypeName="isis.ext.h2Console.H2ManagerMenu")
@DomainServiceLayout(named="Prototyping", menuBar=DomainServiceLayout.MenuBar.SECONDARY)
@Priority(value=0x1FFFFFFF)
public class H2ManagerMenu {
    public static final String LOGICAL_TYPE_NAME = "isis.ext.h2Console.H2ManagerMenu";
    private final WebModuleH2Console webModule;

    @Inject
    public H2ManagerMenu(WebModuleH2Console webModule) {
        this.webModule = webModule;
    }

    @Action(semantics=SemanticsOf.SAFE, restrictTo=RestrictTo.PROTOTYPING, domainEvent=ActionDomainEvent.class)
    @ActionLayout(named="H2 Console", cssClassFa="database", sequence="500.800")
    public LocalResourcePath openH2Console() {
        if (this.webModule == null) {
            return null;
        }
        return this.webModule.getLocalResourcePathIfEnabled();
    }

    @MemberSupport
    public boolean hideOpenH2Console() {
        return this.webModule == null || this.webModule.getLocalResourcePathIfEnabled() == null;
    }

    public static class ActionDomainEvent
    extends IsisModuleApplib.ActionDomainEvent<H2ManagerMenu> {
    }
}

