/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.udf;

import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.RowWindow;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.SlidingTimeWindowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlidingTimeWindowAccessStrategyExample
implements UDTF {
    private static final Logger LOGGER = LoggerFactory.getLogger(SlidingTimeWindowAccessStrategyExample.class);
    public static final String START = "start";
    public static final String END = "end";
    public static final String STEP = "step";
    public static final String INTERVAL = "interval";

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        LOGGER.info("###### TestSlidingTimeWindow # beforeStart #######");
        String param = parameters.getAttributes().toString();
        LOGGER.info("attributes: {}", (Object)param);
        if (parameters.hasAttribute(START) && parameters.hasAttribute(END)) {
            if (parameters.hasAttribute(STEP)) {
                configurations.setOutputDataType(Type.INT64).setAccessStrategy((AccessStrategy)new SlidingTimeWindowAccessStrategy((long)parameters.getInt(INTERVAL).intValue(), (long)parameters.getInt(STEP).intValue(), parameters.getLong(START).longValue(), parameters.getLong(END).longValue()));
            } else {
                configurations.setOutputDataType(Type.INT64).setAccessStrategy((AccessStrategy)new SlidingTimeWindowAccessStrategy((long)parameters.getInt(INTERVAL).intValue(), (long)parameters.getInt(INTERVAL).intValue(), parameters.getLong(START).longValue(), parameters.getLong(END).longValue()));
            }
        } else {
            if (parameters.hasAttribute(START) || parameters.hasAttribute(END)) {
                throw new IllegalArgumentException("start and end must be both existed. ");
            }
            if (parameters.hasAttribute(STEP)) {
                configurations.setOutputDataType(Type.INT64).setAccessStrategy((AccessStrategy)new SlidingTimeWindowAccessStrategy((long)parameters.getInt(INTERVAL).intValue(), (long)parameters.getInt(STEP).intValue()));
            } else {
                configurations.setOutputDataType(Type.INT64).setAccessStrategy((AccessStrategy)new SlidingTimeWindowAccessStrategy((long)parameters.getInt(INTERVAL).intValue()));
            }
        }
    }

    public void transform(RowWindow rowWindow, PointCollector collector) throws Exception {
        LOGGER.info("######### TestSlidingTimeWindow # [{}] ########", (Object)rowWindow.windowSize());
        long result = 0L;
        for (int i = 0; i < rowWindow.windowSize(); ++i) {
            if (rowWindow.getRow(i).isNull(0)) continue;
            result += rowWindow.getRow(i).getLong(0);
        }
        collector.putLong(rowWindow.windowStartTime(), result);
    }

    public void beforeDestroy() {
        LOGGER.info("###### TestSlidingTimeWindow # beforeDestroy #######");
    }

    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateRequiredAttribute(INTERVAL);
        validator.validateInputSeriesDataType(0, Type.INT64);
    }
}

