/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common.type;

import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.DoubleColumnBuilder;
import org.apache.iotdb.tsfile.read.common.type.Type;
import org.apache.iotdb.tsfile.read.common.type.TypeEnum;

public class DoubleType
implements Type {
    private static final DoubleType INSTANCE = new DoubleType();

    private DoubleType() {
    }

    @Override
    public int getInt(Column c, int position) {
        return (int)c.getDouble(position);
    }

    @Override
    public long getLong(Column c, int position) {
        return (long)c.getDouble(position);
    }

    @Override
    public float getFloat(Column c, int position) {
        return (float)c.getDouble(position);
    }

    @Override
    public double getDouble(Column c, int position) {
        return c.getDouble(position);
    }

    @Override
    public void writeInt(ColumnBuilder builder, int value) {
        builder.writeDouble((double)value);
    }

    @Override
    public void writeLong(ColumnBuilder builder, long value) {
        builder.writeDouble((double)value);
    }

    @Override
    public void writeFloat(ColumnBuilder builder, float value) {
        builder.writeDouble((double)value);
    }

    @Override
    public void writeDouble(ColumnBuilder builder, double value) {
        builder.writeDouble(value);
    }

    @Override
    public ColumnBuilder createColumnBuilder(int expectedEntries) {
        return new DoubleColumnBuilder(null, expectedEntries);
    }

    @Override
    public TypeEnum getTypeEnum() {
        return TypeEnum.DOUBLE;
    }

    public static DoubleType getInstance() {
        return INSTANCE;
    }
}

