/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.trigger;

import java.util.List;
import org.apache.iotdb.trigger.api.Trigger;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerTrigger
implements Trigger {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggerTrigger.class);

    public boolean fire(Tablet tablet) throws Exception {
        List measurementSchemaList = tablet.getSchemas();
        int n = measurementSchemaList.size();
        for (int i = 0; i < n; ++i) {
            if (((MeasurementSchema)measurementSchemaList.get(i)).getType().equals((Object)TSDataType.DOUBLE)) {
                this.logDouble((double[])tablet.values[i]);
                continue;
            }
            if (((MeasurementSchema)measurementSchemaList.get(i)).getType().equals((Object)TSDataType.FLOAT)) {
                this.logFloat((float[])tablet.values[i]);
                continue;
            }
            if (((MeasurementSchema)measurementSchemaList.get(i)).getType().equals((Object)TSDataType.INT64)) {
                this.logLong((long[])tablet.values[i]);
                continue;
            }
            if (((MeasurementSchema)measurementSchemaList.get(i)).getType().equals((Object)TSDataType.INT32)) {
                this.logInt((int[])tablet.values[i]);
                continue;
            }
            if (((MeasurementSchema)measurementSchemaList.get(i)).getType().equals((Object)TSDataType.TEXT)) {
                this.logText((Binary[])tablet.values[i]);
                continue;
            }
            if (!((MeasurementSchema)measurementSchemaList.get(i)).getType().equals((Object)TSDataType.BOOLEAN)) continue;
            this.logBoolean((boolean[])tablet.values[i]);
        }
        return true;
    }

    private void logDouble(double[] values) {
        for (double value : values) {
            if (!(value > 100.0)) continue;
            LOGGER.info("Double type, trigger value > 100");
        }
    }

    private void logFloat(float[] values) {
        for (float value : values) {
            if (!(value > 100.0f)) continue;
            LOGGER.info("Float type, trigger value > 100");
        }
    }

    private void logLong(long[] values) {
        for (long value : values) {
            if (value <= -100L) continue;
            LOGGER.info("Int64 type, trigger value > -100");
        }
    }

    private void logInt(int[] values) {
        for (int value : values) {
            if (value <= -100) continue;
            LOGGER.info("Int32 type, trigger value > -100");
        }
    }

    private void logText(Binary[] values) {
        for (Binary ignored : values) {
            LOGGER.info("Text type, trigger Non empty");
        }
    }

    private void logBoolean(boolean[] values) {
        for (boolean ignored : values) {
            LOGGER.info("Boolean type, trigger fires");
        }
    }
}

