/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.opcua;

import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.api.identity.AnonymousProvider;
import org.eclipse.milo.opcua.sdk.client.api.identity.IdentityProvider;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;

public interface ClientExample {
    default public String getEndpointUrl() {
        return "opc.tcp://127.0.0.1:12686/iotdb";
    }

    default public Predicate<EndpointDescription> endpointFilter() {
        return e -> this.getSecurityPolicy().getUri().equals(e.getSecurityPolicyUri());
    }

    default public SecurityPolicy getSecurityPolicy() {
        return SecurityPolicy.Basic256Sha256;
    }

    default public IdentityProvider getIdentityProvider() {
        return new AnonymousProvider();
    }

    public void run(OpcUaClient var1, CompletableFuture<OpcUaClient> var2) throws Exception;
}

