/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.auth.authorizer;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.Key;
import java.security.interfaces.RSAPublicKey;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.UUID;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.auth.authorizer.BasicAuthorizer;
import org.apache.iotdb.commons.auth.role.LocalFileRoleManager;
import org.apache.iotdb.commons.auth.user.LocalFileUserManager;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenIdAuthorizer
extends BasicAuthorizer {
    private static final Logger logger = LoggerFactory.getLogger(OpenIdAuthorizer.class);
    public static final String IOTDB_ADMIN_ROLE_NAME = "iotdb_admin";
    public static final String OPENID_USER_PREFIX = "openid-";
    private static final CommonConfig config = CommonDescriptor.getInstance().getConfig();
    private final RSAPublicKey providerKey;
    private final Map<String, Claims> loggedClaims = new HashMap<String, Claims>();

    public OpenIdAuthorizer() throws AuthException, ParseException, IOException, URISyntaxException {
        this(config.getOpenIdProviderUrl());
    }

    public OpenIdAuthorizer(JSONObject jwk) throws AuthException {
        super(new LocalFileUserManager(config.getUserFolder()), new LocalFileRoleManager(config.getRoleFolder()));
        try {
            this.providerKey = RSAKey.parse((Map)jwk).toRSAPublicKey();
        }
        catch (JOSEException | java.text.ParseException e) {
            throw new AuthException(TSStatusCode.INIT_AUTH_ERROR, "Unable to get OIDC Provider Key from JWK " + jwk, e);
        }
        logger.info("Initialized with providerKey: {}", (Object)this.providerKey);
    }

    public OpenIdAuthorizer(String providerUrl) throws AuthException, URISyntaxException, ParseException, IOException {
        this(OpenIdAuthorizer.getJwkFromProvider(providerUrl));
    }

    private static JSONObject getJwkFromProvider(String providerUrl) throws URISyntaxException, IOException, ParseException, AuthException {
        if (providerUrl == null) {
            throw new IllegalArgumentException("OpenID Connect Provider URI must be given!");
        }
        OIDCProviderMetadata providerMetadata = OpenIdAuthorizer.fetchMetadata(providerUrl);
        logger.debug("Using Provider Metadata: {}", (Object)providerMetadata);
        try {
            URL url = new URI(providerMetadata.getJWKSetURI().toString()).toURL();
            logger.debug("Using url {}", (Object)url);
            return OpenIdAuthorizer.getProviderRsaJwk(url.openStream());
        }
        catch (IOException e) {
            throw new AuthException(TSStatusCode.INIT_AUTH_ERROR, "Unable to start the Auth", e);
        }
    }

    private static JSONObject getProviderRsaJwk(InputStream is) throws ParseException {
        StringBuilder sb = new StringBuilder();
        try (Scanner scanner = new Scanner(is);){
            while (scanner.hasNext()) {
                sb.append(scanner.next());
            }
        }
        String jsonString = sb.toString();
        JSONObject json = JSONObjectUtils.parse((String)jsonString);
        JSONArray keyList = (JSONArray)json.get((Object)"keys");
        for (Object key : keyList) {
            JSONObject k = (JSONObject)key;
            if (!"sig".equals(k.get((Object)"use")) || !"RSA".equals(k.get((Object)"kty"))) continue;
            return k;
        }
        return null;
    }

    private static OIDCProviderMetadata fetchMetadata(String providerUrl) throws URISyntaxException, IOException, ParseException {
        String providerInfo;
        URI issuerUri = new URI(providerUrl);
        URL providerConfigurationUrl = issuerUri.resolve(".well-known/openid-configuration").toURL();
        InputStream stream = providerConfigurationUrl.openStream();
        try (Scanner s = new Scanner(stream);){
            providerInfo = s.useDelimiter("\\A").hasNext() ? s.next() : "";
        }
        return OIDCProviderMetadata.parse((String)providerInfo);
    }

    @Override
    public boolean login(String token, String password) throws AuthException {
        Claims claims;
        if (password != null && !password.isEmpty()) {
            logger.error("JWT Login failed as a non-empty Password was given username (token): {}", (Object)token);
            return false;
        }
        if (token == null || token.isEmpty()) {
            logger.error("JWT Login failed as a Username (token) was empty!");
            return false;
        }
        try {
            claims = this.validateToken(token);
        }
        catch (JwtException e) {
            logger.error("Unable to login the user with Username (token) {}", (Object)token, (Object)e);
            return false;
        }
        logger.debug("JWT was validated successfully!");
        logger.debug("ID: {}", (Object)claims.getId());
        logger.debug("Subject: {}", (Object)claims.getSubject());
        logger.debug("Issuer: {}", (Object)claims.getIssuer());
        logger.debug("Expiration: {}", (Object)claims.getExpiration());
        String iotdbUsername = this.getUsername(claims);
        if (!super.listAllUsers().contains(iotdbUsername)) {
            logger.info("User {} logs in for first time, storing it locally!", (Object)iotdbUsername);
            super.createUserWithoutCheck(iotdbUsername, UUID.randomUUID().toString());
        }
        this.loggedClaims.put(this.getUsername(claims), claims);
        return true;
    }

    public String getIoTDBUserName(String token) {
        Claims claims = this.validateToken(token);
        logger.debug("JWT was validated successfully!");
        logger.debug("ID: {}", (Object)claims.getId());
        logger.debug("Subject: {}", (Object)claims.getSubject());
        logger.debug("Issuer: {}", (Object)claims.getIssuer());
        logger.debug("Expiration: {}", (Object)claims.getExpiration());
        return this.getUsername(claims);
    }

    private Claims validateToken(String token) {
        return (Claims)Jwts.parser().setAllowedClockSkewSeconds(9223372036854775L).setSigningKey((Key)this.providerKey).parseClaimsJws(token).getBody();
    }

    private String getUsername(Claims claims) {
        return OPENID_USER_PREFIX + claims.getSubject();
    }

    @Override
    public void createUser(String username, String password) {
        this.throwUnsupportedOperationException();
    }

    private void throwUnsupportedOperationException() {
        throw new UnsupportedOperationException("This operation is not supported for JWT Auth Provider!");
    }

    @Override
    public void deleteUser(String username) {
        this.throwUnsupportedOperationException();
    }

    @Override
    public boolean isAdmin(String token) {
        Claims claims;
        if (this.loggedClaims.containsKey(token)) {
            claims = this.loggedClaims.get(token);
        } else {
            try {
                claims = this.validateToken(token);
            }
            catch (JwtException e) {
                logger.warn("Unable to validate token {}!", (Object)token, (Object)e);
                return false;
            }
        }
        List availableRoles = (List)((Map)claims.get((Object)"realm_access")).get("roles");
        if (!availableRoles.contains(IOTDB_ADMIN_ROLE_NAME)) {
            logger.warn("Given Token has no admin rights, is there a ROLE with name {} in 'realm_access' role set?", (Object)IOTDB_ADMIN_ROLE_NAME);
            return false;
        }
        return true;
    }

    @Override
    public boolean checkUserPrivileges(String username, PartialPath path, int privilegeId) throws AuthException {
        return this.isAdmin(username);
    }

    @Override
    public void updateUserPassword(String username, String newPassword) {
        this.throwUnsupportedOperationException();
    }
}

