/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.connector.payload.request;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.apache.iotdb.commons.pipe.connector.payload.request.IoTDBConnectorRequestVersion;
import org.apache.iotdb.commons.pipe.connector.payload.request.PipeRequestType;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class PipeTransferSnapshotPieceReq
extends TPipeTransferReq {
    private transient String snapshotName;
    private transient long startWritingOffset;
    private transient byte[] snapshotPiece;

    private PipeTransferSnapshotPieceReq() {
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public long getStartWritingOffset() {
        return this.startWritingOffset;
    }

    public byte[] getSnapshotPiece() {
        return this.snapshotPiece;
    }

    public static PipeTransferSnapshotPieceReq toTPipeTransferReq(String snapshotName, long startWritingOffset, byte[] snapshotPiece) throws IOException {
        PipeTransferSnapshotPieceReq snapshotPieceReq = new PipeTransferSnapshotPieceReq();
        snapshotPieceReq.snapshotName = snapshotName;
        snapshotPieceReq.startWritingOffset = startWritingOffset;
        snapshotPieceReq.snapshotPiece = snapshotPiece;
        snapshotPieceReq.version = IoTDBConnectorRequestVersion.VERSION_1.getVersion();
        snapshotPieceReq.type = PipeRequestType.TRANSFER_SNAPSHOT_PIECE.getType();
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
            ReadWriteIOUtils.write((String)snapshotName, (OutputStream)outputStream);
            ReadWriteIOUtils.write((long)startWritingOffset, (OutputStream)outputStream);
            ReadWriteIOUtils.write((Binary)new Binary(snapshotPiece), (OutputStream)outputStream);
            snapshotPieceReq.body = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
        }
        return snapshotPieceReq;
    }

    public static PipeTransferSnapshotPieceReq fromTPipeTransferReq(TPipeTransferReq transferReq) {
        PipeTransferSnapshotPieceReq snapshotPieceReq = new PipeTransferSnapshotPieceReq();
        snapshotPieceReq.snapshotName = ReadWriteIOUtils.readString((ByteBuffer)transferReq.body);
        snapshotPieceReq.startWritingOffset = ReadWriteIOUtils.readLong((ByteBuffer)transferReq.body);
        snapshotPieceReq.snapshotPiece = ReadWriteIOUtils.readBinary((ByteBuffer)transferReq.body).getValues();
        snapshotPieceReq.version = transferReq.version;
        snapshotPieceReq.type = transferReq.type;
        snapshotPieceReq.body = transferReq.body;
        return snapshotPieceReq;
    }

    public static byte[] toTPipeTransferBytes(String snapshotName, long startWritingOffset, byte[] snapshotPiece) throws IOException {
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();){
            byte[] byArray;
            try (DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
                ReadWriteIOUtils.write((byte)IoTDBConnectorRequestVersion.VERSION_1.getVersion(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((short)PipeRequestType.TRANSFER_SNAPSHOT_PIECE.getType(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((String)snapshotName, (OutputStream)outputStream);
                ReadWriteIOUtils.write((long)startWritingOffset, (OutputStream)outputStream);
                ReadWriteIOUtils.write((Binary)new Binary(snapshotPiece), (OutputStream)outputStream);
                byArray = byteArrayOutputStream.toByteArray();
            }
            return byArray;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PipeTransferSnapshotPieceReq that = (PipeTransferSnapshotPieceReq)((Object)obj);
        return this.snapshotName.equals(that.snapshotName) && this.startWritingOffset == that.startWritingOffset && Arrays.equals(this.snapshotPiece, that.snapshotPiece) && this.version == that.version && this.type == that.type && this.body.equals(that.body);
    }

    public int hashCode() {
        return Objects.hash(this.snapshotName, this.startWritingOffset, Arrays.hashCode(this.snapshotPiece), this.version, this.type, this.body);
    }
}

