/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDate;
import org.apache.iotdb.jdbc.IoTDBSQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(JDBCExample.class);

    public static void main(String[] args) throws ClassNotFoundException, SQLException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667?version=V_1_0", "root", "root");
             Statement statement = connection.createStatement();){
            statement.setFetchSize(10000);
            statement.execute("CREATE DATABASE root.sg1");
            statement.execute("CREATE TIMESERIES root.sg1.d1.s1 WITH DATATYPE=INT64, ENCODING=RLE, COMPRESSOR=SNAPPY");
            statement.execute("CREATE TIMESERIES root.sg1.d1.s2 WITH DATATYPE=INT64, ENCODING=RLE, COMPRESSOR=SNAPPY");
            statement.execute("CREATE TIMESERIES root.sg1.d1.s3 WITH DATATYPE=INT64, ENCODING=RLE, COMPRESSOR=SNAPPY");
            statement.execute("CREATE TIMESERIES root.sg1.d1.s4 WITH DATATYPE=DATE, ENCODING=PLAIN, COMPRESSOR=SNAPPY");
            statement.execute("CREATE TIMESERIES root.sg1.d1.s5 WITH DATATYPE=TIMESTAMP, ENCODING=PLAIN, COMPRESSOR=SNAPPY");
            statement.execute("CREATE TIMESERIES root.sg1.d1.s6 WITH DATATYPE=BLOB, ENCODING=PLAIN, COMPRESSOR=SNAPPY");
            statement.execute("CREATE TIMESERIES root.sg1.d1.s7 WITH DATATYPE=STRING, ENCODING=PLAIN, COMPRESSOR=SNAPPY");
            for (int i = 0; i <= 100; ++i) {
                statement.addBatch(JDBCExample.prepareInsertStatement(i));
            }
            statement.executeBatch();
            statement.clearBatch();
            ResultSet resultSet = statement.executeQuery("select ** from root where time <= 10");
            JDBCExample.outputResult(resultSet);
            resultSet = statement.executeQuery("select count(**) from root");
            JDBCExample.outputResult(resultSet);
            resultSet = statement.executeQuery("select count(**) from root where time >= 1 and time <= 100 group by ([0, 100), 20ms, 20ms)");
            JDBCExample.outputResult(resultSet);
        }
        catch (IoTDBSQLException e) {
            LOGGER.error("IoTDB Jdbc example error", (Throwable)e);
        }
    }

    private static void outputResult(ResultSet resultSet) throws SQLException {
        if (resultSet != null) {
            int i;
            System.out.println("--------------------------");
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            for (i = 0; i < columnCount; ++i) {
                System.out.print(metaData.getColumnLabel(i + 1) + " ");
            }
            System.out.println();
            block1: while (resultSet.next()) {
                i = 1;
                while (true) {
                    System.out.print(resultSet.getString(i));
                    if (i >= columnCount) {
                        System.out.println();
                        continue block1;
                    }
                    System.out.print(", ");
                    ++i;
                }
            }
            System.out.println("--------------------------\n");
        }
    }

    private static String prepareInsertStatement(int time) {
        return String.format("insert into root.sg1.d1(timestamp, s1, s2, s3, s4, s5, s6, s7) values(%d, %d, %d, %d, \"%s\", %d, %s, \"%s\")", time, 1, 1, 1, LocalDate.of(2024, 5, time % 31 + 1), time, "X'cafebabe'", time);
    }
}

