/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.metadata;

import com.google.errorprone.annotations.Immutable;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.MetadataUtil;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.QualifiedObjectName;

@Immutable
public class QualifiedTablePrefix {
    private final String databaseName;
    private final Optional<String> tableName;

    public QualifiedTablePrefix(String databaseName) {
        this.databaseName = MetadataUtil.checkDatabaseName(databaseName);
        this.tableName = Optional.empty();
    }

    public QualifiedTablePrefix(String databaseName, String tableName) {
        this.databaseName = MetadataUtil.checkDatabaseName(databaseName);
        this.tableName = Optional.of(MetadataUtil.checkTableName(tableName));
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public Optional<String> getTableName() {
        return this.tableName;
    }

    public boolean hasTableName() {
        return this.tableName.isPresent();
    }

    public Optional<QualifiedObjectName> asQualifiedObjectName() {
        return this.tableName.map(s -> new QualifiedObjectName(this.databaseName, (String)s));
    }

    public boolean matches(QualifiedObjectName objectName) {
        return Objects.equals(this.databaseName, objectName.getDatabaseName()) && this.tableName.map(table -> Objects.equals(table, objectName.getObjectName())).orElse(true) != false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QualifiedTablePrefix o = (QualifiedTablePrefix)obj;
        return Objects.equals(this.databaseName, o.databaseName) && Objects.equals(this.tableName, o.tableName);
    }

    public int hashCode() {
        return Objects.hash(this.databaseName, this.tableName);
    }

    public String toString() {
        return this.databaseName + '.' + this.tableName.orElse("*");
    }
}

