/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.io;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALEntry;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALEntryType;
import org.apache.iotdb.db.storageengine.dataregion.wal.io.WALInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WALReader
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(WALReader.class);
    private static final int STREAM_BUFFER_SIZE = (int)IoTDBDescriptor.getInstance().getConfig().getWalFileSizeThresholdInByte() / 10;
    private final File logFile;
    private final boolean fileMayCorrupt;
    private final WALInputStream walInputStream;
    private final DataInputStream logStream;
    private WALEntry nextEntry;
    private boolean fileCorrupted = false;

    public WALReader(File logFile) throws IOException {
        this(logFile, false);
    }

    public WALReader(File logFile, boolean fileMayCorrupt) throws IOException {
        this.logFile = logFile;
        this.fileMayCorrupt = fileMayCorrupt;
        this.walInputStream = new WALInputStream(logFile);
        this.logStream = new DataInputStream(this.walInputStream);
    }

    public boolean hasNext() {
        if (this.nextEntry != null) {
            return true;
        }
        if (this.fileCorrupted) {
            return false;
        }
        try {
            this.nextEntry = WALEntry.deserialize(this.logStream);
            if (this.nextEntry.getType() == WALEntryType.WAL_FILE_INFO_END_MARKER) {
                this.nextEntry = null;
                return false;
            }
        }
        catch (EOFException e) {
            this.fileCorrupted = true;
            return false;
        }
        catch (IOException e) {
            this.fileCorrupted = true;
            if (!this.fileMayCorrupt) {
                logger.warn("Fail to read WALEntry from wal file {}, skip broken WALEntries.", (Object)this.logFile, (Object)e);
            }
        }
        catch (Exception e) {
            this.fileCorrupted = true;
            logger.warn("Fail to read WALEntry from wal file {}, skip broken WALEntries.", (Object)this.logFile, (Object)e);
        }
        return this.nextEntry != null;
    }

    public long getWALCurrentReadOffset() throws IOException {
        return this.walInputStream.getFileCurrentPos();
    }

    public WALEntry next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        WALEntry next = this.nextEntry;
        this.nextEntry = null;
        return next;
    }

    @Override
    public void close() throws IOException {
        this.logStream.close();
    }
}

