/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.memtable;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.dataregion.memtable.AbstractWritableMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALWriteUtils;
import org.apache.iotdb.db.utils.ModificationUtils;
import org.apache.iotdb.db.utils.datastructure.AlignedTVList;
import org.apache.iotdb.db.utils.datastructure.BatchEncodeInfo;
import org.apache.iotdb.db.utils.datastructure.MemPointIterator;
import org.apache.iotdb.db.utils.datastructure.MemPointIteratorFactory;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.UnSupportedDataTypeException;
import org.apache.tsfile.write.chunk.AlignedChunkWriterImpl;
import org.apache.tsfile.write.chunk.IChunkWriter;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchema;

public class AlignedWritableMemChunk
extends AbstractWritableMemChunk {
    private final Map<String, Integer> measurementIndexMap;
    private List<TSDataType> dataTypes;
    private final List<IMeasurementSchema> schemaList;
    private AlignedTVList list;
    private List<AlignedTVList> sortedList;
    private long sortedRowCount = 0L;
    private final boolean ignoreAllNullRows;
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private final int TVLIST_SORT_THRESHOLD = CONFIG.getTvListSortThreshold();
    private static final String UNSUPPORTED_TYPE = "Unsupported data type:";

    public AlignedWritableMemChunk(List<IMeasurementSchema> schemaList, boolean isTableModel) {
        this.measurementIndexMap = new LinkedHashMap<String, Integer>();
        this.dataTypes = new ArrayList<TSDataType>();
        this.schemaList = schemaList;
        for (int i = 0; i < schemaList.size(); ++i) {
            this.measurementIndexMap.put(schemaList.get(i).getMeasurementName(), i);
            this.dataTypes.add(schemaList.get(i).getType());
        }
        this.list = AlignedTVList.newAlignedList(this.dataTypes);
        this.sortedList = new ArrayList<AlignedTVList>();
        this.ignoreAllNullRows = !isTableModel;
    }

    private AlignedWritableMemChunk(List<IMeasurementSchema> schemaList, AlignedTVList list, boolean isTableModel) {
        this.measurementIndexMap = new LinkedHashMap<String, Integer>();
        this.schemaList = schemaList;
        for (int i = 0; i < schemaList.size(); ++i) {
            this.measurementIndexMap.put(schemaList.get(i).getMeasurementName(), i);
        }
        this.list = list;
        this.dataTypes = list.getTsDataTypes();
        this.sortedList = new ArrayList<AlignedTVList>();
        this.ignoreAllNullRows = !isTableModel;
    }

    public Set<String> getAllMeasurements() {
        return this.measurementIndexMap.keySet();
    }

    public boolean containsMeasurement(String measurementId) {
        return this.measurementIndexMap.containsKey(measurementId);
    }

    @Override
    public void putLong(long t, long v) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + TSDataType.VECTOR);
    }

    @Override
    public void putInt(long t, int v) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + TSDataType.VECTOR);
    }

    @Override
    public void putFloat(long t, float v) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + TSDataType.VECTOR);
    }

    @Override
    public void putDouble(long t, double v) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + TSDataType.VECTOR);
    }

    @Override
    public void putBinary(long t, Binary v) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + TSDataType.VECTOR);
    }

    @Override
    public void putBoolean(long t, boolean v) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + TSDataType.VECTOR);
    }

    @Override
    public void putAlignedRow(long t, Object[] v) {
        this.list.putAlignedValue(t, v);
    }

    @Override
    public void putLongs(long[] t, long[] v, BitMap bitMap, int start, int end) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + TSDataType.VECTOR);
    }

    @Override
    public void putInts(long[] t, int[] v, BitMap bitMap, int start, int end) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + TSDataType.VECTOR);
    }

    @Override
    public void putFloats(long[] t, float[] v, BitMap bitMap, int start, int end) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + TSDataType.VECTOR);
    }

    @Override
    public void putDoubles(long[] t, double[] v, BitMap bitMap, int start, int end) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + TSDataType.VECTOR);
    }

    @Override
    public void putBinaries(long[] t, Binary[] v, BitMap bitMap, int start, int end) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + TSDataType.VECTOR);
    }

    @Override
    public void putBooleans(long[] t, boolean[] v, BitMap bitMap, int start, int end) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + TSDataType.VECTOR);
    }

    @Override
    public void putAlignedTablet(long[] t, Object[] v, BitMap[] bitMaps, int start, int end, TSStatus[] results) {
        this.list.putAlignedValues(t, v, bitMaps, start, end, results);
    }

    @Override
    public void writeNonAlignedPoint(long insertTime, Object objectValue) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + TSDataType.VECTOR);
    }

    @Override
    public void writeNonAlignedTablet(long[] times, Object valueList, BitMap bitMap, TSDataType dataType, int start, int end) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + TSDataType.VECTOR);
    }

    protected void handoverAlignedTvList() {
        if (!this.list.isSorted()) {
            this.list.sort();
        }
        this.sortedList.add(this.list);
        this.sortedRowCount += (long)this.list.rowCount();
        this.list = AlignedTVList.newAlignedList(new ArrayList<TSDataType>(this.dataTypes));
        this.dataTypes = this.list.getTsDataTypes();
    }

    @Override
    public void writeAlignedPoints(long insertTime, Object[] objectValue, List<IMeasurementSchema> schemaList) {
        Object[] reorderedValue = (Object[])this.checkAndReorderColumnValuesInInsertPlan(schemaList, (Object[])objectValue, null).left;
        this.putAlignedRow(insertTime, reorderedValue);
        if (this.TVLIST_SORT_THRESHOLD > 0 && this.list.rowCount() >= this.TVLIST_SORT_THRESHOLD) {
            this.handoverAlignedTvList();
        }
    }

    @Override
    public void writeAlignedTablet(long[] times, Object[] valueList, BitMap[] bitMaps, List<IMeasurementSchema> schemaList, int start, int end, TSStatus[] results) {
        Pair<Object[], BitMap[]> pair = this.checkAndReorderColumnValuesInInsertPlan(schemaList, valueList, bitMaps);
        Object[] reorderedColumnValues = (Object[])pair.left;
        BitMap[] reorderedBitMaps = (BitMap[])pair.right;
        this.putAlignedTablet(times, reorderedColumnValues, reorderedBitMaps, start, end, results);
        if (this.TVLIST_SORT_THRESHOLD > 0 && this.list.rowCount() >= this.TVLIST_SORT_THRESHOLD) {
            this.handoverAlignedTvList();
        }
    }

    private Pair<Object[], BitMap[]> checkAndReorderColumnValuesInInsertPlan(List<IMeasurementSchema> schemaListInInsertPlan, Object[] columnValues, BitMap[] bitMaps) {
        Object[] reorderedColumnValues = new Object[this.schemaList.size()];
        BitMap[] reorderedBitMaps = bitMaps == null ? null : new BitMap[this.schemaList.size()];
        for (int i = 0; i < schemaListInInsertPlan.size(); ++i) {
            IMeasurementSchema measurementSchema = schemaListInInsertPlan.get(i);
            if (measurementSchema == null) continue;
            Integer index = this.measurementIndexMap.get(measurementSchema.getMeasurementName());
            if (index == null) {
                index = this.list.getTsDataTypes().size();
                this.measurementIndexMap.put(schemaListInInsertPlan.get(i).getMeasurementName(), index);
                this.schemaList.add(schemaListInInsertPlan.get(i));
                this.list.extendColumn(schemaListInInsertPlan.get(i).getType());
                reorderedColumnValues = Arrays.copyOf(reorderedColumnValues, reorderedColumnValues.length + 1);
                if (reorderedBitMaps != null) {
                    reorderedBitMaps = Arrays.copyOf(reorderedBitMaps, reorderedBitMaps.length + 1);
                }
            }
            reorderedColumnValues[index.intValue()] = columnValues[i];
            if (bitMaps == null) continue;
            reorderedBitMaps[index.intValue()] = bitMaps[i];
        }
        return new Pair((Object)reorderedColumnValues, (Object)reorderedBitMaps);
    }

    private void filterDeletedTimeStamp(AlignedTVList alignedTVList, List<List<TimeRange>> valueColumnsDeletionList, boolean ignoreAllNullRows, Map<Long, BitMap> timestampWithBitmap) {
        BitMap allValueColDeletedMap = alignedTVList.getAllValueColDeletedMap();
        int rowCount = alignedTVList.rowCount();
        ArrayList valueColumnDeleteCursor = new ArrayList();
        if (valueColumnsDeletionList != null) {
            valueColumnsDeletionList.forEach(x -> valueColumnDeleteCursor.add(new int[]{0}));
        }
        for (int row = 0; row < rowCount; ++row) {
            if (allValueColDeletedMap != null && allValueColDeletedMap.isMarked(row)) continue;
            long timestamp = alignedTVList.getTime(row);
            BitMap bitMap = new BitMap(this.schemaList.size());
            for (int column = 0; column < this.schemaList.size(); ++column) {
                if (alignedTVList.isNullValue(alignedTVList.getValueIndex(row), column)) {
                    bitMap.mark(column);
                }
                if (valueColumnsDeletionList != null && !valueColumnsDeletionList.isEmpty() && ModificationUtils.isPointDeleted(timestamp, valueColumnsDeletionList.get(column), (int[])valueColumnDeleteCursor.get(column))) {
                    bitMap.mark(column);
                }
                if (ignoreAllNullRows && bitMap.isAllMarked()) continue;
                timestampWithBitmap.put(timestamp, bitMap);
            }
        }
    }

    public long[] getFilteredTimestamp(List<List<TimeRange>> deletionList, List<BitMap> bitMaps, boolean ignoreAllNullRows) {
        TreeMap<Long, BitMap> timestampWithBitmap = new TreeMap<Long, BitMap>();
        this.filterDeletedTimeStamp(this.list, deletionList, ignoreAllNullRows, timestampWithBitmap);
        for (AlignedTVList alignedTVList : this.sortedList) {
            this.filterDeletedTimeStamp(alignedTVList, deletionList, ignoreAllNullRows, timestampWithBitmap);
        }
        ArrayList<Long> filteredTimestamps = new ArrayList<Long>();
        for (Map.Entry entry : timestampWithBitmap.entrySet()) {
            filteredTimestamps.add((Long)entry.getKey());
            bitMaps.add((BitMap)entry.getValue());
        }
        return filteredTimestamps.stream().mapToLong(Long::valueOf).toArray();
    }

    @Override
    public AlignedTVList getWorkingTVList() {
        return this.list;
    }

    @Override
    public void setWorkingTVList(TVList list) {
        this.list = (AlignedTVList)list;
    }

    @Override
    public long count() {
        if (!this.ignoreAllNullRows && this.measurementIndexMap.isEmpty()) {
            return this.rowCount();
        }
        return this.rowCount() * (long)this.measurementIndexMap.size();
    }

    @Override
    public long rowCount() {
        return this.sortedRowCount + (long)this.list.rowCount();
    }

    public int alignedListSize() {
        return (int)this.rowCount();
    }

    @Override
    public IMeasurementSchema getSchema() {
        return null;
    }

    @Override
    public long getMaxTime() {
        if (this.isEmpty()) {
            return Long.MIN_VALUE;
        }
        long maxTime = this.list.getMaxTime();
        for (AlignedTVList alignedTvList : this.sortedList) {
            maxTime = Math.max(maxTime, alignedTvList.getMaxTime());
        }
        return maxTime;
    }

    @Override
    public long getMinTime() {
        long minTime = this.list.getMinTime();
        for (AlignedTVList alignedTvList : this.sortedList) {
            minTime = Math.min(minTime, alignedTvList.getMinTime());
        }
        return minTime;
    }

    @Override
    public synchronized void sortTvListForFlush() {
        if (!this.list.isSorted()) {
            this.list.sort();
        }
    }

    @Override
    public int delete(long lowerBound, long upperBound) {
        int deletedNumber = this.list.delete(lowerBound, upperBound);
        for (AlignedTVList alignedTvList : this.sortedList) {
            deletedNumber += alignedTvList.delete(lowerBound, upperBound);
        }
        return deletedNumber;
    }

    public int deleteTime(long lowerBound, long upperBound) {
        int deletedNumber = this.list.deleteTime(lowerBound, upperBound);
        for (AlignedTVList alignedTvList : this.sortedList) {
            deletedNumber += alignedTvList.deleteTime(lowerBound, upperBound);
        }
        return deletedNumber;
    }

    public Pair<Integer, Boolean> deleteDataFromAColumn(long lowerBound, long upperBound, String measurementId) {
        Pair<Integer, Boolean> deletePair = this.list.delete(lowerBound, upperBound, this.measurementIndexMap.get(measurementId));
        for (AlignedTVList alignedTvList : this.sortedList) {
            Pair<Integer, Boolean> p = alignedTvList.delete(lowerBound, upperBound, this.measurementIndexMap.get(measurementId));
            Pair<Integer, Boolean> pair = deletePair;
            Integer.valueOf((Integer)pair.left + (Integer)p.left);
            pair.left = pair.left;
            deletePair.right = (Boolean)deletePair.right != false && (Boolean)p.right != false;
        }
        return deletePair;
    }

    public void removeColumn(String measurementId) {
        int columnIndex = this.measurementIndexMap.get(measurementId);
        this.list.deleteColumn(columnIndex);
        for (AlignedTVList alignedTvList : this.sortedList) {
            alignedTvList.deleteColumn(columnIndex);
        }
        IMeasurementSchema schemaToBeRemoved = this.schemaList.get(columnIndex);
        this.measurementIndexMap.remove(schemaToBeRemoved.getMeasurementName());
    }

    @Override
    public IChunkWriter createIChunkWriter() {
        return new AlignedChunkWriterImpl(this.schemaList);
    }

    public void encodeWorkingAlignedTVList(BlockingQueue<Object> ioTaskQueue, long maxNumberOfPointsInChunk, int maxNumberOfPointsInPage) {
        BitMap allValueColDeletedMap = this.ignoreAllNullRows ? this.list.getAllValueColDeletedMap() : null;
        boolean[] timeDuplicateInfo = null;
        ArrayList<List<Integer>> chunkRange = new ArrayList<List<Integer>>();
        ArrayList<Integer> pageRange = new ArrayList<Integer>();
        int pointNumInPage = 0;
        int pointNumInChunk = 0;
        for (int sortedRowIndex = 0; sortedRowIndex < this.list.rowCount(); ++sortedRowIndex) {
            int nextRowIndex;
            long time = this.list.getTime(sortedRowIndex);
            if (pointNumInPage == 0) {
                pageRange.add(sortedRowIndex);
            }
            ++pointNumInChunk;
            if (++pointNumInPage == maxNumberOfPointsInPage) {
                pageRange.add(sortedRowIndex);
                pointNumInPage = 0;
            }
            if ((long)pointNumInChunk >= maxNumberOfPointsInChunk) {
                if (pointNumInPage != 0) {
                    pageRange.add(sortedRowIndex);
                    pointNumInPage = 0;
                }
                chunkRange.add(pageRange);
                pageRange = new ArrayList();
                pointNumInChunk = 0;
            }
            for (nextRowIndex = sortedRowIndex + 1; nextRowIndex < this.list.rowCount() && (allValueColDeletedMap != null && allValueColDeletedMap.isMarked(this.list.getValueIndex(nextRowIndex)) || this.list.isTimeDeleted(nextRowIndex)); ++nextRowIndex) {
            }
            if (nextRowIndex != this.list.rowCount() && time == this.list.getTime(nextRowIndex)) {
                if (Objects.isNull(timeDuplicateInfo)) {
                    timeDuplicateInfo = new boolean[this.list.rowCount()];
                }
                timeDuplicateInfo[sortedRowIndex] = true;
            }
            sortedRowIndex = nextRowIndex - 1;
        }
        if (pointNumInPage != 0) {
            pageRange.add(this.list.rowCount() - 1);
        }
        if (pointNumInChunk != 0) {
            chunkRange.add(pageRange);
        }
        this.handleEncoding(ioTaskQueue, chunkRange, timeDuplicateInfo, allValueColDeletedMap, maxNumberOfPointsInPage);
    }

    private void handleEncoding(BlockingQueue<Object> ioTaskQueue, List<List<Integer>> chunkRange, boolean[] timeDuplicateInfo, BitMap allValueColDeletedMap, int maxNumberOfPointsInPage) {
        List<TSDataType> dataTypes = this.list.getTsDataTypes();
        Pair[] lastValidPointIndexForTimeDupCheck = new Pair[dataTypes.size()];
        for (List<Integer> pageRange : chunkRange) {
            AlignedChunkWriterImpl alignedChunkWriter = new AlignedChunkWriterImpl(this.schemaList);
            for (int pageNum = 0; pageNum < pageRange.size() / 2; ++pageNum) {
                int sortedRowIndex;
                for (int columnIndex = 0; columnIndex < dataTypes.size(); ++columnIndex) {
                    if (Objects.nonNull(timeDuplicateInfo) && lastValidPointIndexForTimeDupCheck[columnIndex] == null) {
                        lastValidPointIndexForTimeDupCheck[columnIndex] = new Pair((Object)Long.MIN_VALUE, null);
                    }
                    TSDataType tsDataType = dataTypes.get(columnIndex);
                    block13: for (sortedRowIndex = pageRange.get(pageNum * 2).intValue(); sortedRowIndex <= pageRange.get(pageNum * 2 + 1); ++sortedRowIndex) {
                        if (allValueColDeletedMap != null && allValueColDeletedMap.isMarked(this.list.getValueIndex(sortedRowIndex))) continue;
                        long time = this.list.getTime(sortedRowIndex);
                        if (Objects.nonNull(timeDuplicateInfo)) {
                            if (!this.list.isNullValue(this.list.getValueIndex(sortedRowIndex), columnIndex)) {
                                lastValidPointIndexForTimeDupCheck[columnIndex].left = time;
                                lastValidPointIndexForTimeDupCheck[columnIndex].right = this.list.getValueIndex(sortedRowIndex);
                            }
                            if (timeDuplicateInfo[sortedRowIndex]) continue;
                        }
                        int originRowIndex = Objects.nonNull(lastValidPointIndexForTimeDupCheck[columnIndex]) && time == (Long)lastValidPointIndexForTimeDupCheck[columnIndex].left ? ((Integer)lastValidPointIndexForTimeDupCheck[columnIndex].right).intValue() : this.list.getValueIndex(sortedRowIndex);
                        boolean isNull = this.list.isNullValue(originRowIndex, columnIndex);
                        switch (tsDataType) {
                            case BOOLEAN: {
                                alignedChunkWriter.writeByColumn(time, !isNull && this.list.getBooleanByValueIndex(originRowIndex, columnIndex), isNull);
                                continue block13;
                            }
                            case INT32: 
                            case DATE: {
                                alignedChunkWriter.writeByColumn(time, isNull ? 0 : this.list.getIntByValueIndex(originRowIndex, columnIndex), isNull);
                                continue block13;
                            }
                            case INT64: 
                            case TIMESTAMP: {
                                alignedChunkWriter.writeByColumn(time, isNull ? 0L : this.list.getLongByValueIndex(originRowIndex, columnIndex), isNull);
                                continue block13;
                            }
                            case FLOAT: {
                                alignedChunkWriter.writeByColumn(time, isNull ? 0.0f : this.list.getFloatByValueIndex(originRowIndex, columnIndex), isNull);
                                continue block13;
                            }
                            case DOUBLE: {
                                alignedChunkWriter.writeByColumn(time, isNull ? 0.0 : this.list.getDoubleByValueIndex(originRowIndex, columnIndex), isNull);
                                continue block13;
                            }
                            case TEXT: 
                            case STRING: 
                            case BLOB: {
                                alignedChunkWriter.writeByColumn(time, isNull ? null : this.list.getBinaryByValueIndex(originRowIndex, columnIndex), isNull);
                                continue block13;
                            }
                        }
                    }
                    alignedChunkWriter.nextColumn();
                }
                long[] times = new long[Math.min(maxNumberOfPointsInPage, this.list.rowCount())];
                int pointsInPage = 0;
                for (sortedRowIndex = pageRange.get(pageNum * 2).intValue(); sortedRowIndex <= pageRange.get(pageNum * 2 + 1); ++sortedRowIndex) {
                    if (allValueColDeletedMap != null && allValueColDeletedMap.isMarked(this.list.getValueIndex(sortedRowIndex)) || this.list.isTimeDeleted(sortedRowIndex) || !Objects.isNull(timeDuplicateInfo) && timeDuplicateInfo[sortedRowIndex]) continue;
                    times[pointsInPage++] = this.list.getTime(sortedRowIndex);
                }
                alignedChunkWriter.write(times, pointsInPage, 0);
            }
            alignedChunkWriter.sealCurrentPage();
            alignedChunkWriter.clearPageWriter();
            try {
                ioTaskQueue.put(alignedChunkWriter);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public synchronized void encode(BlockingQueue<Object> ioTaskQueue, BatchEncodeInfo encodeInfo, long[] times) {
        encodeInfo.maxNumberOfPointsInChunk = Math.min(encodeInfo.maxNumberOfPointsInChunk, encodeInfo.targetChunkSize / (long)this.getAvgPointSizeOfLargestColumn());
        if (this.TVLIST_SORT_THRESHOLD == 0) {
            this.encodeWorkingAlignedTVList(ioTaskQueue, encodeInfo.maxNumberOfPointsInChunk, encodeInfo.maxNumberOfPointsInPage);
            return;
        }
        AlignedChunkWriterImpl alignedChunkWriter = new AlignedChunkWriterImpl(this.schemaList);
        ArrayList<AlignedTVList> alignedTvLists = new ArrayList<AlignedTVList>(this.sortedList);
        alignedTvLists.add(this.list);
        List<Integer> columnIndexList = this.buildColumnIndexList(this.schemaList);
        MemPointIterator timeValuePairIterator = MemPointIteratorFactory.create(this.dataTypes, columnIndexList, alignedTvLists, this.ignoreAllNullRows, encodeInfo.maxNumberOfPointsInPage);
        while (timeValuePairIterator.hasNextBatch()) {
            timeValuePairIterator.encodeBatch((IChunkWriter)alignedChunkWriter, encodeInfo, times);
            if (encodeInfo.pointNumInPage >= encodeInfo.maxNumberOfPointsInPage) {
                alignedChunkWriter.write(times, encodeInfo.pointNumInPage, 0);
                encodeInfo.pointNumInPage = 0;
            }
            if ((long)encodeInfo.pointNumInChunk < encodeInfo.maxNumberOfPointsInChunk) continue;
            alignedChunkWriter.sealCurrentPage();
            alignedChunkWriter.clearPageWriter();
            try {
                ioTaskQueue.put(alignedChunkWriter);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            alignedChunkWriter = new AlignedChunkWriterImpl(this.schemaList);
            encodeInfo.reset();
        }
        if (encodeInfo.pointNumInChunk > 0) {
            if (encodeInfo.pointNumInPage > 0) {
                alignedChunkWriter.write(times, encodeInfo.pointNumInPage, 0);
            }
            alignedChunkWriter.sealCurrentPage();
            alignedChunkWriter.clearPageWriter();
            try {
                ioTaskQueue.put(alignedChunkWriter);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            encodeInfo.reset();
        }
    }

    @Override
    public void release() {
        this.maybeReleaseTvList(this.list);
        for (AlignedTVList alignedTvList : this.sortedList) {
            this.maybeReleaseTvList(alignedTvList);
        }
    }

    @Override
    public long getFirstPoint() {
        if (this.rowCount() == 0L) {
            return Long.MAX_VALUE;
        }
        return this.getMinTime();
    }

    @Override
    public long getLastPoint() {
        if (this.rowCount() == 0L) {
            return Long.MIN_VALUE;
        }
        return this.getMaxTime();
    }

    @Override
    public boolean isEmpty() {
        if (this.rowCount() == 0L) {
            return true;
        }
        if (this.ignoreAllNullRows) {
            BitMap allValueColDeletedMap;
            if (this.measurementIndexMap.isEmpty()) {
                return true;
            }
            if (!(this.list.rowCount() <= 0 || (allValueColDeletedMap = this.list.getAllValueColDeletedMap()) != null && allValueColDeletedMap.isAllMarked())) {
                return false;
            }
            for (AlignedTVList alignedTvList : this.sortedList) {
                BitMap allValueColDeletedMap2;
                if (alignedTvList.rowCount() <= 0 || (allValueColDeletedMap2 = alignedTvList.getAllValueColDeletedMap()) != null && allValueColDeletedMap2.isAllMarked()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int serializedSize() {
        int size = 0;
        size += 4;
        for (IMeasurementSchema schema : this.schemaList) {
            size += schema.serializedSize();
        }
        size += 4;
        for (AlignedTVList alignedTvList : this.sortedList) {
            size += alignedTvList.serializedSize();
        }
        return size += this.list.serializedSize();
    }

    @Override
    public void serializeToWAL(IWALByteBufferView buffer) {
        WALWriteUtils.write(this.schemaList.size(), buffer);
        for (IMeasurementSchema schema : this.schemaList) {
            byte[] bytes = new byte[schema.serializedSize()];
            schema.serializeTo(ByteBuffer.wrap(bytes));
            buffer.put(bytes);
        }
        buffer.putInt(this.sortedList.size());
        for (AlignedTVList alignedTvList : this.sortedList) {
            alignedTvList.serializeToWAL(buffer);
        }
        this.list.serializeToWAL(buffer);
    }

    public static AlignedWritableMemChunk deserialize(DataInputStream stream, boolean isTableModel) throws IOException {
        int schemaListSize = stream.readInt();
        ArrayList<IMeasurementSchema> schemaList = new ArrayList<IMeasurementSchema>(schemaListSize);
        for (int i = 0; i < schemaListSize; ++i) {
            MeasurementSchema schema = MeasurementSchema.deserializeFrom((InputStream)stream);
            schemaList.add((IMeasurementSchema)schema);
        }
        int sortedListSize = stream.readInt();
        ArrayList<AlignedTVList> sortedList = new ArrayList<AlignedTVList>();
        for (int i = 0; i < sortedListSize; ++i) {
            AlignedTVList tvList = AlignedTVList.deserialize(stream);
            sortedList.add(tvList);
        }
        AlignedTVList list = AlignedTVList.deserialize(stream);
        AlignedWritableMemChunk chunk = new AlignedWritableMemChunk(schemaList, list, isTableModel);
        chunk.sortedList = sortedList;
        return chunk;
    }

    public static AlignedWritableMemChunk deserializeSingleTVListMemChunks(DataInputStream stream, boolean isTableModel) throws IOException {
        int schemaListSize = stream.readInt();
        ArrayList<IMeasurementSchema> schemaList = new ArrayList<IMeasurementSchema>(schemaListSize);
        for (int i = 0; i < schemaListSize; ++i) {
            MeasurementSchema schema = MeasurementSchema.deserializeFrom((InputStream)stream);
            schemaList.add((IMeasurementSchema)schema);
        }
        AlignedTVList list = AlignedTVList.deserialize(stream);
        return new AlignedWritableMemChunk(schemaList, list, isTableModel);
    }

    public List<IMeasurementSchema> getSchemaList() {
        return this.schemaList;
    }

    public boolean isAllDeleted() {
        if (!this.list.isAllDeleted()) {
            return false;
        }
        for (AlignedTVList alignedTvList : this.sortedList) {
            if (alignedTvList.isAllDeleted()) continue;
            return false;
        }
        return true;
    }

    public List<AlignedTVList> getSortedList() {
        return this.sortedList;
    }

    public List<Integer> buildColumnIndexList(List<IMeasurementSchema> schemaList) {
        ArrayList<Integer> columnIndexList = new ArrayList<Integer>();
        for (IMeasurementSchema measurementSchema : schemaList) {
            columnIndexList.add(this.measurementIndexMap.getOrDefault(measurementSchema.getMeasurementName(), -1));
        }
        return columnIndexList;
    }

    public int getAvgPointSizeOfLargestColumn() {
        int avgPointSizeOfLargestColumn = this.list.getAvgPointSizeOfLargestColumn();
        for (AlignedTVList alignedTVList : this.sortedList) {
            avgPointSizeOfLargestColumn = Math.max(avgPointSizeOfLargestColumn, alignedTVList.getAvgPointSizeOfLargestColumn());
        }
        return avgPointSizeOfLargestColumn;
    }
}

