/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.distribute;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.PlanFragmentId;
import org.apache.iotdb.db.queryengine.execution.exchange.sink.DownStreamChannelLocation;
import org.apache.iotdb.db.queryengine.plan.ClusterTopology;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.planner.distribution.NodeDistribution;
import org.apache.iotdb.db.queryengine.plan.planner.plan.AbstractFragmentParallelPlanner;
import org.apache.iotdb.db.queryengine.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.queryengine.plan.planner.plan.PlanFragment;
import org.apache.iotdb.db.queryengine.plan.planner.plan.SubPlan;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.sink.MultiChildrenSinkNode;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Analysis;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ExchangeNode;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CountDevice;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowDevice;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;
import org.apache.tsfile.utils.Pair;

public class TableModelQueryFragmentPlanner
extends AbstractFragmentParallelPlanner {
    private final SubPlan subPlan;
    private final Analysis analysis;
    private final List<FragmentInstance> fragmentInstanceList = new ArrayList<FragmentInstance>();
    private final MPPQueryContext queryContext;
    private final Map<PlanFragmentId, FragmentInstance> instanceMap = new HashMap<PlanFragmentId, FragmentInstance>();
    private final Map<PlanNodeId, Pair<PlanFragmentId, PlanNode>> planNodeMap = new HashMap<PlanNodeId, Pair<PlanFragmentId, PlanNode>>();
    private final Map<TDataNodeLocation, List<FragmentInstance>> dataNodeFIMap = new HashMap<TDataNodeLocation, List<FragmentInstance>>();
    private final ClusterTopology topology = ClusterTopology.getInstance();
    private final Map<PlanNodeId, NodeDistribution> nodeDistributionMap;

    TableModelQueryFragmentPlanner(SubPlan subPlan, Analysis analysis, MPPQueryContext queryContext, Map<PlanNodeId, NodeDistribution> nodeDistributionMap) {
        super(queryContext);
        this.subPlan = subPlan;
        this.analysis = analysis;
        this.queryContext = queryContext;
        this.nodeDistributionMap = nodeDistributionMap;
    }

    @Override
    public List<FragmentInstance> parallelPlan() {
        this.prepare();
        this.calculateNodeTopologyBetweenInstance();
        return this.fragmentInstanceList;
    }

    private void prepare() {
        for (PlanFragment fragment : this.subPlan.getPlanFragmentList()) {
            this.recordPlanNodeRelation(fragment.getPlanNodeTree(), fragment.getId());
            this.produceFragmentInstance(fragment, this.nodeDistributionMap);
        }
        this.fragmentInstanceList.forEach(fi -> fi.setDataNodeFINum(this.dataNodeFIMap.get(fi.getHostDataNode()).size()));
    }

    private void recordPlanNodeRelation(PlanNode root, PlanFragmentId planFragmentId) {
        this.planNodeMap.put(root.getPlanNodeId(), (Pair<PlanFragmentId, PlanNode>)new Pair((Object)planFragmentId, (Object)root));
        root.getChildren().forEach(child -> this.recordPlanNodeRelation((PlanNode)child, planFragmentId));
    }

    private void calculateNodeTopologyBetweenInstance() {
        for (FragmentInstance instance : this.fragmentInstanceList) {
            PlanNode rootNode = instance.getFragment().getPlanNodeTree();
            if (!(rootNode instanceof MultiChildrenSinkNode)) continue;
            MultiChildrenSinkNode sinkNode = (MultiChildrenSinkNode)rootNode;
            for (DownStreamChannelLocation downStreamChannelLocation : sinkNode.getDownStreamChannelLocationList()) {
                PlanNodeId downStreamNodeId = new PlanNodeId(downStreamChannelLocation.getRemotePlanNodeId());
                FragmentInstance downStreamInstance = this.findDownStreamInstance(this.planNodeMap, this.instanceMap, downStreamNodeId);
                downStreamChannelLocation.setRemoteEndpoint(downStreamInstance.getHostDataNode().getMPPDataExchangeEndPoint());
                downStreamChannelLocation.setRemoteFragmentInstanceId(downStreamInstance.getId().toThrift());
                PlanNode downStreamExchangeNode = (PlanNode)this.planNodeMap.get((Object)downStreamNodeId).right;
                ((ExchangeNode)downStreamExchangeNode).setUpstream(instance.getHostDataNode().getMPPDataExchangeEndPoint(), instance.getId(), sinkNode.getPlanNodeId());
            }
        }
    }

    private void produceFragmentInstance(PlanFragment fragment, Map<PlanNodeId, NodeDistribution> nodeDistributionMap) {
        FragmentInstance fragmentInstance = new FragmentInstance(fragment, fragment.getId().genFragmentInstanceId(), QueryType.READ, this.queryContext.getTimeOut() - (System.currentTimeMillis() - this.queryContext.getStartTime()), this.queryContext.getSession(), this.queryContext.isExplainAnalyze(), fragment.isRoot());
        this.selectExecutorAndHost(fragment, fragmentInstance, () -> fragment.getTargetRegionForTableModel(nodeDistributionMap), this.topology::getValidatedReplicaSet, this.dataNodeFIMap);
        Statement statement = this.analysis.getStatement();
        if (this.analysis.isQuery() || statement instanceof ShowDevice || statement instanceof CountDevice) {
            fragmentInstance.getFragment().generateTableModelTypeProvider(this.queryContext.getTypeProvider());
        }
        this.instanceMap.putIfAbsent(fragment.getId(), fragmentInstance);
        this.fragmentInstanceList.add(fragmentInstance);
    }
}

