/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.plan.planner.LocalExecutionPlanner;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Analysis;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Scope;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Assignments;
import org.apache.iotdb.db.queryengine.plan.relational.planner.PlannerContext;
import org.apache.iotdb.db.queryengine.plan.relational.planner.RelationPlan;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ScopeAware;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SymbolAllocator;
import org.apache.iotdb.db.queryengine.plan.relational.planner.TranslationMap;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ProjectNode;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.type.InternalTypeManager;

public class PlanBuilder {
    private final TranslationMap translations;
    private final PlanNode root;

    public PlanBuilder(TranslationMap translations, PlanNode root) {
        Objects.requireNonNull(translations, "translations is null");
        Objects.requireNonNull(root, "root is null");
        this.translations = translations;
        this.root = root;
    }

    public static PlanBuilder newPlanBuilder(RelationPlan plan, Analysis analysis) {
        return PlanBuilder.newPlanBuilder(plan, analysis, (Map<ScopeAware<Expression>, Symbol>)ImmutableMap.of());
    }

    public static PlanBuilder newPlanBuilder(RelationPlan plan, Analysis analysis, Map<ScopeAware<Expression>, Symbol> mappings) {
        return new PlanBuilder(new TranslationMap(plan.getOuterContext(), plan.getScope(), analysis, plan.getFieldMappings(), mappings, new PlannerContext(LocalExecutionPlanner.getInstance().metadata, new InternalTypeManager())), plan.getRoot());
    }

    public PlanBuilder withNewRoot(PlanNode root) {
        return new PlanBuilder(this.translations, root);
    }

    public PlanBuilder withScope(Scope scope, List<Symbol> fields) {
        return new PlanBuilder(this.translations.withScope(scope, fields), this.root);
    }

    public boolean canTranslate(Expression expression) {
        return this.translations.canTranslate(expression);
    }

    public TranslationMap getTranslations() {
        return this.translations;
    }

    public Scope getScope() {
        return this.translations.getScope();
    }

    public PlanNode getRoot() {
        return this.root;
    }

    public Symbol[] getFieldSymbols() {
        return this.translations.getFieldSymbols();
    }

    public Symbol translate(Expression expression) {
        return Symbol.from(this.translations.rewrite(expression));
    }

    public Expression rewrite(Expression root) {
        Verify.verify((boolean)this.translations.getAnalysis().isAnalyzed(root), (String)"Expression is not analyzed (%s): %s", (Object)root.getClass().getName(), (Object)root);
        return this.translations.rewrite(root);
    }

    public <T extends Expression> PlanBuilder appendProjections(Iterable<T> expressions, SymbolAllocator symbolAllocator, MPPQueryContext queryContext) {
        return this.appendProjections(expressions, symbolAllocator, queryContext, TranslationMap::rewrite, TranslationMap::canTranslate);
    }

    public <T extends Expression> PlanBuilder appendProjections(Iterable<T> expressions, SymbolAllocator symbolAllocator, MPPQueryContext queryContext, BiFunction<TranslationMap, T, Expression> rewriter, BiPredicate<TranslationMap, T> alreadyHasTranslation) {
        Assignments.Builder projections = Assignments.builder();
        projections.putIdentities(this.root.getOutputSymbols());
        Analysis analysis = this.translations.getAnalysis();
        HashMap<ScopeAware<Expression>, Symbol> mappings = new HashMap<ScopeAware<Expression>, Symbol>();
        for (Expression expression : expressions) {
            if (mappings.containsKey(ScopeAware.scopeAwareKey(expression, analysis, this.translations.getScope())) || alreadyHasTranslation.test(this.translations, (TranslationMap)((Object)expression))) continue;
            Symbol symbol = symbolAllocator.newSymbol(expression, analysis.getType(expression));
            projections.put(symbol, rewriter.apply(this.translations, (TranslationMap)((Object)expression)));
            mappings.put(ScopeAware.scopeAwareKey(expression, analysis, this.translations.getScope()), symbol);
        }
        return new PlanBuilder(this.getTranslations().withAdditionalMappings(mappings), new ProjectNode(queryContext.getQueryId().genPlanNodeId(), this.root, projections.build()));
    }
}

