/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.SimplePlanVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.GroupReference;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Lookup;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AggregationNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.FilterNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.JoinNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ProjectNode;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;

public final class ExpressionExtractor {
    public static List<Expression> extractExpressions(PlanNode plan) {
        return ExpressionExtractor.extractExpressions(plan, Lookup.noLookup());
    }

    public static List<Expression> extractExpressions(PlanNode plan, Lookup lookup) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(lookup, "lookup is null");
        ImmutableList.Builder expressionsBuilder = ImmutableList.builder();
        plan.accept(new Visitor(arg_0 -> ((ImmutableList.Builder)expressionsBuilder).add(arg_0), true, lookup), null);
        return expressionsBuilder.build();
    }

    public static List<Expression> extractExpressionsNonRecursive(PlanNode plan) {
        ImmutableList.Builder expressionsBuilder = ImmutableList.builder();
        plan.accept(new Visitor(arg_0 -> ((ImmutableList.Builder)expressionsBuilder).add(arg_0), false, Lookup.noLookup()), null);
        return expressionsBuilder.build();
    }

    public static void forEachExpression(PlanNode plan, Consumer<Expression> expressionConsumer) {
        plan.accept(new Visitor(expressionConsumer, true, Lookup.noLookup()), null);
    }

    private ExpressionExtractor() {
    }

    private static class Visitor
    extends SimplePlanVisitor<Void> {
        private final Consumer<Expression> consumer;
        private final boolean recursive;
        private final Lookup lookup;

        Visitor(Consumer<Expression> consumer, boolean recursive, Lookup lookup) {
            this.consumer = Objects.requireNonNull(consumer, "consumer is null");
            this.recursive = recursive;
            this.lookup = Objects.requireNonNull(lookup, "lookup is null");
        }

        @Override
        public Void visitPlan(PlanNode node, Void context) {
            if (this.recursive) {
                return super.visitPlan(node, context);
            }
            return null;
        }

        @Override
        public Void visitGroupReference(GroupReference node, Void context) {
            return this.lookup.resolve(node).accept(this, context);
        }

        @Override
        public Void visitAggregation(AggregationNode node, Void context) {
            for (AggregationNode.Aggregation aggregation : node.getAggregations().values()) {
                aggregation.getArguments().forEach(this.consumer);
            }
            return (Void)super.visitAggregation(node, context);
        }

        @Override
        public Void visitFilter(FilterNode node, Void context) {
            this.consumer.accept(node.getPredicate());
            return (Void)super.visitFilter(node, context);
        }

        @Override
        public Void visitProject(ProjectNode node, Void context) {
            node.getAssignments().getExpressions().forEach(this.consumer);
            return (Void)super.visitProject(node, context);
        }

        @Override
        public Void visitJoin(JoinNode node, Void context) {
            node.getFilter().ifPresent(this.consumer);
            return (Void)super.visitJoin(node, context);
        }
    }
}

