/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ai;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.IConfigTaskExecutor;

public class CreateTrainingTask
implements IConfigTask {
    private final String modelId;
    private final String modelType;
    private final boolean isTableModel;
    private final Map<String, String> parameters;
    private final boolean useAllData;
    private final List<List<Long>> timeRanges;
    private final String existingModelId;
    private List<String> targetTables;
    private List<String> targetDbs;
    private List<String> targetPaths;

    public CreateTrainingTask(String modelId, String modelType, Map<String, String> parameters, boolean useAllData, List<List<Long>> timeRanges, String existingModelId, List<String> targetTables, List<String> targetDbs) {
        if (!modelType.equalsIgnoreCase("timer_xl")) {
            throw new UnsupportedOperationException("Only TimerXL model is supported now.");
        }
        this.modelId = modelId;
        this.modelType = modelType;
        this.parameters = parameters;
        this.useAllData = useAllData;
        this.timeRanges = timeRanges;
        this.existingModelId = existingModelId;
        this.isTableModel = true;
        this.targetTables = targetTables;
        this.targetDbs = targetDbs;
    }

    public CreateTrainingTask(String modelId, String modelType, Map<String, String> parameters, boolean useAllData, List<List<Long>> timeRanges, String existingModelId, List<String> targetPaths) {
        if (!modelType.equalsIgnoreCase("timer_xl")) {
            throw new UnsupportedOperationException("Only TimerXL model is supported now.");
        }
        this.modelId = modelId;
        this.modelType = modelType;
        this.parameters = parameters;
        this.useAllData = useAllData;
        this.timeRanges = timeRanges;
        this.existingModelId = existingModelId;
        this.isTableModel = false;
        this.targetPaths = targetPaths;
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.createTraining(this.modelId, this.modelType, this.isTableModel, this.parameters, this.useAllData, this.timeRanges, this.existingModelId, this.targetTables, this.targetDbs, this.targetPaths);
    }
}

