/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.load.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.sql.SemanticException;

public class LoadTsFileConfigurator {
    public static final String DATABASE_LEVEL_KEY = "database-level";
    private static final int DATABASE_LEVEL_DEFAULT_VALUE = IoTDBDescriptor.getInstance().getConfig().getDefaultStorageGroupLevel();
    private static final int DATABASE_LEVEL_MIN_VALUE = 1;
    public static final String DATABASE_NAME_KEY = "database-name";
    public static final String ON_SUCCESS_KEY = "on-success";
    public static final String ON_SUCCESS_DELETE_VALUE = "delete";
    public static final String ON_SUCCESS_NONE_VALUE = "none";
    private static final Set<String> ON_SUCCESS_VALUE_SET = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("delete", "none")));
    public static final String CONVERT_ON_TYPE_MISMATCH_KEY = "convert-on-type-mismatch";
    private static final boolean CONVERT_ON_TYPE_MISMATCH_DEFAULT_VALUE = true;
    public static final String TABLET_CONVERSION_THRESHOLD_KEY = "tablet-conversion-threshold";
    public static final String VERIFY_KEY = "verify";
    private static final boolean VERIFY_DEFAULT_VALUE = true;
    public static final String ASYNC_LOAD_KEY = "async";
    private static final boolean ASYNC_LOAD_DEFAULT_VALUE = false;

    public static void validateParameters(String key, String value) {
        switch (key) {
            case "database-level": {
                LoadTsFileConfigurator.validateDatabaseLevelParam(value);
                break;
            }
            case "on-success": {
                LoadTsFileConfigurator.validateOnSuccessParam(value);
                break;
            }
            case "database-name": 
            case "tablet-conversion-threshold": {
                break;
            }
            case "convert-on-type-mismatch": {
                LoadTsFileConfigurator.validateConvertOnTypeMismatchParam(value);
                break;
            }
            case "verify": {
                LoadTsFileConfigurator.validateVerifyParam(value);
                break;
            }
            case "async": {
                LoadTsFileConfigurator.validateAsyncLoadParam(value);
                break;
            }
            default: {
                throw new SemanticException("Invalid parameter '" + key + "' for LOAD TSFILE command.");
            }
        }
    }

    public static void validateDatabaseLevelParam(String databaseLevel) {
        try {
            int level = Integer.parseInt(databaseLevel);
            if (level < 1) {
                throw new SemanticException(String.format("Given database level %d is less than the minimum value %d, please input a valid database level.", level, 1));
            }
        }
        catch (Exception e) {
            throw new SemanticException(String.format("Given database level %s is not a valid integer, please input a valid database level.", databaseLevel));
        }
    }

    public static int parseOrGetDefaultDatabaseLevel(Map<String, String> loadAttributes) {
        return Integer.parseInt(loadAttributes.getOrDefault(DATABASE_LEVEL_KEY, String.valueOf(DATABASE_LEVEL_DEFAULT_VALUE)));
    }

    @Nullable
    public static String parseDatabaseName(Map<String, String> loadAttributes) {
        String databaseName = loadAttributes.get(DATABASE_NAME_KEY);
        return Objects.nonNull(databaseName) ? databaseName.toLowerCase(Locale.ENGLISH) : null;
    }

    public static void validateOnSuccessParam(String onSuccess) {
        if (!ON_SUCCESS_VALUE_SET.contains(onSuccess)) {
            throw new SemanticException(String.format("Given on-success value '%s' is not supported, please input a valid on-success value.", onSuccess));
        }
    }

    public static boolean parseOrGetDefaultOnSuccess(Map<String, String> loadAttributes) {
        String value = loadAttributes.get(ON_SUCCESS_KEY);
        return !StringUtils.isEmpty((CharSequence)value) && ON_SUCCESS_DELETE_VALUE.equalsIgnoreCase(value);
    }

    public static void validateConvertOnTypeMismatchParam(String convertOnTypeMismatch) {
        if (!"true".equalsIgnoreCase(convertOnTypeMismatch) && !"false".equalsIgnoreCase(convertOnTypeMismatch)) {
            throw new SemanticException(String.format("Given %s value '%s' is not supported, please input a valid boolean value.", CONVERT_ON_TYPE_MISMATCH_KEY, convertOnTypeMismatch));
        }
    }

    public static boolean parseOrGetDefaultConvertOnTypeMismatch(Map<String, String> loadAttributes) {
        return Boolean.parseBoolean(loadAttributes.getOrDefault(CONVERT_ON_TYPE_MISMATCH_KEY, String.valueOf(true)));
    }

    public static long parseOrGetDefaultTabletConversionThresholdBytes(Map<String, String> loadAttributes) {
        return Long.parseLong(loadAttributes.getOrDefault(TABLET_CONVERSION_THRESHOLD_KEY, String.valueOf(IoTDBDescriptor.getInstance().getConfig().getLoadTabletConversionThresholdBytes())));
    }

    public static void validateVerifyParam(String verify) {
        if (!"true".equalsIgnoreCase(verify) && !"false".equalsIgnoreCase(verify)) {
            throw new SemanticException(String.format("Given %s value '%s' is not supported, please input a valid boolean value.", VERIFY_KEY, verify));
        }
    }

    public static boolean parseOrGetDefaultVerify(Map<String, String> loadAttributes) {
        return Boolean.parseBoolean(loadAttributes.getOrDefault(VERIFY_KEY, String.valueOf(true)));
    }

    public static void validateAsyncLoadParam(String asyncLoad) {
        if (!"true".equalsIgnoreCase(asyncLoad) && !"false".equalsIgnoreCase(asyncLoad)) {
            throw new SemanticException(String.format("Given %s value '%s' is not supported, please input a valid boolean value.", ASYNC_LOAD_KEY, asyncLoad));
        }
    }

    public static boolean parseOrGetDefaultAsyncLoad(Map<String, String> loadAttributes) {
        return Boolean.parseBoolean(loadAttributes.getOrDefault(ASYNC_LOAD_KEY, String.valueOf(false)));
    }

    private LoadTsFileConfigurator() {
        throw new IllegalStateException("Utility class");
    }
}

