/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.metrics.memory;

import java.util.Arrays;
import org.apache.iotdb.commons.memory.MemoryManager;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.conf.DataNodeMemoryConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.service.metrics.memory.GlobalMemoryMetrics;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class StorageEngineMemoryMetrics
implements IMetricSet {
    private static final DataNodeMemoryConfig memoryConfig = IoTDBDescriptor.getInstance().getMemoryConfig();
    private static final String STORAGE_ENGINE = "StorageEngine";
    private static final String STORAGE_ENGINE_WRITE = "StorageEngine-Write";
    private static final String STORAGE_ENGINE_WRITE_MEMTABLE = "StorageEngine-Write-Memtable";
    private static final String STORAGE_ENGINE_WRITE_MEMTABLE_DEVICE_PATH_CACHE = "StorageEngine-Write-Memtable-DevicePathCache";
    private static final String STORAGE_ENGINE_WRITE_MEMTABLE_BUFFERED_ARRAYS = "StorageEngine-Write-Memtable-BufferedArrays";
    private static final String STORAGE_ENGINE_WRITE_MEMTABLE_WAL_BUFFER_QUEUE = "StorageEngine-Write-Memtable-WalBufferQueue";
    private static final String STORAGE_ENGINE_WRITE_TIME_PARTITION_INFO = "StorageEngine-Write-TimePartitionInfo";
    private static final String STORAGE_ENGINE_COMPACTION = "StorageEngine-Compaction";

    public void bindTo(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.MEMORY_THRESHOLD_SIZE.toString(), MetricLevel.IMPORTANT, (Object)memoryConfig.getStorageEngineMemoryManager(), MemoryManager::getTotalMemorySizeInBytes, new String[]{Tag.NAME.toString(), STORAGE_ENGINE, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[1]});
        this.bindStorageEngineDividedMetrics(metricService);
        this.bindWriteDividedMetrics(metricService);
        this.bindMemtableDividedMetrics(metricService);
    }

    public void unbindFrom(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.MEMORY_THRESHOLD_SIZE.toString(), new String[]{Tag.NAME.toString(), STORAGE_ENGINE, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[1]});
        this.unbindStorageEngineDividedMetrics(metricService);
        this.unbindWriteDividedMetric(metricService);
        this.unbindMemtableDividedMetrics(metricService);
    }

    private void bindStorageEngineDividedMetrics(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.MEMORY_THRESHOLD_SIZE.toString(), MetricLevel.IMPORTANT, (Object)memoryConfig.getWriteMemoryManager(), MemoryManager::getTotalMemorySizeInBytes, new String[]{Tag.NAME.toString(), STORAGE_ENGINE_WRITE, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[2]});
        metricService.createAutoGauge(Metric.MEMORY_THRESHOLD_SIZE.toString(), MetricLevel.IMPORTANT, (Object)memoryConfig.getCompactionMemoryManager(), MemoryManager::getTotalMemorySizeInBytes, new String[]{Tag.NAME.toString(), STORAGE_ENGINE_COMPACTION, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[2]});
        metricService.createAutoGauge(Metric.MEMORY_ACTUAL_SIZE.toString(), MetricLevel.IMPORTANT, (Object)memoryConfig.getCompactionMemoryManager(), MemoryManager::getUsedMemorySizeInBytes, new String[]{Tag.NAME.toString(), STORAGE_ENGINE_COMPACTION, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[2]});
    }

    private void unbindStorageEngineDividedMetrics(AbstractMetricService metricService) {
        Arrays.asList(STORAGE_ENGINE_WRITE, STORAGE_ENGINE_COMPACTION).forEach(name -> {
            metricService.remove(MetricType.AUTO_GAUGE, Metric.MEMORY_THRESHOLD_SIZE.toString(), new String[]{Tag.NAME.toString(), name, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[2]});
            metricService.remove(MetricType.AUTO_GAUGE, Metric.MEMORY_ACTUAL_SIZE.toString(), new String[]{Tag.NAME.toString(), name, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[2]});
        });
    }

    private void bindWriteDividedMetrics(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.MEMORY_THRESHOLD_SIZE.toString(), MetricLevel.IMPORTANT, (Object)memoryConfig.getMemtableMemoryManager(), MemoryManager::getTotalMemorySizeInBytes, new String[]{Tag.NAME.toString(), STORAGE_ENGINE_WRITE_MEMTABLE, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[3]});
        metricService.createAutoGauge(Metric.MEMORY_THRESHOLD_SIZE.toString(), MetricLevel.IMPORTANT, (Object)memoryConfig.getTimePartitionInfoMemoryManager(), MemoryManager::getTotalMemorySizeInBytes, new String[]{Tag.NAME.toString(), STORAGE_ENGINE_WRITE_TIME_PARTITION_INFO, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[3]});
        metricService.createAutoGauge(Metric.MEMORY_ACTUAL_SIZE.toString(), MetricLevel.IMPORTANT, (Object)memoryConfig.getTimePartitionInfoMemoryManager(), MemoryManager::getUsedMemorySizeInBytes, new String[]{Tag.NAME.toString(), STORAGE_ENGINE_WRITE_TIME_PARTITION_INFO, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[3]});
    }

    private void unbindWriteDividedMetric(AbstractMetricService metricService) {
        Arrays.asList(STORAGE_ENGINE_WRITE_MEMTABLE, STORAGE_ENGINE_WRITE_TIME_PARTITION_INFO).forEach(name -> metricService.remove(MetricType.AUTO_GAUGE, Metric.MEMORY_THRESHOLD_SIZE.toString(), new String[]{Tag.NAME.toString(), name, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[3]}));
    }

    private void bindMemtableDividedMetrics(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.MEMORY_THRESHOLD_SIZE.toString(), MetricLevel.IMPORTANT, (Object)memoryConfig.getDevicePathCacheMemoryManager(), MemoryManager::getTotalMemorySizeInBytes, new String[]{Tag.NAME.toString(), STORAGE_ENGINE_WRITE_MEMTABLE_DEVICE_PATH_CACHE, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[4]});
        metricService.createAutoGauge(Metric.MEMORY_ACTUAL_SIZE.toString(), MetricLevel.IMPORTANT, (Object)memoryConfig.getDevicePathCacheMemoryManager(), MemoryManager::getUsedMemorySizeInBytes, new String[]{Tag.NAME.toString(), STORAGE_ENGINE_WRITE_MEMTABLE_DEVICE_PATH_CACHE, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[4]});
        metricService.createAutoGauge(Metric.MEMORY_THRESHOLD_SIZE.toString(), MetricLevel.IMPORTANT, (Object)memoryConfig.getBufferedArraysMemoryManager(), MemoryManager::getTotalMemorySizeInBytes, new String[]{Tag.NAME.toString(), STORAGE_ENGINE_WRITE_MEMTABLE_BUFFERED_ARRAYS, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[4]});
        metricService.createAutoGauge(Metric.MEMORY_ACTUAL_SIZE.toString(), MetricLevel.IMPORTANT, (Object)memoryConfig.getBufferedArraysMemoryManager(), MemoryManager::getUsedMemorySizeInBytes, new String[]{Tag.NAME.toString(), STORAGE_ENGINE_WRITE_MEMTABLE_BUFFERED_ARRAYS, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[4]});
        metricService.createAutoGauge(Metric.MEMORY_THRESHOLD_SIZE.toString(), MetricLevel.IMPORTANT, (Object)memoryConfig.getWalBufferQueueMemoryManager(), MemoryManager::getTotalMemorySizeInBytes, new String[]{Tag.NAME.toString(), STORAGE_ENGINE_WRITE_MEMTABLE_WAL_BUFFER_QUEUE, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[4]});
        metricService.createAutoGauge(Metric.MEMORY_ACTUAL_SIZE.toString(), MetricLevel.IMPORTANT, (Object)memoryConfig.getWalBufferQueueMemoryManager(), MemoryManager::getUsedMemorySizeInBytes, new String[]{Tag.NAME.toString(), STORAGE_ENGINE_WRITE_MEMTABLE_WAL_BUFFER_QUEUE, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[4]});
    }

    private void unbindMemtableDividedMetrics(AbstractMetricService metricService) {
        Arrays.asList(STORAGE_ENGINE_WRITE_MEMTABLE_DEVICE_PATH_CACHE, STORAGE_ENGINE_WRITE_MEMTABLE_BUFFERED_ARRAYS, STORAGE_ENGINE_WRITE_MEMTABLE_WAL_BUFFER_QUEUE).forEach(name -> {
            metricService.remove(MetricType.AUTO_GAUGE, Metric.MEMORY_THRESHOLD_SIZE.toString(), new String[]{Tag.NAME.toString(), name, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[4]});
            metricService.remove(MetricType.AUTO_GAUGE, Metric.MEMORY_ACTUAL_SIZE.toString(), new String[]{Tag.NAME.toString(), name, Tag.TYPE.toString(), "OnHeap", Tag.LEVEL.toString(), GlobalMemoryMetrics.LEVELS[4]});
        });
    }

    public static StorageEngineMemoryMetrics getInstance() {
        return StorageEngineMemoryMetricsHolder.INSTANCE;
    }

    private static class StorageEngineMemoryMetricsHolder {
        private static final StorageEngineMemoryMetrics INSTANCE = new StorageEngineMemoryMetrics();

        private StorageEngineMemoryMetricsHolder() {
        }
    }
}

