/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.utils.ModificationUtils;
import org.apache.iotdb.db.utils.datastructure.AlignedTVList;
import org.apache.iotdb.db.utils.datastructure.MultiAlignedTVListIterator;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.utils.BitMap;

public class OrderedMultiAlignedTVListIterator
extends MultiAlignedTVListIterator {
    private final BitMap bitMap = new BitMap(this.tsDataTypeList.size());
    private final List<int[]> valueColumnDeleteCursor = new ArrayList<int[]>();
    private int iteratorIndex = 0;
    private int[] rowIndices;

    public OrderedMultiAlignedTVListIterator(List<TSDataType> tsDataTypes, List<Integer> columnIndexList, List<AlignedTVList> alignedTvLists, List<TimeRange> timeColumnDeletion, List<List<TimeRange>> valueColumnsDeletionList, Integer floatPrecision, List<TSEncoding> encodingList, boolean ignoreAllNullRows) {
        super(tsDataTypes, columnIndexList, alignedTvLists, timeColumnDeletion, valueColumnsDeletionList, floatPrecision, encodingList, ignoreAllNullRows);
        for (int i = 0; i < this.tsDataTypeList.size(); ++i) {
            this.valueColumnDeleteCursor.add(new int[]{0});
        }
        this.ignoreAllNullRows = ignoreAllNullRows;
    }

    @Override
    protected void prepareNext() {
        this.hasNext = false;
        while (this.iteratorIndex < this.alignedTvListIterators.size() && !this.hasNext) {
            AlignedTVList.AlignedTVListIterator iterator = (AlignedTVList.AlignedTVListIterator)this.alignedTvListIterators.get(this.iteratorIndex);
            if (!iterator.hasNextTimeValuePair()) {
                ++this.iteratorIndex;
                continue;
            }
            this.bitMap.reset();
            this.rowIndices = iterator.getSelectedIndices();
            this.currentTime = iterator.currentTime();
            this.hasNext = true;
            for (int columnIndex = 0; columnIndex < this.tsDataTypeList.size(); ++columnIndex) {
                if ((this.valueColumnsDeletionList == null || !ModificationUtils.isPointDeleted(this.currentTime, (List)this.valueColumnsDeletionList.get(columnIndex), this.valueColumnDeleteCursor.get(columnIndex))) && !iterator.isNullValue(this.rowIndices[columnIndex], columnIndex)) continue;
                this.bitMap.mark(columnIndex);
            }
            if (!this.ignoreAllNullRows || !this.bitMap.isAllMarked()) continue;
            iterator.next();
            this.hasNext = false;
        }
        this.probeNext = true;
    }

    @Override
    protected void next() {
        TVList.TVListIterator iterator = (TVList.TVListIterator)this.alignedTvListIterators.get(this.iteratorIndex);
        iterator.next();
        this.rowIndices = null;
        this.probeNext = false;
    }

    @Override
    protected int currentIteratorIndex(int columnIndex) {
        return this.iteratorIndex;
    }

    @Override
    protected int currentRowIndex(int columnIndex) {
        return this.rowIndices[columnIndex];
    }
}

