/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.metadata;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.table.TableNotExistsException;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.commons.partition.DataPartitionQueryParam;
import org.apache.iotdb.commons.partition.SchemaPartition;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.udf.builtin.relational.TableBuiltinAggregationFunction;
import org.apache.iotdb.commons.udf.builtin.relational.TableBuiltinScalarFunction;
import org.apache.iotdb.commons.udf.builtin.relational.TableBuiltinTableFunction;
import org.apache.iotdb.commons.udf.utils.TableUDFUtils;
import org.apache.iotdb.commons.udf.utils.UDFDataTypeTransformer;
import org.apache.iotdb.db.exception.load.LoadAnalyzeTableColumnDisorderException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.plan.analyze.ClusterPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.relational.function.OperatorType;
import org.apache.iotdb.db.queryengine.plan.relational.function.arithmetic.AdditionResolver;
import org.apache.iotdb.db.queryengine.plan.relational.function.arithmetic.DivisionResolver;
import org.apache.iotdb.db.queryengine.plan.relational.function.arithmetic.ModulusResolver;
import org.apache.iotdb.db.queryengine.plan.relational.function.arithmetic.MultiplicationResolver;
import org.apache.iotdb.db.queryengine.plan.relational.function.arithmetic.SubtractionResolver;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ColumnSchema;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.DeviceEntry;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ITableDeviceSchemaValidation;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.Metadata;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.OperatorNotFoundException;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.QualifiedObjectName;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.TableSchema;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.TableDeviceSchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.TableDeviceSchemaValidator;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.TableHeaderSchemaValidator;
import org.apache.iotdb.db.queryengine.plan.relational.security.AccessControl;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.type.InternalTypeManager;
import org.apache.iotdb.db.queryengine.plan.relational.type.TypeManager;
import org.apache.iotdb.db.queryengine.plan.relational.type.TypeNotFoundException;
import org.apache.iotdb.db.queryengine.plan.relational.type.TypeSignature;
import org.apache.iotdb.db.schemaengine.table.DataNodeTableCache;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.udf.api.customizer.analysis.AggregateFunctionAnalysis;
import org.apache.iotdb.udf.api.customizer.analysis.ScalarFunctionAnalysis;
import org.apache.iotdb.udf.api.customizer.parameter.FunctionArguments;
import org.apache.iotdb.udf.api.relational.AggregateFunction;
import org.apache.iotdb.udf.api.relational.ScalarFunction;
import org.apache.iotdb.udf.api.relational.TableFunction;
import org.apache.iotdb.udf.api.type.Type;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.common.type.BinaryType;
import org.apache.tsfile.read.common.type.BlobType;
import org.apache.tsfile.read.common.type.BooleanType;
import org.apache.tsfile.read.common.type.DateType;
import org.apache.tsfile.read.common.type.DoubleType;
import org.apache.tsfile.read.common.type.FloatType;
import org.apache.tsfile.read.common.type.IntType;
import org.apache.tsfile.read.common.type.LongType;
import org.apache.tsfile.read.common.type.StringType;
import org.apache.tsfile.read.common.type.TimestampType;
import org.apache.tsfile.read.common.type.TypeFactory;
import org.apache.tsfile.read.common.type.UnknownType;

public class TableMetadataImpl
implements Metadata {
    private final TypeManager typeManager = new InternalTypeManager();
    private final IPartitionFetcher partitionFetcher = ClusterPartitionFetcher.getInstance();
    private final DataNodeTableCache tableCache = DataNodeTableCache.getInstance();

    @Override
    public boolean tableExists(QualifiedObjectName name) {
        return this.tableCache.getTable(name.getDatabaseName(), name.getObjectName()) != null;
    }

    @Override
    public Optional<TableSchema> getTableSchema(SessionInfo session, QualifiedObjectName name) {
        TsTable table = this.tableCache.getTable(name.getDatabaseName(), name.getObjectName());
        return Objects.isNull(table) ? Optional.empty() : Optional.of(new TableSchema(table.getTableName(), table.getColumnList().stream().map(o -> new ColumnSchema(o.getColumnName(), TypeFactory.getType((TSDataType)o.getDataType()), false, o.getColumnCategory())).collect(Collectors.toList())));
    }

    @Override
    public org.apache.tsfile.read.common.type.Type getOperatorReturnType(OperatorType operatorType, List<? extends org.apache.tsfile.read.common.type.Type> argumentTypes) throws OperatorNotFoundException {
        switch (operatorType) {
            case ADD: {
                if (!TableMetadataImpl.isTwoTypeCalculable(argumentTypes) || !AdditionResolver.checkConditions(argumentTypes).isPresent()) {
                    throw new OperatorNotFoundException(operatorType, argumentTypes, new IllegalArgumentException("Should have two numeric operands."));
                }
                return AdditionResolver.checkConditions(argumentTypes).get();
            }
            case SUBTRACT: {
                if (!TableMetadataImpl.isTwoTypeCalculable(argumentTypes) || !SubtractionResolver.checkConditions(argumentTypes).isPresent()) {
                    throw new OperatorNotFoundException(operatorType, argumentTypes, new IllegalArgumentException("Should have two numeric operands."));
                }
                return SubtractionResolver.checkConditions(argumentTypes).get();
            }
            case MULTIPLY: {
                if (!TableMetadataImpl.isTwoTypeCalculable(argumentTypes) || !MultiplicationResolver.checkConditions(argumentTypes).isPresent()) {
                    throw new OperatorNotFoundException(operatorType, argumentTypes, new IllegalArgumentException("Should have two numeric operands."));
                }
                return MultiplicationResolver.checkConditions(argumentTypes).get();
            }
            case DIVIDE: {
                if (!TableMetadataImpl.isTwoTypeCalculable(argumentTypes) || !DivisionResolver.checkConditions(argumentTypes).isPresent()) {
                    throw new OperatorNotFoundException(operatorType, argumentTypes, new IllegalArgumentException("Should have two numeric operands."));
                }
                return DivisionResolver.checkConditions(argumentTypes).get();
            }
            case MODULUS: {
                if (!TableMetadataImpl.isTwoTypeCalculable(argumentTypes) || !ModulusResolver.checkConditions(argumentTypes).isPresent()) {
                    throw new OperatorNotFoundException(operatorType, argumentTypes, new IllegalArgumentException("Should have two numeric operands."));
                }
                return ModulusResolver.checkConditions(argumentTypes).get();
            }
            case NEGATION: {
                if (!TableMetadataImpl.isOneNumericType(argumentTypes) && !TableMetadataImpl.isTimestampType(argumentTypes.get(0))) {
                    throw new OperatorNotFoundException(operatorType, argumentTypes, new IllegalArgumentException("Should have one numeric operands."));
                }
                return argumentTypes.get(0);
            }
            case EQUAL: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                if (!TableMetadataImpl.isTwoTypeComparable(argumentTypes)) {
                    throw new OperatorNotFoundException(operatorType, argumentTypes, new IllegalArgumentException("Should have two comparable operands."));
                }
                return BooleanType.BOOLEAN;
            }
        }
        throw new OperatorNotFoundException(operatorType, argumentTypes, new UnsupportedOperationException());
    }

    @Override
    public org.apache.tsfile.read.common.type.Type getFunctionReturnType(String functionName, List<? extends org.apache.tsfile.read.common.type.Type> argumentTypes) {
        return TableMetadataImpl.getFunctionType(functionName, argumentTypes);
    }

    public static org.apache.tsfile.read.common.type.Type getFunctionType(String functionName, List<? extends org.apache.tsfile.read.common.type.Type> argumentTypes) {
        if (TableBuiltinScalarFunction.DIFF.getFunctionName().equalsIgnoreCase(functionName)) {
            if (!(TableMetadataImpl.isOneNumericType(argumentTypes) || argumentTypes.size() == 2 && TableMetadataImpl.isNumericType(argumentTypes.get(0)) && BooleanType.BOOLEAN.equals(argumentTypes.get(1)))) {
                throw new SemanticException("Scalar function " + functionName.toLowerCase(Locale.ENGLISH) + " only supports one numeric data types [INT32, INT64, FLOAT, DOUBLE] and one boolean");
            }
            return DoubleType.DOUBLE;
        }
        if (TableBuiltinScalarFunction.ROUND.getFunctionName().equalsIgnoreCase(functionName)) {
            if (!TableMetadataImpl.isOneSupportedMathNumericType(argumentTypes) && !TableMetadataImpl.isTwoSupportedMathNumericType(argumentTypes)) {
                throw new SemanticException("Scalar function " + functionName.toLowerCase(Locale.ENGLISH) + " only supports two numeric data types [INT32, INT64, FLOAT, DOUBLE]");
            }
            return DoubleType.DOUBLE;
        }
        if (TableBuiltinScalarFunction.REPLACE.getFunctionName().equalsIgnoreCase(functionName)) {
            if (!TableMetadataImpl.isTwoCharType(argumentTypes) && !TableMetadataImpl.isThreeCharType(argumentTypes)) {
                throw new SemanticException("Scalar function " + functionName.toLowerCase(Locale.ENGLISH) + " only accepts two or three arguments and they must be text or string data type.");
            }
            return StringType.STRING;
        }
        if (TableBuiltinScalarFunction.SUBSTRING.getFunctionName().equalsIgnoreCase(functionName)) {
            if (!(argumentTypes.size() == 2 && TableMetadataImpl.isCharType(argumentTypes.get(0)) && TableMetadataImpl.isIntegerNumber(argumentTypes.get(1)) || argumentTypes.size() == 3 && TableMetadataImpl.isCharType(argumentTypes.get(0)) && TableMetadataImpl.isIntegerNumber(argumentTypes.get(1)) && TableMetadataImpl.isIntegerNumber(argumentTypes.get(2)))) {
                throw new SemanticException("Scalar function " + functionName.toLowerCase(Locale.ENGLISH) + " only accepts two or three arguments and first must be text or string data type, second and third must be numeric data types [INT32, INT64]");
            }
            return StringType.STRING;
        }
        if (TableBuiltinScalarFunction.LENGTH.getFunctionName().equalsIgnoreCase(functionName)) {
            if (argumentTypes.size() != 1 || !TableMetadataImpl.isCharType(argumentTypes.get(0))) {
                throw new SemanticException("Scalar function " + functionName.toLowerCase(Locale.ENGLISH) + " only accepts one argument and it must be text or string data type.");
            }
            return IntType.INT32;
        }
        if (TableBuiltinScalarFunction.UPPER.getFunctionName().equalsIgnoreCase(functionName)) {
            if (argumentTypes.size() != 1 || !TableMetadataImpl.isCharType(argumentTypes.get(0))) {
                throw new SemanticException("Scalar function " + functionName.toLowerCase(Locale.ENGLISH) + " only accepts one argument and it must be text or string data type.");
            }
            return StringType.STRING;
        }
        if (TableBuiltinScalarFunction.LOWER.getFunctionName().equalsIgnoreCase(functionName)) {
            if (argumentTypes.size() != 1 || !TableMetadataImpl.isCharType(argumentTypes.get(0))) {
                throw new SemanticException("Scalar function " + functionName.toLowerCase(Locale.ENGLISH) + " only accepts one argument and it must be text or string data type.");
            }
            return StringType.STRING;
        }
        if (TableBuiltinScalarFunction.TRIM.getFunctionName().equalsIgnoreCase(functionName)) {
            if (!(argumentTypes.size() == 1 && TableMetadataImpl.isCharType(argumentTypes.get(0)) || argumentTypes.size() == 2 && TableMetadataImpl.isTwoCharType(argumentTypes))) {
                throw new SemanticException("Scalar function " + functionName.toLowerCase(Locale.ENGLISH) + " only accepts one or two arguments and they must be text or string data type.");
            }
            return StringType.STRING;
        }
        if (TableBuiltinScalarFunction.LTRIM.getFunctionName().equalsIgnoreCase(functionName)) {
            if (!(argumentTypes.size() == 1 && TableMetadataImpl.isCharType(argumentTypes.get(0)) || argumentTypes.size() == 2 && TableMetadataImpl.isTwoCharType(argumentTypes))) {
                throw new SemanticException("Scalar function " + functionName.toLowerCase(Locale.ENGLISH) + " only accepts one or two arguments and they must be text or string data type.");
            }
            return StringType.STRING;
        }
        if (TableBuiltinScalarFunction.RTRIM.getFunctionName().equalsIgnoreCase(functionName)) {
            if (!(argumentTypes.size() == 1 && TableMetadataImpl.isCharType(argumentTypes.get(0)) || argumentTypes.size() == 2 && TableMetadataImpl.isTwoCharType(argumentTypes))) {
                throw new SemanticException("Scalar function " + functionName.toLowerCase(Locale.ENGLISH) + " only accepts one or two arguments and they must be text or string data type.");
            }
            return StringType.STRING;
        }
        if (TableBuiltinScalarFunction.REGEXP_LIKE.getFunctionName().equalsIgnoreCase(functionName)) {
            if (!TableMetadataImpl.isTwoCharType(argumentTypes)) {
                throw new SemanticException("Scalar function " + functionName.toLowerCase(Locale.ENGLISH) + " only accepts two arguments and they must be text or string data type.");
            }
            return BooleanType.BOOLEAN;
        }
        if (TableBuiltinScalarFunction.STRPOS.getFunctionName().equalsIgnoreCase(functionName)) {
            if (!TableMetadataImpl.isTwoCharType(argumentTypes)) {
                throw new SemanticException("Scalar function " + functionName.toLowerCase(Locale.ENGLISH) + " only accepts two arguments and they must be text or string data type.");
            }
            return IntType.INT32;
        }
        if (TableBuiltinScalarFunction.STARTS_WITH.getFunctionName().equalsIgnoreCase(functionName)) {
            if (!TableMetadataImpl.isTwoCharType(argumentTypes)) {
                throw new SemanticException("Scalar function " + functionName.toLowerCase(Locale.ENGLISH) + " only accepts two arguments and they must be text or string data type.");
            }
            return BooleanType.BOOLEAN;
        }
        if (TableBuiltinScalarFunction.ENDS_WITH.getFunctionName().equalsIgnoreCase(functionName)) {
            if (!TableMetadataImpl.isTwoCharType(argumentTypes)) {
                throw new SemanticException("Scalar function " + functionName.toLowerCase(Locale.ENGLISH) + " only accepts two arguments and they must be text or string data type.");
            }
            return BooleanType.BOOLEAN;
        }
        if (TableBuiltinScalarFunction.CONCAT.getFunctionName().equalsIgnoreCase(functionName)) {
            if (argumentTypes.size() < 2 || !argumentTypes.stream().allMatch(TableMetadataImpl::isCharType)) {
                throw new SemanticException("Scalar function " + functionName.toLowerCase(Locale.ENGLISH) + " only accepts two or more arguments and they must be text or string data type.");
            }
            return StringType.STRING;
        }
        if (TableBuiltinScalarFunction.STRCMP.getFunctionName().equalsIgnoreCase(functionName)) {
            if (!TableMetadataImpl.isTwoCharType(argumentTypes)) {
                throw new SemanticException("Scalar function " + functionName.toLowerCase(Locale.ENGLISH) + " only accepts two arguments and they must be text or string data type.");
            }
            return IntType.INT32;
        }
        if (TableBuiltinScalarFunction.SIN.getFunctionName().equalsIgnoreCase(functionName)) {
            if (argumentTypes.size() != 1 || !TableMetadataImpl.isSupportedMathNumericType(argumentTypes.get(0))) {
                throw new SemanticException("Scalar function " + functionName.toLowerCase(Locale.ENGLISH) + " only accepts one argument and it must be Double, Float, Int32 or Int64 data type.");
            }
            return DoubleType.DOUBLE;
        }
        if (TableBuiltinScalarFunction.COS.getFunctionName().equalsIgnoreCase(functionName)) {
            if (argumentTypes.size() != 1 || !TableMetadataImpl.isSupportedMathNumericType(argumentTypes.get(0))) {
                throw new SemanticException("Scalar function " + functionName.toLowerCase(Locale.ENGLISH) + " only accepts one argument and it must be Double, Float, Int32 or Int64 data type.");
            }
            return DoubleType.DOUBLE;
        }
        if (TableBuiltinScalarFunction.TAN.getFunctionName().equalsIgnoreCase(functionName)) {
            if (argumentTypes.size() != 1 || !TableMetadataImpl.isSupportedMathNumericType(argumentTypes.get(0))) {
                throw new SemanticException("Scalar function " + functionName.toLowerCase(Locale.ENGLISH) + " only accepts one argument and it must be Double, Float, Int32 or Int64 data type.");
            }
            return DoubleType.DOUBLE;
        }
        if (TableBuiltinScalarFunction.ASIN.getFunctionName().equalsIgnoreCase(functionName)) {
            if (argumentTypes.size() != 1 || !TableMetadataImpl.isSupportedMathNumericType(argumentTypes.get(0))) {
                throw new SemanticException("Scalar function " + functionName.toLowerCase(Locale.ENGLISH) + " only accepts one argument and it must be Double, Float, Int32 or Int64 data type.");
            }
            return DoubleType.DOUBLE;
        }
        if (TableBuiltinScalarFunction.ACOS.getFunctionName().equalsIgnoreCase(functionName)) {
            if (argumentTypes.size() != 1 || !TableMetadataImpl.isSupportedMathNumericType(argumentTypes.get(0))) {
                throw new SemanticException("Scalar function " + functionName.toLowerCase(Locale.ENGLISH) + " only accepts one argument and it must be Double, Float, Int32 or Int64 data type.");
            }
            return DoubleType.DOUBLE;
        }
        if (TableBuiltinScalarFunction.ATAN.getFunctionName().equalsIgnoreCase(functionName)) {
            if (argumentTypes.size() != 1 || !TableMetadataImpl.isSupportedMathNumericType(argumentTypes.get(0))) {
                throw new SemanticException("Scalar function " + functionName.toLowerCase(Locale.ENGLISH) + " only accepts one argument and it must be Double, Float, Int32 or Int64 data type.");
            }
            return DoubleType.DOUBLE;
        }
        if (TableBuiltinScalarFunction.SINH.getFunctionName().equalsIgnoreCase(functionName)) {
            if (argumentTypes.size() != 1 || !TableMetadataImpl.isSupportedMathNumericType(argumentTypes.get(0))) {
                throw new SemanticException("Scalar function " + functionName.toLowerCase(Locale.ENGLISH) + " only accepts one argument and it must be Double, Float, Int32 or Int64 data type.");
            }
            return DoubleType.DOUBLE;
        }
        if (TableBuiltinScalarFunction.COSH.getFunctionName().equalsIgnoreCase(functionName)) {
            if (argumentTypes.size() != 1 || !TableMetadataImpl.isSupportedMathNumericType(argumentTypes.get(0))) {
                throw new SemanticException("Scalar function " + functionName.toLowerCase(Locale.ENGLISH) + " only accepts one argument and it must be Double, Float, Int32 or Int64 data type.");
            }
            return DoubleType.DOUBLE;
        }
        if (TableBuiltinScalarFunction.TANH.getFunctionName().equalsIgnoreCase(functionName)) {
            if (argumentTypes.size() != 1 || !TableMetadataImpl.isSupportedMathNumericType(argumentTypes.get(0))) {
                throw new SemanticException("Scalar function " + functionName.toLowerCase(Locale.ENGLISH) + " only accepts one argument and it must be Double, Float, Int32 or Int64 data type.");
            }
            return DoubleType.DOUBLE;
        }
        if (TableBuiltinScalarFunction.DEGREES.getFunctionName().equalsIgnoreCase(functionName)) {
            if (argumentTypes.size() != 1 || !TableMetadataImpl.isSupportedMathNumericType(argumentTypes.get(0))) {
                throw new SemanticException("Scalar function " + functionName.toLowerCase(Locale.ENGLISH) + " only accepts one argument and it must be Double, Float, Int32 or Int64 data type.");
            }
            return DoubleType.DOUBLE;
        }
        if (TableBuiltinScalarFunction.RADIANS.getFunctionName().equalsIgnoreCase(functionName)) {
            if (argumentTypes.size() != 1 || !TableMetadataImpl.isSupportedMathNumericType(argumentTypes.get(0))) {
                throw new SemanticException("Scalar function " + functionName.toLowerCase(Locale.ENGLISH) + " only accepts one argument and it must be Double, Float, Int32 or Int64 data type.");
            }
            return DoubleType.DOUBLE;
        }
        if (TableBuiltinScalarFunction.ABS.getFunctionName().equalsIgnoreCase(functionName)) {
            if (argumentTypes.size() != 1 || !TableMetadataImpl.isSupportedMathNumericType(argumentTypes.get(0))) {
                throw new SemanticException("Scalar function " + functionName.toLowerCase(Locale.ENGLISH) + " only accepts one argument and it must be Double, Float, Int32 or Int64 data type.");
            }
            return argumentTypes.get(0);
        }
        if (TableBuiltinScalarFunction.SIGN.getFunctionName().equalsIgnoreCase(functionName)) {
            if (argumentTypes.size() != 1 || !TableMetadataImpl.isSupportedMathNumericType(argumentTypes.get(0))) {
                throw new SemanticException("Scalar function " + functionName.toLowerCase(Locale.ENGLISH) + " only accepts one argument and it must be Double, Float, Int32 or Int64 data type.");
            }
            return argumentTypes.get(0);
        }
        if (TableBuiltinScalarFunction.CEIL.getFunctionName().equalsIgnoreCase(functionName)) {
            if (argumentTypes.size() != 1 || !TableMetadataImpl.isSupportedMathNumericType(argumentTypes.get(0))) {
                throw new SemanticException("Scalar function " + functionName.toLowerCase(Locale.ENGLISH) + " only accepts one argument and it must be Double, Float, Int32 or Int64 data type.");
            }
            return DoubleType.DOUBLE;
        }
        if (TableBuiltinScalarFunction.FLOOR.getFunctionName().equalsIgnoreCase(functionName)) {
            if (argumentTypes.size() != 1 || !TableMetadataImpl.isSupportedMathNumericType(argumentTypes.get(0))) {
                throw new SemanticException("Scalar function " + functionName.toLowerCase(Locale.ENGLISH) + " only accepts one argument and it must be Double, Float, Int32 or Int64 data type.");
            }
            return DoubleType.DOUBLE;
        }
        if (TableBuiltinScalarFunction.EXP.getFunctionName().equalsIgnoreCase(functionName)) {
            if (argumentTypes.size() != 1 || !TableMetadataImpl.isSupportedMathNumericType(argumentTypes.get(0))) {
                throw new SemanticException("Scalar function " + functionName.toLowerCase(Locale.ENGLISH) + " only accepts one argument and it must be Double, Float, Int32 or Int64 data type.");
            }
            return DoubleType.DOUBLE;
        }
        if (TableBuiltinScalarFunction.LN.getFunctionName().equalsIgnoreCase(functionName)) {
            if (argumentTypes.size() != 1 || !TableMetadataImpl.isSupportedMathNumericType(argumentTypes.get(0))) {
                throw new SemanticException("Scalar function " + functionName.toLowerCase(Locale.ENGLISH) + " only accepts one argument and it must be Double, Float, Int32 or Int64 data type.");
            }
            return DoubleType.DOUBLE;
        }
        if (TableBuiltinScalarFunction.LOG10.getFunctionName().equalsIgnoreCase(functionName)) {
            if (argumentTypes.size() != 1 || !TableMetadataImpl.isSupportedMathNumericType(argumentTypes.get(0))) {
                throw new SemanticException("Scalar function " + functionName.toLowerCase(Locale.ENGLISH) + " only accepts one argument and it must be Double, Float, Int32 or Int64 data type.");
            }
            return DoubleType.DOUBLE;
        }
        if (TableBuiltinScalarFunction.SQRT.getFunctionName().equalsIgnoreCase(functionName)) {
            if (argumentTypes.size() != 1 || !TableMetadataImpl.isSupportedMathNumericType(argumentTypes.get(0))) {
                throw new SemanticException("Scalar function " + functionName.toLowerCase(Locale.ENGLISH) + " only accepts one argument and it must be Double, Float, Int32 or Int64 data type.");
            }
            return DoubleType.DOUBLE;
        }
        if (TableBuiltinScalarFunction.PI.getFunctionName().equalsIgnoreCase(functionName)) {
            if (!argumentTypes.isEmpty()) {
                throw new SemanticException("Scalar function " + functionName.toLowerCase(Locale.ENGLISH) + " accepts no argument.");
            }
            return DoubleType.DOUBLE;
        }
        if (TableBuiltinScalarFunction.E.getFunctionName().equalsIgnoreCase(functionName)) {
            if (!argumentTypes.isEmpty()) {
                throw new SemanticException("Scalar function " + functionName.toLowerCase(Locale.ENGLISH) + " accepts no argument.");
            }
            return DoubleType.DOUBLE;
        }
        if (TableBuiltinScalarFunction.DATE_BIN.getFunctionName().equalsIgnoreCase(functionName)) {
            if (!TableMetadataImpl.isTimestampType(argumentTypes.get(2))) {
                throw new SemanticException("Scalar function " + functionName.toLowerCase(Locale.ENGLISH) + " only accepts two or three arguments and the second and third must be TimeStamp data type.");
            }
            return TimestampType.TIMESTAMP;
        }
        if (TableBuiltinScalarFunction.FORMAT.getFunctionName().equalsIgnoreCase(functionName)) {
            if (argumentTypes.size() < 2 || !TableMetadataImpl.isCharType(argumentTypes.get(0))) {
                throw new SemanticException("Scalar function " + functionName.toLowerCase(Locale.ENGLISH) + " must have at least two arguments, and first argument pattern must be TEXT or STRING type.");
            }
            return StringType.STRING;
        }
        if (TableBuiltinScalarFunction.GREATEST.getFunctionName().equalsIgnoreCase(functionName) || TableBuiltinScalarFunction.LEAST.getFunctionName().equalsIgnoreCase(functionName)) {
            if (argumentTypes.size() < 2 || !TableMetadataImpl.areAllTypesSameAndComparable(argumentTypes)) {
                throw new SemanticException("Scalar function " + functionName.toLowerCase(Locale.ENGLISH) + " must have at least two arguments, and all type must be the same.");
            }
            return argumentTypes.get(0);
        }
        switch (functionName.toLowerCase(Locale.ENGLISH)) {
            case "avg": 
            case "sum": 
            case "extreme": 
            case "stddev": 
            case "stddev_pop": 
            case "stddev_samp": 
            case "variance": 
            case "var_pop": 
            case "var_samp": {
                if (argumentTypes.size() != 1) {
                    throw new SemanticException(String.format("Aggregate functions [%s] should only have one argument", functionName));
                }
                if (TableMetadataImpl.isSupportedMathNumericType(argumentTypes.get(0))) break;
                throw new SemanticException(String.format("Aggregate functions [%s] only support numeric data types [INT32, INT64, FLOAT, DOUBLE]", functionName));
            }
            case "min": 
            case "max": 
            case "mode": {
                if (argumentTypes.size() == 1) break;
                throw new SemanticException(String.format("Aggregate functions [%s] should only have one argument", functionName));
            }
            case "count_if": {
                if (argumentTypes.size() == 1 && TableMetadataImpl.isBool(argumentTypes.get(0))) break;
                throw new SemanticException(String.format("Aggregate functions [%s] should only have one boolean expression as argument", functionName));
            }
            case "first": 
            case "last": {
                if (argumentTypes.size() != 2) {
                    throw new SemanticException(String.format("Aggregate functions [%s] should only have one or two arguments", functionName));
                }
                if (TableMetadataImpl.isTimestampType(argumentTypes.get(1))) break;
                throw new SemanticException(String.format("Second argument of Aggregate functions [%s] should be orderable", functionName));
            }
            case "first_by": 
            case "last_by": {
                if (argumentTypes.size() == 3) break;
                throw new SemanticException(String.format("Aggregate functions [%s] should only have two or three arguments", functionName));
            }
            case "max_by": 
            case "min_by": {
                if (argumentTypes.size() != 2) {
                    throw new SemanticException(String.format("Aggregate functions [%s] should only have two arguments", functionName));
                }
                if (argumentTypes.get(1).isOrderable()) break;
                throw new SemanticException(String.format("Second argument of Aggregate functions [%s] should be orderable", functionName));
            }
            case "count": {
                break;
            }
        }
        switch (functionName.toLowerCase(Locale.ENGLISH)) {
            case "count": 
            case "count_all": 
            case "count_if": {
                return LongType.INT64;
            }
            case "first": 
            case "last": 
            case "first_by": 
            case "last_by": 
            case "extreme": 
            case "mode": 
            case "max": 
            case "min": 
            case "max_by": 
            case "min_by": {
                return argumentTypes.get(0);
            }
            case "avg": 
            case "sum": 
            case "stddev": 
            case "stddev_pop": 
            case "stddev_samp": 
            case "variance": 
            case "var_pop": 
            case "var_samp": {
                return DoubleType.DOUBLE;
            }
        }
        if (TableUDFUtils.isScalarFunction((String)functionName)) {
            ScalarFunction scalarFunction = TableUDFUtils.getScalarFunction((String)functionName);
            FunctionArguments functionArguments = new FunctionArguments(argumentTypes.stream().map(UDFDataTypeTransformer::transformReadTypeToUDFDataType).collect(Collectors.toList()), Collections.emptyMap());
            try {
                ScalarFunctionAnalysis scalarFunctionAnalysis = scalarFunction.analyze(functionArguments);
                org.apache.tsfile.read.common.type.Type type = UDFDataTypeTransformer.transformUDFDataTypeToReadType((Type)scalarFunctionAnalysis.getOutputDataType());
                return type;
            }
            catch (Exception e) {
                throw new SemanticException("Invalid function parameters: " + e.getMessage());
            }
            finally {
                scalarFunction.beforeDestroy();
            }
        }
        if (TableUDFUtils.isAggregateFunction((String)functionName)) {
            AggregateFunction aggregateFunction = TableUDFUtils.getAggregateFunction((String)functionName);
            FunctionArguments functionArguments = new FunctionArguments(argumentTypes.stream().map(UDFDataTypeTransformer::transformReadTypeToUDFDataType).collect(Collectors.toList()), Collections.emptyMap());
            try {
                AggregateFunctionAnalysis aggregateFunctionAnalysis = aggregateFunction.analyze(functionArguments);
                org.apache.tsfile.read.common.type.Type type = UDFDataTypeTransformer.transformUDFDataTypeToReadType((Type)aggregateFunctionAnalysis.getOutputDataType());
                return type;
            }
            catch (Exception e) {
                throw new SemanticException("Invalid function parameters: " + e.getMessage());
            }
            finally {
                aggregateFunction.beforeDestroy();
            }
        }
        throw new SemanticException("Unknown function: " + functionName);
    }

    @Override
    public boolean isAggregationFunction(SessionInfo session, String functionName, AccessControl accessControl) {
        return TableBuiltinAggregationFunction.getBuiltInAggregateFunctionName().contains(functionName.toLowerCase(Locale.ENGLISH)) || TableUDFUtils.isAggregateFunction((String)functionName);
    }

    @Override
    public org.apache.tsfile.read.common.type.Type getType(TypeSignature signature) throws TypeNotFoundException {
        return this.typeManager.getType(signature);
    }

    @Override
    public boolean canCoerce(org.apache.tsfile.read.common.type.Type from, org.apache.tsfile.read.common.type.Type to) {
        return true;
    }

    @Override
    public IPartitionFetcher getPartitionFetcher() {
        return ClusterPartitionFetcher.getInstance();
    }

    @Override
    public List<DeviceEntry> indexScan(QualifiedObjectName tableName, List<Expression> expressionList, List<String> attributeColumns, MPPQueryContext context) {
        return TableDeviceSchemaFetcher.getInstance().fetchDeviceSchemaForDataQuery(tableName.getDatabaseName(), tableName.getObjectName(), expressionList, attributeColumns, context);
    }

    @Override
    public Optional<TableSchema> validateTableHeaderSchema(String database, TableSchema tableSchema, MPPQueryContext context, boolean allowCreateTable, boolean isStrictIdColumn) throws LoadAnalyzeTableColumnDisorderException {
        return TableHeaderSchemaValidator.getInstance().validateTableHeaderSchema(database, tableSchema, context, allowCreateTable, isStrictIdColumn);
    }

    @Override
    public void validateDeviceSchema(ITableDeviceSchemaValidation schemaValidation, MPPQueryContext context) {
        TableDeviceSchemaValidator.getInstance().validateDeviceSchema(schemaValidation, context);
    }

    @Override
    public DataPartition getOrCreateDataPartition(List<DataPartitionQueryParam> dataPartitionQueryParams, String userName) {
        return this.partitionFetcher.getOrCreateDataPartition(dataPartitionQueryParams, userName);
    }

    @Override
    public SchemaPartition getOrCreateSchemaPartition(String database, List<IDeviceID> deviceIDList, String userName) {
        return this.partitionFetcher.getOrCreateSchemaPartition(database, deviceIDList, userName);
    }

    @Override
    public SchemaPartition getSchemaPartition(String database, List<IDeviceID> deviceIDList) {
        return this.partitionFetcher.getSchemaPartition(database, deviceIDList);
    }

    @Override
    public SchemaPartition getSchemaPartition(String database) {
        return this.partitionFetcher.getSchemaPartition(database, null);
    }

    @Override
    public DataPartition getDataPartition(String database, List<DataPartitionQueryParam> sgNameToQueryParamsMap) {
        return this.partitionFetcher.getDataPartition(Collections.singletonMap(database, sgNameToQueryParamsMap));
    }

    @Override
    public DataPartition getDataPartitionWithUnclosedTimeRange(String database, List<DataPartitionQueryParam> sgNameToQueryParamsMap) {
        return this.partitionFetcher.getDataPartitionWithUnclosedTimeRange(Collections.singletonMap(database, sgNameToQueryParamsMap));
    }

    @Override
    public TableFunction getTableFunction(String functionName) {
        if (TableBuiltinTableFunction.isBuiltInTableFunction((String)functionName)) {
            return TableBuiltinTableFunction.getBuiltinTableFunction((String)functionName);
        }
        if (TableUDFUtils.isTableFunction((String)functionName)) {
            return TableUDFUtils.getTableFunction((String)functionName);
        }
        throw new SemanticException("Unknown function: " + functionName);
    }

    public static boolean isTwoNumericType(List<? extends org.apache.tsfile.read.common.type.Type> argumentTypes) {
        return argumentTypes.size() == 2 && TableMetadataImpl.isNumericType(argumentTypes.get(0)) && TableMetadataImpl.isNumericType(argumentTypes.get(1));
    }

    public static boolean isOneNumericType(List<? extends org.apache.tsfile.read.common.type.Type> argumentTypes) {
        return argumentTypes.size() == 1 && TableMetadataImpl.isNumericType(argumentTypes.get(0));
    }

    public static boolean isTwoSupportedMathNumericType(List<? extends org.apache.tsfile.read.common.type.Type> argumentTypes) {
        return argumentTypes.size() == 2 && TableMetadataImpl.isSupportedMathNumericType(argumentTypes.get(0)) && TableMetadataImpl.isSupportedMathNumericType(argumentTypes.get(1));
    }

    public static boolean isOneSupportedMathNumericType(List<? extends org.apache.tsfile.read.common.type.Type> argumentTypes) {
        return argumentTypes.size() == 1 && TableMetadataImpl.isSupportedMathNumericType(argumentTypes.get(0));
    }

    public static boolean isOneBooleanType(List<? extends org.apache.tsfile.read.common.type.Type> argumentTypes) {
        return argumentTypes.size() == 1 && BooleanType.BOOLEAN.equals(argumentTypes.get(0));
    }

    public static boolean isOneCharType(List<? extends org.apache.tsfile.read.common.type.Type> argumentTypes) {
        return argumentTypes.size() == 1 && TableMetadataImpl.isCharType(argumentTypes.get(0));
    }

    public static boolean isTwoCharType(List<? extends org.apache.tsfile.read.common.type.Type> argumentTypes) {
        return argumentTypes.size() == 2 && TableMetadataImpl.isCharType(argumentTypes.get(0)) && TableMetadataImpl.isCharType(argumentTypes.get(1));
    }

    public static boolean isThreeCharType(List<? extends org.apache.tsfile.read.common.type.Type> argumentTypes) {
        return argumentTypes.size() == 3 && TableMetadataImpl.isCharType(argumentTypes.get(0)) && TableMetadataImpl.isCharType(argumentTypes.get(1)) && TableMetadataImpl.isCharType(argumentTypes.get(2));
    }

    public static boolean isCharType(org.apache.tsfile.read.common.type.Type type) {
        return BinaryType.TEXT.equals(type) || StringType.STRING.equals(type);
    }

    public static boolean isBlobType(org.apache.tsfile.read.common.type.Type type) {
        return BlobType.BLOB.equals(type);
    }

    public static boolean isBool(org.apache.tsfile.read.common.type.Type type) {
        return BooleanType.BOOLEAN.equals(type);
    }

    public static boolean isSupportedMathNumericType(org.apache.tsfile.read.common.type.Type type) {
        return DoubleType.DOUBLE.equals(type) || FloatType.FLOAT.equals(type) || IntType.INT32.equals(type) || LongType.INT64.equals(type);
    }

    public static boolean isNumericType(org.apache.tsfile.read.common.type.Type type) {
        return DoubleType.DOUBLE.equals(type) || FloatType.FLOAT.equals(type) || IntType.INT32.equals(type) || LongType.INT64.equals(type) || TimestampType.TIMESTAMP.equals(type);
    }

    public static boolean isTimestampType(org.apache.tsfile.read.common.type.Type type) {
        return TimestampType.TIMESTAMP.equals(type);
    }

    public static boolean isUnknownType(org.apache.tsfile.read.common.type.Type type) {
        return UnknownType.UNKNOWN.equals(type);
    }

    public static boolean isIntegerNumber(org.apache.tsfile.read.common.type.Type type) {
        return IntType.INT32.equals(type) || LongType.INT64.equals(type);
    }

    public static boolean isTwoTypeComparable(List<? extends org.apache.tsfile.read.common.type.Type> argumentTypes) {
        org.apache.tsfile.read.common.type.Type right;
        if (argumentTypes.size() != 2) {
            return false;
        }
        org.apache.tsfile.read.common.type.Type left = argumentTypes.get(0);
        if (left.equals(right = argumentTypes.get(1))) {
            return true;
        }
        return TableMetadataImpl.isNumericType(left) && TableMetadataImpl.isNumericType(right) || TableMetadataImpl.isCharType(left) && TableMetadataImpl.isCharType(right) || TableMetadataImpl.isUnknownType(left) && (TableMetadataImpl.isNumericType(right) || TableMetadataImpl.isCharType(right)) || (TableMetadataImpl.isNumericType(left) || TableMetadataImpl.isCharType(left)) && TableMetadataImpl.isUnknownType(right);
    }

    public static boolean areAllTypesSameAndComparable(List<? extends org.apache.tsfile.read.common.type.Type> argumentTypes) {
        if (argumentTypes == null || argumentTypes.isEmpty()) {
            return true;
        }
        org.apache.tsfile.read.common.type.Type firstType = argumentTypes.get(0);
        if (!firstType.isComparable()) {
            return false;
        }
        return argumentTypes.stream().allMatch(type -> type.equals(firstType));
    }

    public static boolean isArithmeticType(org.apache.tsfile.read.common.type.Type type) {
        return IntType.INT32.equals(type) || LongType.INT64.equals(type) || FloatType.FLOAT.equals(type) || DoubleType.DOUBLE.equals(type) || DateType.DATE.equals(type) || TimestampType.TIMESTAMP.equals(type);
    }

    public static boolean isTwoTypeCalculable(List<? extends org.apache.tsfile.read.common.type.Type> argumentTypes) {
        if (argumentTypes.size() != 2) {
            return false;
        }
        org.apache.tsfile.read.common.type.Type left = argumentTypes.get(0);
        org.apache.tsfile.read.common.type.Type right = argumentTypes.get(1);
        if (TableMetadataImpl.isUnknownType(left) && TableMetadataImpl.isArithmeticType(right) || TableMetadataImpl.isUnknownType(right) && TableMetadataImpl.isArithmeticType(left)) {
            return true;
        }
        return TableMetadataImpl.isArithmeticType(left) && TableMetadataImpl.isArithmeticType(right);
    }

    public static void throwTableNotExistsException(String database, String tableName) {
        throw new SemanticException((Throwable)new TableNotExistsException(database, tableName));
    }

    public static void throwColumnNotExistsException(Object columnName) {
        throw new SemanticException(new IoTDBException(String.format("Column '%s' cannot be resolved.", columnName), TSStatusCode.COLUMN_NOT_EXISTS.getStatusCode()));
    }
}

