/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.fill.linear;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.ILinearFill;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;

public abstract class LinearFill
implements ILinearFill {
    protected boolean previousIsNull = true;
    private long nextRowIndex = -1L;
    private long nextRowIndexInCurrentColumn = -1L;
    protected long previousTime = -1L;
    private long nextTime = -1L;
    protected long nextTimeInCurrentColumn = -1L;

    @Override
    public Column fill(Column timeColumn, Column valueColumn, long startRowIndex) {
        int size = valueColumn.getPositionCount();
        if (size == 0) {
            return valueColumn;
        }
        if (!valueColumn.mayHaveNull()) {
            int lastNonNullIndex = -1;
            if (!timeColumn.mayHaveNull()) {
                lastNonNullIndex = size - 1;
            } else {
                for (int i = size - 1; i >= 0; --i) {
                    if (timeColumn.isNull(i)) continue;
                    lastNonNullIndex = i;
                    break;
                }
            }
            if (lastNonNullIndex != -1) {
                this.previousIsNull = false;
                this.previousTime = timeColumn.getLong(lastNonNullIndex);
                this.updatePreviousValue(valueColumn, lastNonNullIndex);
            }
            return valueColumn;
        }
        if (valueColumn instanceof RunLengthEncodedColumn) {
            return this.doWithAllNulls(startRowIndex, size, timeColumn, valueColumn);
        }
        Object array = this.createValueArray(size);
        boolean[] isNull = new boolean[size];
        boolean hasNullValue = false;
        for (int i = 0; i < size; ++i) {
            if (valueColumn.isNull(i)) {
                hasNullValue = this.fill(startRowIndex, i, isNull, timeColumn, valueColumn, array) || hasNullValue;
                continue;
            }
            this.fillValue(valueColumn, i, array);
            if (timeColumn.isNull(i)) continue;
            this.previousTime = timeColumn.getLong(i);
            this.updatePreviousValue(valueColumn, i);
            this.previousIsNull = false;
        }
        return this.createFilledValueColumn(array, isNull, hasNullValue, size);
    }

    private Column doWithAllNulls(long startRowIndex, int size, Column timeColumn, Column valueColumn) {
        if (this.previousIsNull || this.nextRowIndex < startRowIndex) {
            return new RunLengthEncodedColumn(this.createNullValueColumn(), size);
        }
        this.prepareForNextValueInCurrentColumn(startRowIndex + (long)size - 1L, size, timeColumn, valueColumn);
        double[] factors = new double[size];
        boolean[] valueIsNull = new boolean[size];
        boolean hasNull = false;
        for (int i = 0; i < size; ++i) {
            if (timeColumn.isNull(i)) {
                valueIsNull[i] = true;
                hasNull = true;
                continue;
            }
            factors[i] = this.getFactor(timeColumn.getLong(i));
        }
        return this.createFilledValueColumn(factors, hasNull ? Optional.empty() : Optional.of(valueIsNull));
    }

    private boolean fill(long startRowIndex, int i, boolean[] isNull, Column timeColumn, Column valueColumn, Object array) {
        long currentRowIndex = startRowIndex + (long)i;
        this.prepareForNextValueInCurrentColumn(currentRowIndex, i + 1, timeColumn, valueColumn);
        if (this.previousIsNull || timeColumn.isNull(i) || this.nextIsNull(currentRowIndex)) {
            isNull[i] = true;
            return true;
        }
        double factor = this.getFactor(timeColumn.getLong(i));
        this.fillValue(array, i, factor);
        return false;
    }

    private double getFactor(long currentTime) {
        return this.nextTimeInCurrentColumn - this.previousTime == 0L ? 0.0 : (double)(currentTime - this.previousTime) / (double)(this.nextTimeInCurrentColumn - this.previousTime);
    }

    @Override
    public boolean needPrepareForNext(long rowIndex, Column valueColumn, int lastRowIndexForNonNullHelperColumn) {
        return this.nextRowIndex < rowIndex && lastRowIndexForNonNullHelperColumn >= 0 && valueColumn.isNull(lastRowIndexForNonNullHelperColumn);
    }

    @Override
    public boolean prepareForNext(long startRowIndex, long endRowIndex, Column nextTimeColumn, Column nextValueColumn) {
        Preconditions.checkArgument((nextTimeColumn.getPositionCount() > 0 && endRowIndex < startRowIndex ? 1 : 0) != 0, (Object)"nextColumn's time should be greater than current time");
        if (endRowIndex <= this.nextRowIndex) {
            return true;
        }
        int size = nextValueColumn.getPositionCount();
        for (int i = 0; i < size; ++i) {
            if (nextTimeColumn.isNull(i) || nextValueColumn.isNull(i)) continue;
            this.updateNextValue(nextValueColumn, i);
            this.nextTime = nextTimeColumn.getLong(i);
            this.nextRowIndex = startRowIndex + (long)i;
            return true;
        }
        return false;
    }

    private boolean nextIsNull(long rowIndex) {
        return this.nextRowIndexInCurrentColumn <= rowIndex;
    }

    private void prepareForNextValueInCurrentColumn(long currentRowIndex, int startIndex, Column timeColumn, Column valueColumn) {
        if (currentRowIndex <= this.nextRowIndexInCurrentColumn) {
            return;
        }
        for (int i = startIndex; i < valueColumn.getPositionCount(); ++i) {
            if (timeColumn.isNull(i) || valueColumn.isNull(i)) continue;
            this.nextRowIndexInCurrentColumn = currentRowIndex + (long)(i - startIndex + 1);
            this.nextTimeInCurrentColumn = timeColumn.getLong(i);
            this.updateNextValueInCurrentColumn(valueColumn, i);
            return;
        }
        this.nextRowIndexInCurrentColumn = this.nextRowIndex;
        this.nextTimeInCurrentColumn = this.nextTime;
        this.updateNextValueInCurrentColumn();
    }

    @Override
    public void reset() {
        this.previousIsNull = true;
        this.nextRowIndex = -1L;
        this.nextRowIndexInCurrentColumn = -1L;
        this.previousTime = -1L;
        this.nextTime = -1L;
        this.nextTimeInCurrentColumn = -1L;
    }

    abstract void fillValue(Column var1, int var2, Object var3);

    abstract void fillValue(Object var1, int var2, double var3);

    abstract Object createValueArray(int var1);

    abstract Column createNullValueColumn();

    abstract Column createFilledValueColumn(double[] var1, Optional<boolean[]> var2);

    abstract Column createFilledValueColumn(Object var1, boolean[] var2, boolean var3, int var4);

    abstract void updatePreviousValue(Column var1, int var2);

    abstract void updateNextValue(Column var1, int var2);

    abstract void updateNextValueInCurrentColumn(Column var1, int var2);

    abstract void updateNextValueInCurrentColumn();
}

