/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.IoTDBRuntimeException;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.execution.QueryState;
import org.apache.iotdb.db.queryengine.execution.StateMachine;
import org.apache.iotdb.db.utils.ErrorHandlingUtils;
import org.apache.iotdb.rpc.RpcUtils;

public class QueryStateMachine {
    private final StateMachine<QueryState> queryState;
    private Executor stateMachineExecutor;
    private Throwable failureException;
    private TSStatus failureStatus;

    public QueryStateMachine(QueryId queryId, ExecutorService executor) {
        this.stateMachineExecutor = executor;
        this.queryState = new StateMachine<QueryState>(queryId.toString(), this.stateMachineExecutor, QueryState.QUEUED, QueryState.TERMINAL_INSTANCE_STATES);
    }

    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> stateChangeListener) {
        this.queryState.addStateChangeListener(stateChangeListener);
    }

    public ListenableFuture<QueryState> getStateChange(QueryState currentState) {
        return this.queryState.getStateChange(currentState);
    }

    public QueryState getState() {
        return this.queryState.get();
    }

    public void transitionToQueued() {
        this.queryState.set(QueryState.QUEUED);
    }

    public void transitionToPlanned() {
        this.queryState.setIf(QueryState.PLANNED, currentState -> currentState == QueryState.QUEUED);
    }

    public void transitionToDispatching() {
        this.queryState.setIf(QueryState.DISPATCHING, currentState -> currentState == QueryState.PLANNED);
    }

    public void transitionToPendingRetry(TSStatus failureStatus) {
        this.failureStatus = failureStatus;
        this.queryState.setIf(QueryState.PENDING_RETRY, currentState -> currentState == QueryState.DISPATCHING);
    }

    public void transitionToRunning() {
        this.queryState.setIf(QueryState.RUNNING, currentState -> currentState == QueryState.DISPATCHING || currentState == QueryState.QUEUED);
    }

    public void transitionToFinished() {
        this.transitionToDoneState(QueryState.FINISHED);
    }

    public void transitionToCanceled() {
        this.transitionToDoneState(QueryState.CANCELED);
    }

    public void transitionToCanceled(Throwable throwable, TSStatus failureStatus) {
        this.failureException = throwable;
        this.failureStatus = failureStatus;
        this.transitionToDoneState(QueryState.CANCELED);
    }

    public void transitionToAborted() {
        this.transitionToDoneState(QueryState.ABORTED);
    }

    public void transitionToFailed() {
        this.transitionToDoneState(QueryState.FAILED);
    }

    public void transitionToFailed(Throwable throwable) {
        this.failureException = throwable;
        this.transitionToDoneState(QueryState.FAILED);
    }

    public void transitionToFailed(TSStatus failureStatus) {
        this.failureStatus = failureStatus;
        this.transitionToDoneState(QueryState.FAILED);
    }

    private void transitionToDoneState(QueryState doneState) {
        Objects.requireNonNull(doneState, "doneState is null");
        Preconditions.checkArgument((boolean)doneState.isDone(), (String)"doneState %s is not a done state", (Object)((Object)doneState));
        this.queryState.setIf(doneState, currentState -> !currentState.isDone());
    }

    public String getFailureMessage() {
        if (this.failureException != null) {
            return this.failureException.getMessage();
        }
        return "no detailed failure reason in QueryStateMachine";
    }

    public Throwable getFailureException() {
        if (this.failureException == null) {
            return new IoTDBException(this.getFailureStatus().getMessage(), this.getFailureStatus().code);
        }
        return this.failureException;
    }

    public TSStatus getFailureStatus() {
        if (this.failureStatus != null) {
            return this.failureStatus;
        }
        if (this.failureException != null) {
            Throwable t = ErrorHandlingUtils.getRootCause(this.failureException);
            if (t instanceof IoTDBRuntimeException) {
                return RpcUtils.getStatus((int)((IoTDBRuntimeException)t).getErrorCode(), (String)t.getMessage());
            }
            if (t instanceof IoTDBException) {
                return RpcUtils.getStatus((int)((IoTDBException)t).getErrorCode(), (String)t.getMessage());
            }
        }
        return this.failureStatus;
    }
}

