/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol.thrift.async.handler;

import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.async.AsyncPipeDataTransferServiceClient;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.async.IoTDBDataRegionAsyncConnector;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.async.handler.PipeTransferTrackableHandler;
import org.apache.iotdb.db.pipe.event.common.PipeInsertionEvent;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipeTransferTabletInsertionEventHandler
extends PipeTransferTrackableHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTransferTabletInsertionEventHandler.class);
    protected final PipeInsertionEvent event;
    protected final TPipeTransferReq req;

    protected PipeTransferTabletInsertionEventHandler(PipeInsertionEvent event, TPipeTransferReq req, IoTDBDataRegionAsyncConnector connector) {
        super(connector);
        this.event = event;
        this.req = req;
    }

    public void transfer(AsyncPipeDataTransferServiceClient client) throws TException {
        this.connector.rateLimitIfNeeded(this.event.getPipeName(), this.event.getCreationTime(), client.getEndPoint(), this.req.getBody().length);
        this.tryTransfer(client, this.req);
    }

    @Override
    protected boolean onCompleteInternal(TPipeTransferResp response) {
        if (response == null) {
            this.onError((Exception)((Object)new PipeException("TPipeTransferResp is null")));
            return false;
        }
        TSStatus status = response.getStatus();
        try {
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() && status.getCode() != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
                this.connector.statusHandler().handle(response.getStatus(), response.getStatus().getMessage(), this.event.toString());
            }
            this.event.decreaseReferenceCount(PipeTransferTabletInsertionEventHandler.class.getName(), true);
            if (status.isSetRedirectNode()) {
                this.updateLeaderCache(status);
            }
        }
        catch (Exception e) {
            this.onError(e);
            return false;
        }
        return true;
    }

    @Override
    protected void onErrorInternal(Exception exception) {
        try {
            LOGGER.warn("Failed to transfer TabletInsertionEvent {} (committer key={}, commit id={}).", new Object[]{this.event.coreReportMessage(), this.event.getCommitterKey(), this.event.getCommitId(), exception});
        }
        finally {
            this.connector.addFailureEventToRetryQueue((Event)this.event);
        }
    }

    @Override
    public void clearEventsReferenceCount() {
        this.event.clearReferenceCount(PipeTransferTabletInsertionEventHandler.class.getName());
    }

    protected abstract void updateLeaderCache(TSStatus var1);
}

