/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.allocation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iotdb.db.storageengine.dataregion.wal.allocation.AbstractNodeAllocationStrategy;
import org.apache.iotdb.db.storageengine.dataregion.wal.node.IWALNode;
import org.apache.iotdb.db.storageengine.dataregion.wal.node.WALNode;

public class ElasticStrategy
extends AbstractNodeAllocationStrategy {
    public static final int APPLICATION_NODE_RATIO = 4;
    private final Lock nodesLock = new ReentrantLock();
    private final List<WALNode> walNodes;
    private final Map<String, WALNode> uniqueId2Nodes = new HashMap<String, WALNode>();
    private int nodeIdCounter = -1;

    public ElasticStrategy() {
        this.walNodes = new ArrayList<WALNode>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IWALNode applyForWALNode(String applicantUniqueId) {
        this.nodesLock.lock();
        try {
            if (!this.uniqueId2Nodes.containsKey(applicantUniqueId)) {
                if (this.uniqueId2Nodes.size() == this.walNodes.size() * 4) {
                    ++this.nodeIdCounter;
                    IWALNode node = this.createWALNode(String.valueOf(this.nodeIdCounter));
                    if (!(node instanceof WALNode)) {
                        IWALNode iWALNode = node;
                        return iWALNode;
                    }
                    this.walNodes.add((WALNode)node);
                }
                this.uniqueId2Nodes.put(applicantUniqueId, this.walNodes.get(this.nodeIdCounter));
            }
            IWALNode iWALNode = this.uniqueId2Nodes.get(applicantUniqueId);
            return iWALNode;
        }
        finally {
            this.nodesLock.unlock();
        }
    }

    @Override
    public List<WALNode> getNodesSnapshot() {
        ArrayList<WALNode> snapshot;
        this.nodesLock.lock();
        try {
            snapshot = new ArrayList<WALNode>(this.walNodes);
        }
        finally {
            this.nodesLock.unlock();
        }
        return snapshot;
    }

    @Override
    public int getNodesNum() {
        return this.walNodes.size();
    }

    @Override
    public void clear() {
        this.nodesLock.lock();
        try {
            this.nodeIdCounter = -1;
            this.uniqueId2Nodes.clear();
            for (WALNode walNode : this.walNodes) {
                walNode.close();
            }
            this.walNodes.clear();
        }
        finally {
            this.nodesLock.unlock();
        }
    }
}

