/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.exception.metadata.schemafile.SegmentNotFoundException;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.ISchemaPage;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.ISegment;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.ISegmentedPage;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.SchemaFile;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.WrappedSegment;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public abstract class SchemaPage
implements ISchemaPage {
    protected final ByteBuffer pageBuffer;
    protected final AtomicInteger refCnt;
    protected final ReadWriteLock lock;
    protected int pageIndex;
    protected short spareOffset;
    protected short spareSize;
    protected short memberNum;
    protected boolean dirtyFlag = false;

    protected SchemaPage(ByteBuffer pageBuffer, AtomicInteger ai, ReadWriteLock rwl) {
        this.pageBuffer = pageBuffer;
        this.pageBuffer.limit(this.pageBuffer.capacity()).position(1);
        this.refCnt = ai;
        this.lock = rwl;
        this.pageIndex = ReadWriteIOUtils.readInt((ByteBuffer)this.pageBuffer);
        this.spareOffset = ReadWriteIOUtils.readShort((ByteBuffer)this.pageBuffer);
        this.spareSize = ReadWriteIOUtils.readShort((ByteBuffer)this.pageBuffer);
        this.memberNum = ReadWriteIOUtils.readShort((ByteBuffer)this.pageBuffer);
    }

    protected SchemaPage(ByteBuffer pageBuffer) {
        this(pageBuffer, new AtomicInteger(), new ReentrantReadWriteLock());
    }

    @Override
    public AtomicInteger getRefCnt() {
        return this.refCnt;
    }

    @Override
    public int incrementAndGetRefCnt() {
        return this.refCnt.incrementAndGet();
    }

    @Override
    public int decrementAndGetRefCnt() {
        return this.refCnt.decrementAndGet();
    }

    @Override
    public ReadWriteLock getLock() {
        return this.lock;
    }

    @Override
    public void syncPageBuffer() {
        this.pageBuffer.limit(this.pageBuffer.capacity());
        this.pageBuffer.position(1);
        ReadWriteIOUtils.write((int)this.pageIndex, (ByteBuffer)this.pageBuffer);
        ReadWriteIOUtils.write((short)this.spareOffset, (ByteBuffer)this.pageBuffer);
        ReadWriteIOUtils.write((short)this.spareSize, (ByteBuffer)this.pageBuffer);
        ReadWriteIOUtils.write((short)this.memberNum, (ByteBuffer)this.pageBuffer);
    }

    @Override
    public void flushPageToChannel(FileChannel channel) throws IOException {
        this.pageBuffer.clear();
        channel.write(this.pageBuffer, SchemaFile.getPageAddress(this.pageIndex));
        this.dirtyFlag = false;
    }

    @Override
    public boolean isDirtyPage() {
        return this.dirtyFlag;
    }

    @Override
    public void setDirtyFlag() {
        this.dirtyFlag = true;
    }

    @Override
    public void flushPageToStream(OutputStream stream) throws IOException {
        if (this.pageIndex < 0) {
            stream.write(new byte[]{(byte)this.pageIndex});
            return;
        }
        this.pageBuffer.clear();
        stream.write(this.pageBuffer.array());
    }

    @Override
    public int getPageIndex() {
        return this.pageIndex;
    }

    @Override
    public void setPageIndex(int pid) {
        this.pageIndex = pid;
        this.pageBuffer.clear();
        this.pageBuffer.position(1);
        ReadWriteIOUtils.write((int)this.pageIndex, (ByteBuffer)this.pageBuffer);
        this.pageBuffer.clear();
    }

    @Override
    public int getSubIndex() {
        return -1;
    }

    @Override
    public void setSubIndex(int pid) {
    }

    @Override
    public ISegment<Integer, Integer> getAsInternalPage() {
        return null;
    }

    @Override
    public ISegment<String, String> getAsAliasIndexPage() {
        return null;
    }

    @Override
    public ISegmentedPage getAsSegmentedPage() {
        return null;
    }

    @Override
    public ByteBuffer getEntireSegmentSlice() throws MetadataException {
        return null;
    }

    @Override
    public WrappedSegment getSegmentOnTest(short idx) throws SegmentNotFoundException {
        return null;
    }

    @Override
    public void getPageBuffer(ByteBuffer dstBuffer) {
        this.syncPageBuffer();
        this.pageBuffer.clear();
        dstBuffer.put(this.pageBuffer);
    }
}

