/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.metadata.template;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.db.schemaengine.template.ClusterTemplateManager;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.Pair;

public class ActivateTemplateStatement
extends Statement {
    private PartialPath path;

    public ActivateTemplateStatement() {
        this.statementType = StatementType.ACTIVATE_TEMPLATE;
    }

    public ActivateTemplateStatement(PartialPath path) {
        this.path = path;
        this.statementType = StatementType.ACTIVATE_TEMPLATE;
    }

    @Override
    public List<PartialPath> getPaths() {
        ClusterTemplateManager clusterTemplateManager = ClusterTemplateManager.getInstance();
        Pair<Template, PartialPath> templateSetInfo = clusterTemplateManager.checkTemplateSetInfo(this.path);
        if (templateSetInfo == null) {
            return Collections.emptyList();
        }
        return ((Template)templateSetInfo.left).getSchemaMap().keySet().stream().map(arg_0 -> ((PartialPath)this.path).concatNode(arg_0)).collect(Collectors.toList());
    }

    @Override
    public TSStatus checkPermissionBeforeProcess(String userName) {
        if (AuthorityChecker.SUPER_USER.equals(userName)) {
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        List<PartialPath> checkedPaths = this.getPaths();
        return AuthorityChecker.getTSStatus(AuthorityChecker.checkPatternPermission(userName, checkedPaths, PrivilegeType.WRITE_SCHEMA.ordinal()), checkedPaths, PrivilegeType.WRITE_SCHEMA);
    }

    public PartialPath getPath() {
        return this.path;
    }

    public void setPath(PartialPath path) {
        this.path = path;
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitActivateTemplate(this, context);
    }
}

