/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.source;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.db.queryengine.plan.analyze.TypeProvider;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeUtil;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SeriesSourceNode;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class AlignedSeriesScanNode
extends SeriesSourceNode {
    private final AlignedPath alignedPath;
    private Ordering scanOrder = Ordering.ASC;
    @Nullable
    private Expression pushDownPredicate;
    private long pushDownLimit;
    private long pushDownOffset;
    private boolean queryAllSensors = false;
    private TRegionReplicaSet regionReplicaSet;

    public AlignedSeriesScanNode(PlanNodeId id, AlignedPath alignedPath) {
        super(id);
        this.alignedPath = alignedPath;
    }

    public AlignedSeriesScanNode(PlanNodeId id, AlignedPath alignedPath, Ordering scanOrder, boolean lastLevelUseWildcard) {
        this(id, alignedPath);
        this.scanOrder = scanOrder;
        this.queryAllSensors = lastLevelUseWildcard;
    }

    public AlignedSeriesScanNode(PlanNodeId id, AlignedPath alignedPath, Ordering scanOrder, long pushDownLimit, long pushDownOffset, TRegionReplicaSet dataRegionReplicaSet, boolean lastLevelUseWildcard) {
        this(id, alignedPath, scanOrder, lastLevelUseWildcard);
        this.pushDownLimit = pushDownLimit;
        this.pushDownOffset = pushDownOffset;
        this.regionReplicaSet = dataRegionReplicaSet;
    }

    public AlignedSeriesScanNode(PlanNodeId id, AlignedPath alignedPath, Ordering scanOrder, @Nullable Expression pushDownPredicate, long pushDownLimit, long pushDownOffset, TRegionReplicaSet dataRegionReplicaSet, boolean lastLevelUseWildcard) {
        this(id, alignedPath, scanOrder, lastLevelUseWildcard);
        this.pushDownPredicate = pushDownPredicate;
        this.pushDownLimit = pushDownLimit;
        this.pushDownOffset = pushDownOffset;
        this.regionReplicaSet = dataRegionReplicaSet;
    }

    public AlignedPath getAlignedPath() {
        return this.alignedPath;
    }

    public Ordering getScanOrder() {
        return this.scanOrder;
    }

    @Override
    @Nullable
    public Expression getPushDownPredicate() {
        return this.pushDownPredicate;
    }

    public void setPushDownPredicate(@Nullable Expression pushDownPredicate) {
        this.pushDownPredicate = pushDownPredicate;
    }

    public long getPushDownLimit() {
        return this.pushDownLimit;
    }

    public long getPushDownOffset() {
        return this.pushDownOffset;
    }

    public void setPushDownLimit(long pushDownLimit) {
        this.pushDownLimit = pushDownLimit;
    }

    public void setPushDownOffset(long pushDownOffset) {
        this.pushDownOffset = pushDownOffset;
    }

    @Override
    public void open() throws Exception {
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return this.regionReplicaSet;
    }

    @Override
    public void setRegionReplicaSet(TRegionReplicaSet regionReplicaSet) {
        this.regionReplicaSet = regionReplicaSet;
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public List<PlanNode> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    public boolean isQueryAllSensors() {
        return this.queryAllSensors;
    }

    @Override
    public void addChild(PlanNode child) {
        throw new UnsupportedOperationException("no child is allowed for AlignedSeriesScanNode");
    }

    @Override
    public PlanNode clone() {
        return new AlignedSeriesScanNode(this.getPlanNodeId(), this.getAlignedPath(), this.getScanOrder(), this.getPushDownPredicate(), this.getPushDownLimit(), this.getPushDownOffset(), this.regionReplicaSet, this.queryAllSensors);
    }

    @Override
    public List<String> getOutputColumnNames() {
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        String deviceName = this.alignedPath.getDevice();
        for (String measurement : this.alignedPath.getMeasurementList()) {
            outputColumnNames.add(deviceName.concat("." + measurement));
        }
        return outputColumnNames;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitAlignedSeriesScan(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.ALIGNED_SERIES_SCAN.serialize(byteBuffer);
        this.alignedPath.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.scanOrder.ordinal(), (ByteBuffer)byteBuffer);
        if (this.pushDownPredicate == null) {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)byteBuffer);
            Expression.serialize(this.pushDownPredicate, byteBuffer);
        }
        ReadWriteIOUtils.write((long)this.pushDownLimit, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((long)this.pushDownOffset, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.queryAllSensors, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.ALIGNED_SERIES_SCAN.serialize(stream);
        this.alignedPath.serialize((OutputStream)stream);
        ReadWriteIOUtils.write((int)this.scanOrder.ordinal(), (OutputStream)stream);
        if (this.pushDownPredicate == null) {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            Expression.serialize(this.pushDownPredicate, stream);
        }
        ReadWriteIOUtils.write((long)this.pushDownLimit, (OutputStream)stream);
        ReadWriteIOUtils.write((long)this.pushDownOffset, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.queryAllSensors, (OutputStream)stream);
    }

    public static AlignedSeriesScanNode deserialize(ByteBuffer byteBuffer) {
        AlignedPath alignedPath = (AlignedPath)PathDeserializeUtil.deserialize((ByteBuffer)byteBuffer);
        Ordering scanOrder = Ordering.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        byte isNull = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
        Expression pushDownPredicate = null;
        if (isNull == 1) {
            pushDownPredicate = Expression.deserialize(byteBuffer);
        }
        long limit = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        long offset = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        boolean queryAllSensors = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new AlignedSeriesScanNode(planNodeId, alignedPath, scanOrder, pushDownPredicate, limit, offset, null, queryAllSensors);
    }

    @Override
    public void serializeUseTemplate(DataOutputStream stream, TypeProvider typeProvider) throws IOException {
        PlanNodeType.ALIGNED_SERIES_SCAN.serialize(stream);
        this.id.serialize(stream);
        ReadWriteIOUtils.write((int)this.alignedPath.getNodes().length, (OutputStream)stream);
        for (String node : this.alignedPath.getNodes()) {
            ReadWriteIOUtils.write((String)node, (OutputStream)stream);
        }
    }

    public static AlignedSeriesScanNode deserializeUseTemplate(ByteBuffer byteBuffer, TypeProvider typeProvider) {
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        int nodeSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        String[] nodes = new String[nodeSize];
        for (int i = 0; i < nodeSize; ++i) {
            nodes[i] = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        }
        AlignedPath alignedPath = new AlignedPath(new PartialPath(nodes));
        alignedPath.setMeasurementList(typeProvider.getTemplatedInfo().getMeasurementList());
        alignedPath.addSchemas(typeProvider.getTemplatedInfo().getSchemaList());
        return new AlignedSeriesScanNode(planNodeId, alignedPath, typeProvider.getTemplatedInfo().getScanOrder(), typeProvider.getTemplatedInfo().getLimitValue(), typeProvider.getTemplatedInfo().getOffsetValue(), null, typeProvider.getTemplatedInfo().isQueryAllSensors());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AlignedSeriesScanNode that = (AlignedSeriesScanNode)o;
        return this.pushDownLimit == that.pushDownLimit && this.pushDownOffset == that.pushDownOffset && this.alignedPath.equals((Object)that.alignedPath) && this.scanOrder == that.scanOrder && Objects.equals(this.pushDownPredicate, that.pushDownPredicate) && Objects.equals(this.queryAllSensors, that.queryAllSensors) && Objects.equals(this.regionReplicaSet, that.regionReplicaSet);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.alignedPath, this.scanOrder, this.pushDownPredicate, this.pushDownLimit, this.pushDownOffset, this.regionReplicaSet, this.queryAllSensors});
    }

    public String toString() {
        return String.format("AlignedSeriesScanNode-%s:[SeriesPath: %s, DataRegion: %s]", this.getPlanNodeId(), this.getAlignedPath().getFormattedString(), PlanNodeUtil.printRegionReplicaSet(this.getRegionReplicaSet()));
    }

    @Override
    public PartialPath getPartitionPath() {
        return this.getAlignedPath();
    }
}

