/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.schematree.ClusterSchemaTree;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DataNodeSchemaCache;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.AutoCreateSchemaExecutor;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ClusterSchemaFetchExecutor;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaComputation;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaComputationWithAutoCreation;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.db.schemaengine.template.alter.TemplateExtendInfo;
import org.apache.iotdb.db.utils.EncodingInferenceUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Pair;

class TemplateSchemaFetcher {
    private final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final DataNodeSchemaCache templateSchemaCache;
    private final AutoCreateSchemaExecutor autoCreateSchemaExecutor;
    private final ClusterSchemaFetchExecutor clusterSchemaFetchExecutor;

    TemplateSchemaFetcher(DataNodeSchemaCache templateSchemaCache, AutoCreateSchemaExecutor autoCreateSchemaExecutor, ClusterSchemaFetchExecutor clusterSchemaFetchExecutor) {
        this.templateSchemaCache = templateSchemaCache;
        this.autoCreateSchemaExecutor = autoCreateSchemaExecutor;
        this.clusterSchemaFetchExecutor = clusterSchemaFetchExecutor;
    }

    List<Integer> processTemplateTimeSeries(Pair<Template, PartialPath> templateSetInfo, ISchemaComputationWithAutoCreation schemaComputationWithAutoCreation, MPPQueryContext context) {
        List<Integer> indexOfMissingMeasurements;
        PartialPath devicePath = schemaComputationWithAutoCreation.getDevicePath();
        String[] measurements = schemaComputationWithAutoCreation.getMeasurements();
        Template template = (Template)templateSetInfo.getLeft();
        ArrayList<String> extensionMeasurementList = new ArrayList<String>();
        ArrayList<TSDataType> extensionDataTypeList = new ArrayList<TSDataType>();
        for (int i = 0; i < measurements.length; ++i) {
            if (template.hasSchema(measurements[i])) continue;
            extensionMeasurementList.add(measurements[i]);
            extensionDataTypeList.add(schemaComputationWithAutoCreation.getDataType(i));
        }
        if (!extensionMeasurementList.isEmpty() && this.config.isAutoCreateSchemaEnabled()) {
            this.autoCreateSchemaExecutor.autoExtendTemplate(template.getName(), extensionMeasurementList, extensionDataTypeList, context);
        }
        if ((indexOfMissingMeasurements = this.templateSchemaCache.computeWithTemplate(schemaComputationWithAutoCreation)).isEmpty()) {
            return indexOfMissingMeasurements;
        }
        if (indexOfMissingMeasurements.size() < measurements.length) {
            return indexOfMissingMeasurements;
        }
        ClusterSchemaTree remoteSchemaTree = this.clusterSchemaFetchExecutor.fetchSchemaOfOneDevice(schemaComputationWithAutoCreation.getDevicePath(), schemaComputationWithAutoCreation.getMeasurements(), indexOfMissingMeasurements, context);
        indexOfMissingMeasurements = remoteSchemaTree.compute(schemaComputationWithAutoCreation, indexOfMissingMeasurements);
        if (indexOfMissingMeasurements.isEmpty()) {
            return indexOfMissingMeasurements;
        }
        if (this.config.isAutoCreateSchemaEnabled()) {
            ClusterSchemaTree schemaTree = new ClusterSchemaTree();
            this.autoCreateSchemaExecutor.autoActivateTemplate(schemaTree, devicePath, template.getId(), context);
            indexOfMissingMeasurements = schemaTree.compute(schemaComputationWithAutoCreation, indexOfMissingMeasurements);
        }
        return indexOfMissingMeasurements;
    }

    void processTemplateTimeSeries(List<Pair<Template, PartialPath>> templateSetInfoList, List<? extends ISchemaComputationWithAutoCreation> schemaComputationWithAutoCreationList, MPPQueryContext context) {
        List<Integer> indexOfMissingMeasurements;
        ISchemaComputationWithAutoCreation schemaComputationWithAutoCreation;
        int i;
        ArrayList<Integer> indexOfDevicesWithMissingMeasurements = new ArrayList<Integer>();
        ArrayList<List<Integer>> indexOfMissingMeasurementsList = new ArrayList<List<Integer>>(schemaComputationWithAutoCreationList.size());
        HashMap<String, TemplateExtendInfo> extensionMeasurementMap = new HashMap<String, TemplateExtendInfo>();
        int size = schemaComputationWithAutoCreationList.size();
        for (i = 0; i < size; ++i) {
            schemaComputationWithAutoCreation = schemaComputationWithAutoCreationList.get(i);
            Template template = (Template)templateSetInfoList.get((int)i).left;
            String[] measurements = schemaComputationWithAutoCreation.getMeasurements();
            for (int j = 0; j < measurements.length; ++j) {
                if (template.hasSchema(measurements[j])) continue;
                extensionMeasurementMap.computeIfAbsent(template.getName(), TemplateExtendInfo::new).addMeasurement(measurements[j], schemaComputationWithAutoCreation.getDataType(j), EncodingInferenceUtils.getDefaultEncoding(schemaComputationWithAutoCreation.getDataType(j)), TSFileDescriptor.getInstance().getConfig().getCompressor());
            }
        }
        if (!extensionMeasurementMap.isEmpty() && this.config.isAutoCreateSchemaEnabled()) {
            this.autoCreateSchemaExecutor.autoExtendTemplate(extensionMeasurementMap, context);
        }
        size = schemaComputationWithAutoCreationList.size();
        for (i = 0; i < size; ++i) {
            schemaComputationWithAutoCreation = schemaComputationWithAutoCreationList.get(i);
            indexOfMissingMeasurements = this.templateSchemaCache.computeWithTemplate(schemaComputationWithAutoCreation);
            if (indexOfMissingMeasurements.isEmpty()) continue;
            indexOfDevicesWithMissingMeasurements.add(i);
            indexOfMissingMeasurementsList.add(indexOfMissingMeasurements);
        }
        if (indexOfDevicesWithMissingMeasurements.isEmpty()) {
            return;
        }
        ClusterSchemaTree remoteSchemaTree = this.clusterSchemaFetchExecutor.fetchSchemaOfMultiDevices(schemaComputationWithAutoCreationList.stream().map(ISchemaComputation::getDevicePath).collect(Collectors.toList()), schemaComputationWithAutoCreationList.stream().map(ISchemaComputation::getMeasurements).collect(Collectors.toList()), indexOfDevicesWithMissingMeasurements, indexOfMissingMeasurementsList, context);
        ArrayList<Integer> indexOfDevicesNeedAutoCreateSchema = new ArrayList<Integer>();
        ArrayList<List<Integer>> indexOfMeasurementsNeedAutoCreate = new ArrayList<List<Integer>>();
        for (int i2 = 0; i2 < indexOfDevicesWithMissingMeasurements.size(); ++i2) {
            schemaComputationWithAutoCreation = schemaComputationWithAutoCreationList.get((Integer)indexOfDevicesWithMissingMeasurements.get(i2));
            indexOfMissingMeasurements = remoteSchemaTree.compute(schemaComputationWithAutoCreation, (List)indexOfMissingMeasurementsList.get(i2));
            if (indexOfMissingMeasurements.isEmpty()) continue;
            indexOfDevicesNeedAutoCreateSchema.add((Integer)indexOfDevicesWithMissingMeasurements.get(i2));
            indexOfMeasurementsNeedAutoCreate.add(indexOfMissingMeasurements);
        }
        if (indexOfDevicesNeedAutoCreateSchema.isEmpty()) {
            return;
        }
        if (this.config.isAutoCreateSchemaEnabled()) {
            ClusterSchemaTree schemaTree = new ClusterSchemaTree();
            this.autoCreateSchemaExecutor.autoActivateTemplate(schemaTree, indexOfDevicesNeedAutoCreateSchema.stream().map(index -> ((ISchemaComputationWithAutoCreation)schemaComputationWithAutoCreationList.get((int)index)).getDevicePath()).collect(Collectors.toList()), indexOfDevicesNeedAutoCreateSchema.stream().map(templateSetInfoList::get).collect(Collectors.toList()), context);
            indexOfDevicesWithMissingMeasurements = new ArrayList();
            indexOfMissingMeasurementsList = new ArrayList();
            for (int i3 = 0; i3 < indexOfDevicesNeedAutoCreateSchema.size(); ++i3) {
                schemaComputationWithAutoCreation = schemaComputationWithAutoCreationList.get((Integer)indexOfDevicesNeedAutoCreateSchema.get(i3));
                indexOfMissingMeasurements = schemaTree.compute(schemaComputationWithAutoCreation, (List)indexOfMeasurementsNeedAutoCreate.get(i3));
                if (indexOfMissingMeasurements.isEmpty()) continue;
                indexOfDevicesWithMissingMeasurements.add((Integer)indexOfDevicesNeedAutoCreateSchema.get(i3));
                indexOfMissingMeasurementsList.add(indexOfMissingMeasurements);
            }
            if (indexOfDevicesWithMissingMeasurements.isEmpty()) {
                return;
            }
        } else {
            indexOfDevicesWithMissingMeasurements = indexOfDevicesNeedAutoCreateSchema;
            indexOfMissingMeasurementsList = indexOfMeasurementsNeedAutoCreate;
        }
        for (int i4 = 0; i4 < indexOfDevicesWithMissingMeasurements.size(); ++i4) {
            schemaComputationWithAutoCreation = schemaComputationWithAutoCreationList.get((Integer)indexOfDevicesWithMissingMeasurements.get(i4));
            Iterator iterator = ((List)indexOfMissingMeasurementsList.get(i4)).iterator();
            while (iterator.hasNext()) {
                int index2 = (Integer)iterator.next();
                schemaComputationWithAutoCreation.computeMeasurement(index2, null);
            }
        }
    }
}

