/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.fill.linear;

import com.google.common.base.Preconditions;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.ILinearFill;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;

public abstract class LinearFill
implements ILinearFill {
    protected boolean previousIsNull = true;
    private long nextRowIndex = -1L;
    private long nextRowIndexInCurrentColumn = -1L;

    @Override
    public Column fill(TimeColumn timeColumn, Column valueColumn, long startRowIndex) {
        int size = valueColumn.getPositionCount();
        if (size == 0) {
            return valueColumn;
        }
        if (!valueColumn.mayHaveNull()) {
            this.previousIsNull = false;
            this.updatePreviousValue(valueColumn, valueColumn.getPositionCount() - 1);
            return valueColumn;
        }
        if (valueColumn instanceof RunLengthEncodedColumn) {
            return this.doWithAllNulls(startRowIndex, size, (Column)timeColumn, valueColumn);
        }
        Object array = this.createValueArray(size);
        boolean[] isNull = new boolean[size];
        boolean hasNullValue = false;
        for (int i = 0; i < size; ++i) {
            if (valueColumn.isNull(i)) {
                hasNullValue = this.fill(startRowIndex, i, isNull, valueColumn, array) || hasNullValue;
                continue;
            }
            this.fillValue(valueColumn, i, array);
            this.updatePreviousValue(valueColumn, i);
            this.previousIsNull = false;
        }
        return this.createFilledValueColumn(array, isNull, hasNullValue, size);
    }

    private Column doWithAllNulls(long startRowIndex, int size, Column timeColumn, Column valueColumn) {
        if (this.previousIsNull || this.nextRowIndex < startRowIndex) {
            return new RunLengthEncodedColumn(this.createNullValueColumn(), size);
        }
        this.prepareForNextValueInCurrentColumn(startRowIndex + (long)timeColumn.getPositionCount() - 1L, timeColumn.getPositionCount(), valueColumn);
        return new RunLengthEncodedColumn(this.createFilledValueColumn(), size);
    }

    private boolean fill(long startRowIndex, int i, boolean[] isNull, Column valueColumn, Object array) {
        long currentRowIndex = startRowIndex + (long)i;
        this.prepareForNextValueInCurrentColumn(currentRowIndex, i + 1, valueColumn);
        if (this.previousIsNull || this.nextIsNull(currentRowIndex)) {
            isNull[i] = true;
            return true;
        }
        this.fillValue(array, i);
        return false;
    }

    @Override
    public boolean needPrepareForNext(long rowIndex, Column valueColumn) {
        return this.nextRowIndex < rowIndex && valueColumn.isNull(valueColumn.getPositionCount() - 1);
    }

    @Override
    public boolean prepareForNext(long startRowIndex, long endRowIndex, TimeColumn nextTimeColumn, Column nextValueColumn) {
        Preconditions.checkArgument((nextTimeColumn.getPositionCount() > 0 && endRowIndex < startRowIndex ? 1 : 0) != 0, (Object)"nextColumn's time should be greater than current time");
        if (endRowIndex <= this.nextRowIndex) {
            return true;
        }
        for (int i = 0; i < nextValueColumn.getPositionCount(); ++i) {
            if (nextValueColumn.isNull(i)) continue;
            this.updateNextValue(nextValueColumn, i);
            this.nextRowIndex = startRowIndex + (long)i;
            return true;
        }
        return false;
    }

    private boolean nextIsNull(long rowIndex) {
        return this.nextRowIndexInCurrentColumn <= rowIndex;
    }

    private void prepareForNextValueInCurrentColumn(long currentRowIndex, int startIndex, Column valueColumn) {
        if (currentRowIndex <= this.nextRowIndexInCurrentColumn) {
            return;
        }
        for (int i = startIndex; i < valueColumn.getPositionCount(); ++i) {
            if (valueColumn.isNull(i)) continue;
            this.nextRowIndexInCurrentColumn = currentRowIndex + (long)(i - startIndex + 1);
            this.updateNextValueInCurrentColumn(valueColumn, i);
            return;
        }
        this.nextRowIndexInCurrentColumn = this.nextRowIndex;
        this.updateNextValueInCurrentColumn();
    }

    abstract void fillValue(Column var1, int var2, Object var3);

    abstract void fillValue(Object var1, int var2);

    abstract Object createValueArray(int var1);

    abstract Column createNullValueColumn();

    abstract Column createFilledValueColumn();

    abstract Column createFilledValueColumn(Object var1, boolean[] var2, boolean var3, int var4);

    abstract void updatePreviousValue(Column var1, int var2);

    abstract void updateNextValue(Column var1, int var2);

    abstract void updateNextValueInCurrentColumn(Column var1, int var2);

    abstract void updateNextValueInCurrentColumn();
}

