/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.exchange.sink;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.mpp.rpc.thrift.TFragmentInstanceId;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class DownStreamChannelLocation {
    private TEndPoint remoteEndpoint;
    private TFragmentInstanceId remoteFragmentInstanceId;
    private final String remotePlanNodeId;

    public DownStreamChannelLocation(TEndPoint remoteEndpoint, TFragmentInstanceId remoteFragmentInstanceId, String remotePlanNodeId) {
        this.remoteEndpoint = remoteEndpoint;
        this.remoteFragmentInstanceId = remoteFragmentInstanceId;
        this.remotePlanNodeId = remotePlanNodeId;
    }

    public DownStreamChannelLocation(String remotePlanNodeId) {
        this.remoteEndpoint = null;
        this.remoteFragmentInstanceId = null;
        this.remotePlanNodeId = remotePlanNodeId;
    }

    public void setRemoteEndpoint(TEndPoint remoteEndpoint) {
        this.remoteEndpoint = remoteEndpoint;
    }

    public void setRemoteFragmentInstanceId(TFragmentInstanceId remoteFragmentInstanceId) {
        this.remoteFragmentInstanceId = remoteFragmentInstanceId;
    }

    public TEndPoint getRemoteEndpoint() {
        return this.remoteEndpoint;
    }

    public TFragmentInstanceId getRemoteFragmentInstanceId() {
        return this.remoteFragmentInstanceId;
    }

    public String getRemotePlanNodeId() {
        return this.remotePlanNodeId;
    }

    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((String)this.remoteEndpoint.getIp(), (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.remoteEndpoint.getPort(), (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((String)this.remoteFragmentInstanceId.getQueryId(), (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.remoteFragmentInstanceId.getFragmentId(), (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((String)this.remoteFragmentInstanceId.getInstanceId(), (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((String)this.remotePlanNodeId, (ByteBuffer)byteBuffer);
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((String)this.remoteEndpoint.getIp(), (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.remoteEndpoint.getPort(), (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.remoteFragmentInstanceId.getQueryId(), (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.remoteFragmentInstanceId.getFragmentId(), (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.remoteFragmentInstanceId.getInstanceId(), (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.remotePlanNodeId, (OutputStream)stream);
    }

    public static DownStreamChannelLocation deserialize(ByteBuffer byteBuffer) {
        TEndPoint endPoint = new TEndPoint(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer), ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer));
        TFragmentInstanceId fragmentInstanceId = new TFragmentInstanceId(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer), ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer), ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        String remotePlanNodeId = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        return new DownStreamChannelLocation(endPoint, fragmentInstanceId, remotePlanNodeId);
    }
}

