/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.driver;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.db.queryengine.execution.exchange.sink.ISink;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.source.ExchangeOperator;
import org.apache.iotdb.db.queryengine.execution.schedule.task.DriverTaskId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;

public class DriverContext {
    private boolean inputDriver = true;
    private DriverTaskId driverTaskID;
    private final FragmentInstanceContext fragmentInstanceContext;
    private final List<OperatorContext> operatorContexts = new ArrayList<OperatorContext>();
    private ISink sink;
    private int dependencyDriverIndex = -1;
    private ExchangeOperator downstreamOperator;
    private final AtomicBoolean finished = new AtomicBoolean();
    private boolean mayHaveTmpFile = false;

    public DriverContext() {
        this.fragmentInstanceContext = null;
    }

    public DriverContext(FragmentInstanceContext fragmentInstanceContext, int pipelineId) {
        this.fragmentInstanceContext = fragmentInstanceContext;
        this.driverTaskID = new DriverTaskId(fragmentInstanceContext.getId(), pipelineId);
    }

    public OperatorContext addOperatorContext(int operatorId, PlanNodeId planNodeId, String operatorType) {
        OperatorContext operatorContext = new OperatorContext(operatorId, planNodeId, operatorType, this);
        this.operatorContexts.add(operatorContext);
        return operatorContext;
    }

    public DriverContext createSubDriverContext(int pipelineId) {
        throw new UnsupportedOperationException();
    }

    public void setDependencyDriverIndex(int dependencyDriverIndex) {
        this.dependencyDriverIndex = dependencyDriverIndex;
    }

    public int getDependencyDriverIndex() {
        return this.dependencyDriverIndex;
    }

    public void setDownstreamOperator(ExchangeOperator downstreamOperator) {
        this.downstreamOperator = downstreamOperator;
    }

    public ExchangeOperator getDownstreamOperator() {
        return this.downstreamOperator;
    }

    public void setSink(ISink sink) {
        this.sink = sink;
    }

    public ISink getSink() {
        return this.sink;
    }

    public boolean isInputDriver() {
        return this.inputDriver;
    }

    public void setInputDriver(boolean inputDriver) {
        this.inputDriver = inputDriver;
    }

    public List<OperatorContext> getOperatorContexts() {
        return this.operatorContexts;
    }

    public int getPipelineId() {
        return this.driverTaskID.getPipelineId();
    }

    public DriverTaskId getDriverTaskID() {
        return this.driverTaskID;
    }

    public void setDriverTaskID(DriverTaskId driverTaskID) {
        this.driverTaskID = driverTaskID;
    }

    public FragmentInstanceContext getFragmentInstanceContext() {
        return this.fragmentInstanceContext;
    }

    public void failed(Throwable cause) {
        this.fragmentInstanceContext.failed(cause);
        this.finished.set(true);
    }

    public void finished() {
        this.finished.compareAndSet(false, true);
    }

    public boolean isDone() {
        return this.finished.get();
    }

    public void setHaveTmpFile(boolean mayHaveTmpFile) {
        this.mayHaveTmpFile = mayHaveTmpFile;
    }

    public boolean mayHaveTmpFile() {
        return this.mayHaveTmpFile;
    }
}

