/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.consensus.statemachine.schemaregion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpression;
import org.apache.iotdb.db.exception.metadata.MeasurementAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.template.TemplateIsInUseException;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.ActivateTemplateNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.AlterTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.BatchActivateTemplateNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.ConstructSchemaBlackListNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.CreateAlignedTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.CreateMultiTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.CreateTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.DeactivateTemplateNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.DeleteTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.InternalBatchActivateTemplateNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.InternalCreateMultiTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.InternalCreateTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.MeasurementGroup;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.PreDeactivateTemplateNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.RollbackPreDeactivateTemplateNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.RollbackSchemaBlackListNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.view.AlterLogicalViewNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.view.ConstructLogicalViewBlackListNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.view.CreateLogicalViewNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.view.DeleteLogicalViewNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.view.RollbackLogicalViewBlackListNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.pipe.PipeEnrichedConfigSchemaNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.pipe.PipeEnrichedWriteSchemaNode;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.ICreateAlignedTimeSeriesPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.ICreateTimeSeriesPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.SchemaRegionWritePlanFactory;
import org.apache.iotdb.db.schemaengine.template.ClusterTemplateManager;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaExecutionVisitor
extends PlanVisitor<TSStatus, ISchemaRegion> {
    private static final Logger logger = LoggerFactory.getLogger(SchemaExecutionVisitor.class);

    @Override
    public TSStatus visitCreateTimeSeries(CreateTimeSeriesNode node, ISchemaRegion schemaRegion) {
        try {
            schemaRegion.createTimeseries(node, -1L);
        }
        catch (MetadataException e) {
            logger.error("{}: MetaData error: ", (Object)"IoTDB", (Object)e);
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute successfully");
    }

    @Override
    public TSStatus visitCreateAlignedTimeSeries(CreateAlignedTimeSeriesNode node, ISchemaRegion schemaRegion) {
        try {
            schemaRegion.createAlignedTimeSeries(node);
        }
        catch (MetadataException e) {
            logger.error("{}: MetaData error: ", (Object)"IoTDB", (Object)e);
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute successfully");
    }

    @Override
    public TSStatus visitCreateMultiTimeSeries(CreateMultiTimeSeriesNode node, ISchemaRegion schemaRegion) {
        Map<PartialPath, MeasurementGroup> measurementGroupMap = node.getMeasurementGroupMap();
        ArrayList<TSStatus> failingStatus = new ArrayList<TSStatus>();
        for (Map.Entry<PartialPath, MeasurementGroup> entry : measurementGroupMap.entrySet()) {
            PartialPath devicePath = entry.getKey();
            MeasurementGroup measurementGroup = entry.getValue();
            int size = measurementGroup.getMeasurements().size();
            for (int i = 0; i < size; ++i) {
                try {
                    schemaRegion.createTimeseries(this.transformToCreateTimeSeriesPlan(devicePath, measurementGroup, i), -1L);
                    continue;
                }
                catch (MetadataException e) {
                    logger.error("{}: MetaData error: ", (Object)"IoTDB", (Object)e);
                    failingStatus.add(RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
                }
            }
        }
        if (!failingStatus.isEmpty()) {
            return RpcUtils.getStatus(failingStatus);
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute successfully");
    }

    private ICreateTimeSeriesPlan transformToCreateTimeSeriesPlan(PartialPath devicePath, MeasurementGroup measurementGroup, int index) {
        return SchemaRegionWritePlanFactory.getCreateTimeSeriesPlan(devicePath.concatNode(measurementGroup.getMeasurements().get(index)), measurementGroup.getDataTypes().get(index), measurementGroup.getEncodings().get(index), measurementGroup.getCompressors().get(index), measurementGroup.getPropsList() == null ? null : measurementGroup.getPropsList().get(index), measurementGroup.getTagsList() == null ? null : measurementGroup.getTagsList().get(index), measurementGroup.getAttributesList() == null ? null : measurementGroup.getAttributesList().get(index), measurementGroup.getAliasList() == null ? null : measurementGroup.getAliasList().get(index));
    }

    @Override
    public TSStatus visitInternalCreateTimeSeries(InternalCreateTimeSeriesNode node, ISchemaRegion schemaRegion) {
        PartialPath devicePath = node.getDevicePath();
        MeasurementGroup measurementGroup = node.getMeasurementGroup();
        ArrayList<TSStatus> alreadyExistingTimeseries = new ArrayList<TSStatus>();
        ArrayList<TSStatus> failingStatus = new ArrayList<TSStatus>();
        if (node.isAligned()) {
            this.executeInternalCreateAlignedTimeseries(devicePath, measurementGroup, schemaRegion, alreadyExistingTimeseries, failingStatus);
        } else {
            this.executeInternalCreateTimeseries(devicePath, measurementGroup, schemaRegion, alreadyExistingTimeseries, failingStatus);
        }
        if (!failingStatus.isEmpty()) {
            return RpcUtils.getStatus(failingStatus);
        }
        if (!alreadyExistingTimeseries.isEmpty()) {
            return RpcUtils.getStatus(alreadyExistingTimeseries);
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute successfully");
    }

    @Override
    public TSStatus visitInternalCreateMultiTimeSeries(InternalCreateMultiTimeSeriesNode node, ISchemaRegion schemaRegion) {
        ArrayList<TSStatus> alreadyExistingTimeseries = new ArrayList<TSStatus>();
        ArrayList<TSStatus> failingStatus = new ArrayList<TSStatus>();
        for (Map.Entry<PartialPath, Pair<Boolean, MeasurementGroup>> deviceEntry : node.getDeviceMap().entrySet()) {
            PartialPath devicePath = deviceEntry.getKey();
            MeasurementGroup measurementGroup = (MeasurementGroup)deviceEntry.getValue().right;
            if (((Boolean)deviceEntry.getValue().left).booleanValue()) {
                this.executeInternalCreateAlignedTimeseries(devicePath, measurementGroup, schemaRegion, alreadyExistingTimeseries, failingStatus);
                continue;
            }
            this.executeInternalCreateTimeseries(devicePath, measurementGroup, schemaRegion, alreadyExistingTimeseries, failingStatus);
        }
        if (!failingStatus.isEmpty()) {
            return RpcUtils.getStatus(failingStatus);
        }
        if (!alreadyExistingTimeseries.isEmpty()) {
            return RpcUtils.getStatus(alreadyExistingTimeseries);
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute successfully");
    }

    private void executeInternalCreateTimeseries(PartialPath devicePath, MeasurementGroup measurementGroup, ISchemaRegion schemaRegion, List<TSStatus> alreadyExistingTimeseries, List<TSStatus> failingStatus) {
        int size = measurementGroup.getMeasurements().size();
        for (int i = 0; i < size; ++i) {
            try {
                schemaRegion.createTimeseries(this.transformToCreateTimeSeriesPlan(devicePath, measurementGroup, i), -1L);
                continue;
            }
            catch (MeasurementAlreadyExistException e) {
                alreadyExistingTimeseries.add(RpcUtils.getStatus((int)e.getErrorCode(), (String)MeasurementPath.transformDataToString((MeasurementPath)e.getMeasurementPath())));
                continue;
            }
            catch (MetadataException e) {
                logger.warn("{}: MetaData error: ", (Object)e.getMessage(), (Object)e);
                failingStatus.add(RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
            }
        }
    }

    private void executeInternalCreateAlignedTimeseries(PartialPath devicePath, MeasurementGroup measurementGroup, ISchemaRegion schemaRegion, List<TSStatus> alreadyExistingTimeseries, List<TSStatus> failingStatus) {
        List<String> measurementList = measurementGroup.getMeasurements();
        List<TSDataType> dataTypeList = measurementGroup.getDataTypes();
        List<TSEncoding> encodingList = measurementGroup.getEncodings();
        List<CompressionType> compressionTypeList = measurementGroup.getCompressors();
        ICreateAlignedTimeSeriesPlan createAlignedTimeSeriesPlan = SchemaRegionWritePlanFactory.getCreateAlignedTimeSeriesPlan(devicePath, measurementList, dataTypeList, encodingList, compressionTypeList, null, null, null);
        boolean shouldRetry = true;
        while (shouldRetry) {
            try {
                schemaRegion.createAlignedTimeSeries(createAlignedTimeSeriesPlan);
                shouldRetry = false;
            }
            catch (MeasurementAlreadyExistException e) {
                MeasurementPath measurementPath = e.getMeasurementPath();
                alreadyExistingTimeseries.add(RpcUtils.getStatus((int)e.getErrorCode(), (String)MeasurementPath.transformDataToString((MeasurementPath)e.getMeasurementPath())));
                int index = measurementList.indexOf(measurementPath.getMeasurement());
                measurementList.remove(index);
                dataTypeList.remove(index);
                encodingList.remove(index);
                compressionTypeList.remove(index);
                if (!measurementList.isEmpty()) continue;
                shouldRetry = false;
            }
            catch (MetadataException e) {
                logger.warn("{}: MetaData error: ", (Object)e.getMessage(), (Object)e);
                failingStatus.add(RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
                shouldRetry = false;
            }
        }
    }

    @Override
    public TSStatus visitAlterTimeSeries(AlterTimeSeriesNode node, ISchemaRegion schemaRegion) {
        try {
            switch (node.getAlterType()) {
                case RENAME: {
                    String beforeName = node.getAlterMap().keySet().iterator().next();
                    String currentName = node.getAlterMap().get(beforeName);
                    schemaRegion.renameTagOrAttributeKey(beforeName, currentName, node.getPath());
                    break;
                }
                case SET: {
                    schemaRegion.setTagsOrAttributesValue(node.getAlterMap(), node.getPath());
                    break;
                }
                case DROP: {
                    schemaRegion.dropTagsOrAttributes(node.getAlterMap().keySet(), node.getPath());
                    break;
                }
                case ADD_TAGS: {
                    schemaRegion.addTags(node.getAlterMap(), node.getPath());
                    break;
                }
                case ADD_ATTRIBUTES: {
                    schemaRegion.addAttributes(node.getAlterMap(), node.getPath());
                    break;
                }
                case UPSERT: {
                    schemaRegion.upsertAliasAndTagsAndAttributes(node.getAlias(), node.getTagsMap(), node.getAttributesMap(), node.getPath());
                }
            }
        }
        catch (MetadataException e) {
            logger.error("{}: MetaData error: ", (Object)"IoTDB", (Object)e);
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
        catch (IOException e) {
            logger.error("{}: IO error: ", (Object)"IoTDB", (Object)e);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)e.getMessage());
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute successfully");
    }

    @Override
    public TSStatus visitActivateTemplate(ActivateTemplateNode node, ISchemaRegion schemaRegion) {
        try {
            Template template = ClusterTemplateManager.getInstance().getTemplate(node.getTemplateId());
            schemaRegion.activateSchemaTemplate(node, template);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        }
        catch (MetadataException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
    }

    @Override
    public TSStatus visitBatchActivateTemplate(BatchActivateTemplateNode node, ISchemaRegion schemaRegion) {
        for (Map.Entry<PartialPath, Pair<Integer, Integer>> entry : node.getTemplateActivationMap().entrySet()) {
            Template template = ClusterTemplateManager.getInstance().getTemplate((Integer)entry.getValue().left);
            try {
                schemaRegion.activateSchemaTemplate(SchemaRegionWritePlanFactory.getActivateTemplateInClusterPlan(entry.getKey(), (Integer)entry.getValue().right, (Integer)entry.getValue().left), template);
            }
            catch (MetadataException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
            }
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    @Override
    public TSStatus visitInternalBatchActivateTemplate(InternalBatchActivateTemplateNode node, ISchemaRegion schemaRegion) {
        for (Map.Entry<PartialPath, Pair<Integer, Integer>> entry : node.getTemplateActivationMap().entrySet()) {
            Template template = ClusterTemplateManager.getInstance().getTemplate((Integer)entry.getValue().left);
            try {
                schemaRegion.activateSchemaTemplate(SchemaRegionWritePlanFactory.getActivateTemplateInClusterPlan(entry.getKey(), (Integer)entry.getValue().right, (Integer)entry.getValue().left), template);
            }
            catch (TemplateIsInUseException e) {
                logger.info(String.format("Device Template has already been activated on path %s, there's no need to activate again.", entry.getKey()));
            }
            catch (MetadataException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
            }
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    @Override
    public TSStatus visitConstructSchemaBlackList(ConstructSchemaBlackListNode node, ISchemaRegion schemaRegion) {
        try {
            long preDeletedNum = schemaRegion.constructSchemaBlackList(node.getPatternTree());
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)String.valueOf(preDeletedNum));
        }
        catch (MetadataException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
    }

    @Override
    public TSStatus visitRollbackSchemaBlackList(RollbackSchemaBlackListNode node, ISchemaRegion schemaRegion) {
        try {
            schemaRegion.rollbackSchemaBlackList(node.getPatternTree());
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        }
        catch (MetadataException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
    }

    @Override
    public TSStatus visitDeleteTimeseries(DeleteTimeSeriesNode node, ISchemaRegion schemaRegion) {
        try {
            schemaRegion.deleteTimeseriesInBlackList(node.getPatternTree());
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        }
        catch (MetadataException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
    }

    @Override
    public TSStatus visitPreDeactivateTemplate(PreDeactivateTemplateNode node, ISchemaRegion schemaRegion) {
        try {
            long preDeactivateNum = schemaRegion.constructSchemaBlackListWithTemplate(node);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)String.valueOf(preDeactivateNum));
        }
        catch (MetadataException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
    }

    @Override
    public TSStatus visitRollbackPreDeactivateTemplate(RollbackPreDeactivateTemplateNode node, ISchemaRegion schemaRegion) {
        try {
            schemaRegion.rollbackSchemaBlackListWithTemplate(node);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        }
        catch (MetadataException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
    }

    @Override
    public TSStatus visitDeactivateTemplate(DeactivateTemplateNode node, ISchemaRegion schemaRegion) {
        try {
            schemaRegion.deactivateTemplateInBlackList(node);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        }
        catch (MetadataException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
    }

    @Override
    public TSStatus visitCreateLogicalView(CreateLogicalViewNode node, ISchemaRegion schemaRegion) {
        Map<PartialPath, ViewExpression> viewPathToSourceMap = node.getViewPathToSourceExpressionMap();
        ArrayList<TSStatus> failingStatus = new ArrayList<TSStatus>();
        for (Map.Entry<PartialPath, ViewExpression> entry : viewPathToSourceMap.entrySet()) {
            try {
                schemaRegion.createLogicalView(SchemaRegionWritePlanFactory.getCreateLogicalViewPlan(entry.getKey(), entry.getValue()));
            }
            catch (MetadataException e) {
                logger.error("{}: MetaData error: ", (Object)"IoTDB", (Object)e);
                failingStatus.add(RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
            }
        }
        if (!failingStatus.isEmpty()) {
            return RpcUtils.getStatus(failingStatus);
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute successfully");
    }

    @Override
    public TSStatus visitAlterLogicalView(AlterLogicalViewNode node, ISchemaRegion schemaRegion) {
        Map<PartialPath, ViewExpression> viewPathToSourceMap = node.getViewPathToSourceMap();
        ArrayList<TSStatus> failingStatus = new ArrayList<TSStatus>();
        for (Map.Entry<PartialPath, ViewExpression> entry : viewPathToSourceMap.entrySet()) {
            try {
                schemaRegion.alterLogicalView(SchemaRegionWritePlanFactory.getAlterLogicalViewPlan(entry.getKey(), entry.getValue()));
            }
            catch (MetadataException e) {
                logger.warn("{}: MetaData error: ", (Object)"IoTDB", (Object)e);
                failingStatus.add(RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
            }
        }
        if (!failingStatus.isEmpty()) {
            return RpcUtils.getStatus(failingStatus);
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute successfully");
    }

    @Override
    public TSStatus visitConstructLogicalViewBlackList(ConstructLogicalViewBlackListNode node, ISchemaRegion schemaRegion) {
        try {
            long preDeletedNum = schemaRegion.constructLogicalViewBlackList(node.getPatternTree());
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)String.valueOf(preDeletedNum));
        }
        catch (MetadataException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
    }

    @Override
    public TSStatus visitRollbackLogicalViewBlackList(RollbackLogicalViewBlackListNode node, ISchemaRegion schemaRegion) {
        try {
            schemaRegion.rollbackLogicalViewBlackList(node.getPatternTree());
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        }
        catch (MetadataException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
    }

    @Override
    public TSStatus visitDeleteLogicalView(DeleteLogicalViewNode node, ISchemaRegion schemaRegion) {
        try {
            schemaRegion.deleteLogicalView(node.getPatternTree());
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        }
        catch (MetadataException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
    }

    @Override
    public TSStatus visitPipeEnrichedWriteSchema(PipeEnrichedWriteSchemaNode node, ISchemaRegion schemaRegion) {
        return node.getWriteSchemaNode().accept(this, schemaRegion);
    }

    @Override
    public TSStatus visitPipeEnrichedConfigSchema(PipeEnrichedConfigSchemaNode node, ISchemaRegion schemaRegion) {
        return node.getConfigSchemaNode().accept(this, schemaRegion);
    }

    @Override
    public TSStatus visitPlan(PlanNode node, ISchemaRegion context) {
        return null;
    }
}

