/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.jdbc;

import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.jdbc.Config;
import org.apache.iotdb.jdbc.IoTDBConnectionParams;
import org.apache.iotdb.jdbc.IoTDBDatabaseMetadata;
import org.apache.iotdb.jdbc.IoTDBPreparedStatement;
import org.apache.iotdb.jdbc.IoTDBSQLException;
import org.apache.iotdb.jdbc.IoTDBStatement;
import org.apache.iotdb.jdbc.IoTDBURLException;
import org.apache.iotdb.jdbc.Utils;
import org.apache.iotdb.jdbc.relational.IoTDBRelationalDatabaseMetadata;
import org.apache.iotdb.rpc.DeepCopyRpcTransportFactory;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.service.rpc.thrift.IClientRPCService;
import org.apache.iotdb.service.rpc.thrift.ServerProperties;
import org.apache.iotdb.service.rpc.thrift.TSCloseSessionReq;
import org.apache.iotdb.service.rpc.thrift.TSOpenSessionReq;
import org.apache.iotdb.service.rpc.thrift.TSOpenSessionResp;
import org.apache.iotdb.service.rpc.thrift.TSProtocolVersion;
import org.apache.iotdb.service.rpc.thrift.TSSetTimeZoneReq;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBConnection
implements Connection {
    private static final Logger logger = LoggerFactory.getLogger(IoTDBConnection.class);
    private static final TSProtocolVersion protocolVersion = TSProtocolVersion.IOTDB_SERVICE_PROTOCOL_V3;
    private static final String NOT_SUPPORT_PREPARE_CALL = "Does not support prepareCall";
    private static final String NOT_SUPPORT_PREPARE_STATEMENT = "Does not support prepareStatement";
    private IClientRPCService.Iface client = null;
    private long sessionId = -1L;
    private IoTDBConnectionParams params;
    private boolean isClosed = true;
    private SQLWarning warningChain = null;
    private TTransport transport;
    private int queryTimeout = 0;
    private int networkTimeout = 0;
    private ZoneId zoneId;
    private Charset charset;
    private boolean autoCommit;
    private String url;
    private String userName;
    private int timeFactor = 1000;

    public String getUserName() {
        return this.userName;
    }

    public String getSqlDialect() {
        if (this.params != null && StringUtils.isNotBlank((CharSequence)this.params.getSqlDialect())) {
            return this.params.getSqlDialect();
        }
        return "tree";
    }

    public IoTDBConnection() {
    }

    public IoTDBConnection(String url, Properties info) throws SQLException, TTransportException {
        if (url == null) {
            throw new IoTDBURLException("Input url cannot be null");
        }
        this.params = Utils.parseUrl(url, info);
        this.url = url;
        this.userName = info.get("user").toString();
        this.networkTimeout = this.params.getNetworkTimeout();
        this.zoneId = ZoneId.of(this.params.getTimeZone());
        this.charset = this.params.getCharset();
        this.openTransport();
        if (Config.rpcThriftCompressionEnable) {
            this.setClient((IClientRPCService.Iface)new IClientRPCService.Client((TProtocol)new TCompactProtocol(this.transport)));
        } else {
            this.setClient((IClientRPCService.Iface)new IClientRPCService.Client((TProtocol)new TBinaryProtocol(this.transport)));
        }
        this.openSession();
        this.setClient(RpcUtils.newSynchronizedClient((IClientRPCService.Iface)this.getClient()));
        this.autoCommit = false;
    }

    public String getUrl() {
        return this.url;
    }

    public IoTDBConnectionParams getParams() {
        return this.params;
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        throw new SQLException("Does not support isWrapperFor");
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        throw new SQLException("Does not support unwrap");
    }

    @Override
    public void abort(Executor arg0) throws SQLException {
        throw new SQLException("Does not support abort");
    }

    @Override
    public void clearWarnings() {
        this.warningChain = null;
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        TSCloseSessionReq req = new TSCloseSessionReq(this.sessionId);
        try {
            this.getClient().closeSession(req);
        }
        catch (TException e) {
            throw new SQLException("Error occurs when closing session at server. Maybe server is down.", e);
        }
        finally {
            this.isClosed = true;
            if (this.transport != null) {
                this.transport.close();
            }
        }
    }

    @Override
    public void commit() throws SQLException {
    }

    @Override
    public Array createArrayOf(String arg0, Object[] arg1) throws SQLException {
        throw new SQLException("Does not support createArrayOf");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLException("Does not support createBlob");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLException("Does not support createClob");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLException("Does not suppport createNClob");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLException("Does not support createSQLXML");
    }

    @Override
    public Statement createStatement() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Cannot create statement because connection is closed");
        }
        return new IoTDBStatement(this, this.getClient(), this.sessionId, this.zoneId, this.charset, this.queryTimeout);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (resultSetConcurrency != 1007) {
            throw new SQLException(String.format("Statements with result set concurrency %d are not supported", resultSetConcurrency));
        }
        if (resultSetType == 1005) {
            throw new SQLException(String.format("Statements with ResultSet type %d are not supported", resultSetType));
        }
        return new IoTDBStatement(this, this.getClient(), this.sessionId, this.zoneId, this.charset, this.queryTimeout);
    }

    @Override
    public Statement createStatement(int arg0, int arg1, int arg2) throws SQLException {
        throw new SQLException("Does not support createStatement");
    }

    @Override
    public Struct createStruct(String arg0, Object[] arg1) throws SQLException {
        throw new SQLException("Does not support createStruct");
    }

    @Override
    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    @Override
    public void setAutoCommit(boolean arg0) {
        this.autoCommit = arg0;
    }

    @Override
    public String getCatalog() {
        return "Apache IoTDB";
    }

    @Override
    public void setCatalog(String arg0) throws SQLException {
        throw new SQLException("Does not support setCatalog");
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new SQLException("Does not support getClientInfo");
    }

    @Override
    public void setClientInfo(Properties arg0) throws SQLClientInfoException {
        throw new SQLClientInfoException("Does not support setClientInfo", null);
    }

    @Override
    public String getClientInfo(String arg0) throws SQLException {
        throw new SQLException("Does not support getClientInfo");
    }

    @Override
    public int getHoldability() {
        return 0;
    }

    @Override
    public void setHoldability(int arg0) throws SQLException {
        throw new SQLException("Does not support setHoldability");
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Cannot create statement because connection is closed");
        }
        if (this.getSqlDialect().equals("table")) {
            return new IoTDBRelationalDatabaseMetadata(this, this.getClient(), this.sessionId, this.zoneId);
        }
        return new IoTDBDatabaseMetadata(this, this.getClient(), this.sessionId, this.zoneId);
    }

    @Override
    public int getNetworkTimeout() {
        return this.networkTimeout;
    }

    @Override
    public String getSchema() throws SQLException {
        if (this.getSqlDialect().equals("table")) {
            return this.getDatabase();
        }
        throw new SQLException("Does not support getSchema");
    }

    @Override
    public void setSchema(String arg0) throws SQLException {
        if (this.getSqlDialect().equals("table")) {
            for (String str : IoTDBRelationalDatabaseMetadata.allIotdbTableSQLKeywords) {
                if (!arg0.equalsIgnoreCase(str)) continue;
                arg0 = "\"" + arg0 + "\"";
            }
            Statement stmt = this.createStatement();
            String sql = "USE " + arg0;
            try {
                boolean rs = stmt.execute(sql);
            }
            catch (SQLException e) {
                stmt.close();
                logger.error("Use database error: {}", (Object)e.getMessage());
                throw e;
            }
        }
    }

    @Override
    public int getTransactionIsolation() {
        return 0;
    }

    @Override
    public void setTransactionIsolation(int arg0) throws SQLException {
        throw new SQLException("Does not support setTransactionIsolation");
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new SQLException("Does not support getTypeMap");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> arg0) throws SQLException {
        throw new SQLException("Does not support setTypeMap");
    }

    @Override
    public SQLWarning getWarnings() {
        return this.warningChain;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void setReadOnly(boolean readonly) throws SQLException {
        if (readonly) {
            throw new SQLException("Does not support readOnly");
        }
    }

    @Override
    public boolean isValid(int arg0) {
        return !this.isClosed;
    }

    @Override
    public String nativeSQL(String arg0) throws SQLException {
        throw new SQLException("Does not support nativeSQL");
    }

    @Override
    public CallableStatement prepareCall(String arg0) throws SQLException {
        throw new SQLException(NOT_SUPPORT_PREPARE_CALL);
    }

    @Override
    public CallableStatement prepareCall(String arg0, int arg1, int arg2) throws SQLException {
        throw new SQLException(NOT_SUPPORT_PREPARE_CALL);
    }

    @Override
    public CallableStatement prepareCall(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        throw new SQLException(NOT_SUPPORT_PREPARE_CALL);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new IoTDBPreparedStatement(this, this.getClient(), (Long)this.sessionId, sql, this.zoneId, this.charset);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException(NOT_SUPPORT_PREPARE_STATEMENT);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException(NOT_SUPPORT_PREPARE_STATEMENT);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new SQLException(NOT_SUPPORT_PREPARE_STATEMENT);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLException(NOT_SUPPORT_PREPARE_STATEMENT);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLException(NOT_SUPPORT_PREPARE_STATEMENT);
    }

    @Override
    public void releaseSavepoint(Savepoint arg0) throws SQLException {
        throw new SQLException("Does not support releaseSavepoint");
    }

    @Override
    public void rollback() {
    }

    @Override
    public void rollback(Savepoint arg0) {
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        if (name.equalsIgnoreCase("time_zone")) {
            try {
                this.setTimeZone(value);
            }
            catch (IoTDBSQLException | TException e) {
                throw new SQLClientInfoException("Set time_zone error: ", null, e);
            }
        } else {
            HashMap<String, ClientInfoStatus> hashMap = new HashMap<String, ClientInfoStatus>();
            hashMap.put(name, ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
            throw new SQLClientInfoException("Does not support this type of client info: ", hashMap);
        }
    }

    @Override
    public void setNetworkTimeout(Executor arg0, int arg1) throws SQLException {
        throw new SQLException("Does not support setNetworkTimeout");
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            throw new SQLException(String.format("queryTimeout %d must be >= 0!", seconds));
        }
        this.queryTimeout = seconds;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLException("Does not support setSavepoint");
    }

    @Override
    public Savepoint setSavepoint(String arg0) throws SQLException {
        throw new SQLException("Does not support setSavepoint");
    }

    public IClientRPCService.Iface getClient() {
        return this.client;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public void setClient(IClientRPCService.Iface client) {
        this.client = client;
    }

    private void openTransport() throws TTransportException {
        DeepCopyRpcTransportFactory.setDefaultBufferCapacity((int)this.params.getThriftDefaultBufferSize());
        DeepCopyRpcTransportFactory.setThriftMaxFrameSize((int)this.params.getThriftMaxFrameSize());
        this.transport = this.params.isUseSSL() ? DeepCopyRpcTransportFactory.INSTANCE.getTransport(this.params.getHost(), this.params.getPort(), this.getNetworkTimeout(), this.params.getTrustStore(), this.params.getTrustStorePwd()) : DeepCopyRpcTransportFactory.INSTANCE.getTransport(this.params.getHost(), this.params.getPort(), this.getNetworkTimeout());
        if (!this.transport.isOpen()) {
            this.transport.open();
        }
    }

    private void openSession() throws SQLException {
        TSOpenSessionReq openReq = new TSOpenSessionReq();
        openReq.setUsername(this.params.getUsername());
        openReq.setPassword(this.params.getPassword());
        openReq.setZoneId(this.getTimeZone());
        openReq.putToConfiguration("version", this.params.getVersion().toString());
        openReq.putToConfiguration("sql_dialect", this.params.getSqlDialect());
        this.params.getDb().ifPresent(db -> openReq.putToConfiguration("db", db));
        TSOpenSessionResp openResp = null;
        try {
            openResp = this.client.openSession(openReq);
            this.sessionId = openResp.getSessionId();
            RpcUtils.verifySuccess((TSStatus)openResp.getStatus());
            this.timeFactor = RpcUtils.getTimeFactor((TSOpenSessionResp)openResp);
            if (protocolVersion.getValue() != openResp.getServerProtocolVersion().getValue()) {
                logger.warn("Protocol differ, Client version is {}}, but Server version is {}", (Object)protocolVersion.getValue(), (Object)openResp.getServerProtocolVersion().getValue());
                if (openResp.getServerProtocolVersion().getValue() == 0) {
                    throw new TException(String.format("Protocol not supported, Client version is %s, but Server version is %s", protocolVersion.getValue(), openResp.getServerProtocolVersion().getValue()));
                }
            }
        }
        catch (TException e) {
            this.transport.close();
            if (e.getMessage().contains("Required field 'client_protocol' was not present!")) {
                throw new SQLException(String.format("Can not establish connection with %s : You may try to connect an old version IoTDB instance using a client with new version: %s. ", this.params.getJdbcUriString(), e.getMessage()), e);
            }
            throw new SQLException(String.format("Can not establish connection with %s : %s. ", this.params.getJdbcUriString(), e.getMessage()), e);
        }
        catch (StatementExecutionException e) {
            this.transport.close();
            throw new IoTDBSQLException(e.getMessage(), openResp.getStatus());
        }
        this.isClosed = false;
    }

    public boolean reconnect() {
        boolean flag = false;
        for (int i = 1; i <= 3; ++i) {
            try {
                if (this.transport == null) continue;
                this.transport.close();
                this.openTransport();
                if (Config.rpcThriftCompressionEnable) {
                    this.setClient((IClientRPCService.Iface)new IClientRPCService.Client((TProtocol)new TCompactProtocol(this.transport)));
                } else {
                    this.setClient((IClientRPCService.Iface)new IClientRPCService.Client((TProtocol)new TBinaryProtocol(this.transport)));
                }
                this.openSession();
                this.setClient(RpcUtils.newSynchronizedClient((IClientRPCService.Iface)this.getClient()));
                flag = true;
                break;
            }
            catch (Exception e) {
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e1) {
                    logger.error("reconnect is interrupted.", (Throwable)e1);
                    Thread.currentThread().interrupt();
                }
            }
        }
        return flag;
    }

    public String getTimeZone() {
        if (this.zoneId == null) {
            this.zoneId = ZoneId.systemDefault();
        }
        return this.zoneId.toString();
    }

    public void setTimeZone(String timeZone) throws TException, IoTDBSQLException {
        TSSetTimeZoneReq req = new TSSetTimeZoneReq(this.sessionId, timeZone);
        TSStatus resp = this.getClient().setTimeZone(req);
        try {
            RpcUtils.verifySuccess((TSStatus)resp);
        }
        catch (StatementExecutionException e) {
            throw new IoTDBSQLException(e.getMessage(), resp);
        }
        this.zoneId = ZoneId.of(timeZone);
    }

    public ServerProperties getServerProperties() throws TException {
        return this.getClient().getProperties();
    }

    protected void changeDefaultDatabase(String database) {
        this.params.setDb(database);
    }

    protected void mayChangeDefaultSqlDialect(String sqlDialect) {
        if (!sqlDialect.equals(this.params.getSqlDialect())) {
            this.params.setSqlDialect(sqlDialect);
            this.params.setDb(null);
        }
    }

    public int getTimeFactor() {
        return this.timeFactor;
    }

    public String getDatabase() {
        return this.params.getDb().orElse(null);
    }
}

