/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.subscription;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.confignode.consensus.request.read.subscription.ShowSubscriptionPlan;
import org.apache.iotdb.confignode.consensus.request.read.subscription.ShowTopicPlan;
import org.apache.iotdb.confignode.consensus.response.subscription.SubscriptionTableResp;
import org.apache.iotdb.confignode.consensus.response.subscription.TopicTableResp;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.manager.pipe.coordinator.task.PipeTaskCoordinatorLock;
import org.apache.iotdb.confignode.manager.subscription.SubscriptionMetaSyncer;
import org.apache.iotdb.confignode.persistence.subscription.SubscriptionInfo;
import org.apache.iotdb.confignode.rpc.thrift.TCloseConsumerReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateConsumerReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateTopicReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropTopicReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetAllSubscriptionInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetAllTopicInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowSubscriptionReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowSubscriptionResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowTopicReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowTopicResp;
import org.apache.iotdb.confignode.rpc.thrift.TSubscribeReq;
import org.apache.iotdb.confignode.rpc.thrift.TUnsubscribeReq;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionCoordinator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionCoordinator.class);
    private final ConfigManager configManager;
    private final SubscriptionInfo subscriptionInfo;
    private final PipeTaskCoordinatorLock coordinatorLock;
    private AtomicReference<SubscriptionInfo> subscriptionInfoHolder;
    private final SubscriptionMetaSyncer subscriptionMetaSyncer;

    public SubscriptionCoordinator(ConfigManager configManager, SubscriptionInfo subscriptionInfo) {
        this.configManager = configManager;
        this.subscriptionInfo = subscriptionInfo;
        this.coordinatorLock = new PipeTaskCoordinatorLock();
        this.subscriptionMetaSyncer = new SubscriptionMetaSyncer(configManager);
    }

    public SubscriptionInfo getSubscriptionInfo() {
        return this.subscriptionInfo;
    }

    public AtomicReference<SubscriptionInfo> tryLock() {
        if (this.coordinatorLock.tryLock()) {
            this.subscriptionInfoHolder = new AtomicReference<SubscriptionInfo>(this.subscriptionInfo);
            return this.subscriptionInfoHolder;
        }
        return null;
    }

    public AtomicReference<SubscriptionInfo> lock() {
        this.coordinatorLock.lock();
        this.subscriptionInfoHolder = new AtomicReference<SubscriptionInfo>(this.subscriptionInfo);
        return this.subscriptionInfoHolder;
    }

    public boolean unlock() {
        if (this.subscriptionInfoHolder != null) {
            this.subscriptionInfoHolder.set(null);
            this.subscriptionInfoHolder = null;
        }
        try {
            this.coordinatorLock.unlock();
            return true;
        }
        catch (IllegalMonitorStateException ignored) {
            LOGGER.warn("This thread is not holding the lock.");
            return false;
        }
    }

    public boolean isLocked() {
        return this.coordinatorLock.isLocked();
    }

    public void startSubscriptionMetaSync() {
        this.subscriptionMetaSyncer.start();
    }

    public void stopSubscriptionMetaSync() {
        this.subscriptionMetaSyncer.stop();
    }

    public void updateLastSyncedVersion() {
        this.subscriptionInfo.updateLastSyncedVersion();
    }

    public boolean canSkipNextSync() {
        return this.subscriptionInfo.canSkipNextSync();
    }

    public TSStatus createTopic(TCreateTopicReq req) {
        TSStatus status = this.configManager.getProcedureManager().createTopic(req);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            LOGGER.warn("Failed to create topic {} with attributes {}. Result status: {}.", new Object[]{req.getTopicName(), req.getTopicAttributes(), status});
        }
        return status;
    }

    public TSStatus dropTopic(TDropTopicReq req) {
        String topicName = req.getTopicName();
        boolean isTopicExistedBeforeDrop = this.subscriptionInfo.isTopicExisted(topicName);
        TSStatus status = this.configManager.getProcedureManager().dropTopic(topicName);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            LOGGER.warn("Failed to drop topic {}. Result status: {}.", (Object)topicName, (Object)status);
        }
        boolean isIfExistedConditionSet = req.isSetIfExistsCondition() && req.isIfExistsCondition();
        return isTopicExistedBeforeDrop || isIfExistedConditionSet ? status : RpcUtils.getStatus((TSStatusCode)TSStatusCode.TOPIC_NOT_EXIST_ERROR, (String)String.format("Failed to drop topic %s. Failures: %s does not exist.", topicName, topicName));
    }

    public TShowTopicResp showTopic(TShowTopicReq req) {
        try {
            return ((TopicTableResp)this.configManager.getConsensusManager().read(new ShowTopicPlan())).filter(req.getTopicName()).convertToTShowTopicResp();
        }
        catch (Exception e) {
            LOGGER.warn("Failed to show topic info.", (Throwable)e);
            return new TopicTableResp(new TSStatus(TSStatusCode.SHOW_TOPIC_ERROR.getStatusCode()).setMessage(e.getMessage()), Collections.emptyList()).convertToTShowTopicResp();
        }
    }

    public TGetAllTopicInfoResp getAllTopicInfo() {
        try {
            return ((TopicTableResp)this.configManager.getConsensusManager().read(new ShowTopicPlan())).convertToTGetAllTopicInfoResp();
        }
        catch (Exception e) {
            LOGGER.warn("Failed to get all topic info.", (Throwable)e);
            return new TGetAllTopicInfoResp(new TSStatus(TSStatusCode.SHOW_TOPIC_ERROR.getStatusCode()).setMessage(e.getMessage()), Collections.emptyList());
        }
    }

    public TSStatus createConsumer(TCreateConsumerReq req) {
        TSStatus status = this.configManager.getProcedureManager().createConsumer(req);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            LOGGER.warn("Failed to create consumer {} in consumer group {}. Result status: {}.", new Object[]{req.getConsumerId(), req.getConsumerGroupId(), status});
        }
        return status;
    }

    public TSStatus dropConsumer(TCloseConsumerReq req) {
        TSStatus status = this.configManager.getProcedureManager().dropConsumer(req);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            LOGGER.warn("Failed to close consumer {} in consumer group {}. Result status: {}.", new Object[]{req.getConsumerId(), req.getConsumerGroupId(), status});
        }
        return status;
    }

    public TSStatus createSubscription(TSubscribeReq req) {
        TSStatus status = this.configManager.getProcedureManager().createSubscription(req);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            LOGGER.warn("Consumer {} in consumer group {} failed to subscribe topics {}. Result status: {}.", new Object[]{req.getConsumerId(), req.getConsumerGroupId(), req.getTopicNames(), status});
        }
        return status;
    }

    public TSStatus dropSubscription(TUnsubscribeReq req) {
        TSStatus status = this.configManager.getProcedureManager().dropSubscription(req);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            LOGGER.warn("Consumer {} in consumer group {} failed to unsubscribe topics {}. Result status: {}.", new Object[]{req.getConsumerId(), req.getConsumerGroupId(), req.getTopicNames(), status});
        }
        return status;
    }

    public TShowSubscriptionResp showSubscription(TShowSubscriptionReq req) {
        try {
            return ((SubscriptionTableResp)this.configManager.getConsensusManager().read(new ShowSubscriptionPlan())).filter(req.getTopicName()).convertToTShowSubscriptionResp();
        }
        catch (Exception e) {
            LOGGER.warn("Failed to show subscription info.", (Throwable)e);
            return new SubscriptionTableResp(new TSStatus(TSStatusCode.SHOW_SUBSCRIPTION_ERROR.getStatusCode()).setMessage(e.getMessage()), Collections.emptyList(), Collections.emptyList()).convertToTShowSubscriptionResp();
        }
    }

    public TGetAllSubscriptionInfoResp getAllSubscriptionInfo() {
        try {
            return ((SubscriptionTableResp)this.configManager.getConsensusManager().read(new ShowSubscriptionPlan())).convertToTGetAllSubscriptionInfoResp();
        }
        catch (Exception e) {
            LOGGER.warn("Failed to get all subscription info.", (Throwable)e);
            return new TGetAllSubscriptionInfoResp(new TSStatus(TSStatusCode.SHOW_SUBSCRIPTION_ERROR.getStatusCode()).setMessage(e.getMessage()), Collections.emptyList());
        }
    }
}

