/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.extractor;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.pipe.datastructure.pattern.IoTDBTreePattern;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanVisitor;
import org.apache.iotdb.confignode.consensus.request.write.auth.AuthorTreePlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DatabaseSchemaPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DeleteDatabasePlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetTTLPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeDeactivateTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeDeleteLogicalViewPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeDeleteTimeSeriesPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeUnsetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.CommitSetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.CreateSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.ExtendSchemaTemplatePlan;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.db.schemaengine.template.alter.TemplateExtendInfo;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeConfigPhysicalPlanTreePatternParseVisitor
extends ConfigPhysicalPlanVisitor<Optional<ConfigPhysicalPlan>, IoTDBTreePattern> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeConfigPhysicalPlanTreePatternParseVisitor.class);

    @Override
    public Optional<ConfigPhysicalPlan> visitPlan(ConfigPhysicalPlan plan, IoTDBTreePattern pattern) {
        return Optional.of(plan);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitCreateDatabase(DatabaseSchemaPlan createDatabasePlan, IoTDBTreePattern pattern) {
        return pattern.matchPrefixPath(createDatabasePlan.getSchema().getName()) ? Optional.of(createDatabasePlan) : Optional.empty();
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitAlterDatabase(DatabaseSchemaPlan alterDatabasePlan, IoTDBTreePattern pattern) {
        return pattern.matchPrefixPath(alterDatabasePlan.getSchema().getName()) ? Optional.of(alterDatabasePlan) : Optional.empty();
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitDeleteDatabase(DeleteDatabasePlan deleteDatabasePlan, IoTDBTreePattern pattern) {
        return pattern.matchPrefixPath(deleteDatabasePlan.getName()) ? Optional.of(deleteDatabasePlan) : Optional.empty();
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitCreateSchemaTemplate(CreateSchemaTemplatePlan createSchemaTemplatePlan, IoTDBTreePattern pattern) {
        Template template = createSchemaTemplatePlan.getTemplate();
        template.getSchemaMap().keySet().removeIf(measurement -> !pattern.matchTailNode(measurement));
        return !template.getSchemaMap().isEmpty() ? Optional.of(new CreateSchemaTemplatePlan(template.serialize().array())) : Optional.empty();
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitCommitSetSchemaTemplate(CommitSetSchemaTemplatePlan commitSetSchemaTemplatePlan, IoTDBTreePattern pattern) {
        return pattern.matchPrefixPath(commitSetSchemaTemplatePlan.getPath()) ? Optional.of(commitSetSchemaTemplatePlan) : Optional.empty();
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitPipeUnsetSchemaTemplate(PipeUnsetSchemaTemplatePlan pipeUnsetSchemaTemplatePlan, IoTDBTreePattern pattern) {
        return pattern.matchPrefixPath(pipeUnsetSchemaTemplatePlan.getPath()) ? Optional.of(pipeUnsetSchemaTemplatePlan) : Optional.empty();
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitExtendSchemaTemplate(ExtendSchemaTemplatePlan extendSchemaTemplatePlan, IoTDBTreePattern pattern) {
        TemplateExtendInfo extendInfo = extendSchemaTemplatePlan.getTemplateExtendInfo();
        int[] filteredIndexes = IntStream.range(0, extendInfo.getMeasurements().size()).filter(index -> pattern.matchTailNode((String)extendInfo.getMeasurements().get(index))).toArray();
        return filteredIndexes.length > 0 ? Optional.of(new ExtendSchemaTemplatePlan(new TemplateExtendInfo(extendInfo.getTemplateName(), IoTDBTreePattern.applyIndexesOnList((int[])filteredIndexes, (List)extendInfo.getMeasurements()), IoTDBTreePattern.applyIndexesOnList((int[])filteredIndexes, (List)extendInfo.getDataTypes()), IoTDBTreePattern.applyIndexesOnList((int[])filteredIndexes, (List)extendInfo.getEncodings()), IoTDBTreePattern.applyIndexesOnList((int[])filteredIndexes, (List)extendInfo.getCompressors())))) : Optional.empty();
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitGrantUser(AuthorTreePlan grantUserPlan, IoTDBTreePattern pattern) {
        return this.visitTreeAuthorPlan(grantUserPlan, pattern);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRevokeUser(AuthorTreePlan revokeUserPlan, IoTDBTreePattern pattern) {
        return this.visitTreeAuthorPlan(revokeUserPlan, pattern);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitGrantRole(AuthorTreePlan revokeUserPlan, IoTDBTreePattern pattern) {
        return this.visitTreeAuthorPlan(revokeUserPlan, pattern);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRevokeRole(AuthorTreePlan revokeUserPlan, IoTDBTreePattern pattern) {
        return this.visitTreeAuthorPlan(revokeUserPlan, pattern);
    }

    private Optional<ConfigPhysicalPlan> visitTreeAuthorPlan(AuthorTreePlan pathRelatedAuthorTreePlan, IoTDBTreePattern pattern) {
        List<PartialPath> intersectedPaths = pathRelatedAuthorTreePlan.getNodeNameList().stream().map(arg_0 -> ((IoTDBTreePattern)pattern).getIntersection(arg_0)).flatMap(Collection::stream).collect(Collectors.toList());
        Set<Integer> permissions = !intersectedPaths.isEmpty() ? pathRelatedAuthorTreePlan.getPermissions() : pathRelatedAuthorTreePlan.getPermissions().stream().filter(permission -> !PrivilegeType.values()[permission].isPathPrivilege()).collect(Collectors.toSet());
        return !permissions.isEmpty() ? Optional.of(new AuthorTreePlan(pathRelatedAuthorTreePlan.getAuthorType(), pathRelatedAuthorTreePlan.getUserName(), pathRelatedAuthorTreePlan.getRoleName(), pathRelatedAuthorTreePlan.getPassword(), pathRelatedAuthorTreePlan.getNewPassword(), permissions, pathRelatedAuthorTreePlan.getGrantOpt(), intersectedPaths)) : Optional.empty();
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitPipeDeleteTimeSeries(PipeDeleteTimeSeriesPlan pipeDeleteTimeSeriesPlan, IoTDBTreePattern pattern) {
        try {
            PathPatternTree intersectedTree = pattern.getIntersection(PathPatternTree.deserialize((ByteBuffer)pipeDeleteTimeSeriesPlan.getPatternTreeBytes()));
            return !intersectedTree.isEmpty() ? Optional.of(new PipeDeleteTimeSeriesPlan(intersectedTree.serialize())) : Optional.empty();
        }
        catch (IOException e) {
            LOGGER.warn("Serialization failed for the delete time series plan in pipe transmission, skip transfer", (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitPipeDeleteLogicalView(PipeDeleteLogicalViewPlan pipeDeleteLogicalViewPlan, IoTDBTreePattern pattern) {
        try {
            PathPatternTree intersectedTree = pattern.getIntersection(PathPatternTree.deserialize((ByteBuffer)pipeDeleteLogicalViewPlan.getPatternTreeBytes()));
            return !intersectedTree.isEmpty() ? Optional.of(new PipeDeleteLogicalViewPlan(intersectedTree.serialize())) : Optional.empty();
        }
        catch (IOException e) {
            LOGGER.warn("Serialization failed for the delete logical view plan in pipe transmission, skip transfer", (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitPipeDeactivateTemplate(PipeDeactivateTemplatePlan pipeDeactivateTemplatePlan, IoTDBTreePattern pattern) {
        Map<PartialPath, List<Template>> newTemplateSetInfo = pipeDeactivateTemplatePlan.getTemplateSetInfo().entrySet().stream().flatMap(entry -> pattern.getIntersection((PartialPath)entry.getKey()).stream().map(partialPath -> new Pair(partialPath, (Object)((List)entry.getValue())))).collect(Collectors.toMap(Pair::getLeft, Pair::getRight, (oldTemplates, newTemplates) -> Stream.of(oldTemplates, newTemplates).flatMap(Collection::stream).distinct().collect(Collectors.toList())));
        return !newTemplateSetInfo.isEmpty() ? Optional.of(new PipeDeactivateTemplatePlan(newTemplateSetInfo)) : Optional.empty();
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitTTL(SetTTLPlan setTTLPlan, IoTDBTreePattern pattern) {
        PartialPath partialPath = new PartialPath(setTTLPlan.getPathPattern());
        List intersectionList = pattern.matchPrefixPath(partialPath.getFullPath()) ? Collections.singletonList(partialPath) : pattern.getIntersection(partialPath);
        return !intersectionList.isEmpty() ? Optional.of(new SetTTLPlan(((PartialPath)intersectionList.get(0)).getNodes(), setTTLPlan.getTTL())) : Optional.empty();
    }
}

