/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool.schema;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.cli.type.ExitType;
import org.apache.iotdb.cli.utils.CliContext;
import org.apache.iotdb.cli.utils.IoTPrinter;
import org.apache.iotdb.cli.utils.JlineUtils;
import org.apache.iotdb.exception.ArgsErrorException;
import org.apache.iotdb.tool.common.OptionsUtil;
import org.apache.iotdb.tool.schema.AbstractExportSchema;
import org.apache.iotdb.tool.schema.AbstractSchemaTool;
import org.apache.iotdb.tool.schema.ExportSchemaTable;
import org.apache.iotdb.tool.schema.ExportSchemaTree;
import org.jline.reader.LineReader;

public class ExportSchema
extends AbstractSchemaTool {
    private static final IoTPrinter ioTPrinter = new IoTPrinter(System.out);

    public static void main(String[] args) {
        Options options = OptionsUtil.createExportSchemaOptions();
        HelpFormatter hf = new HelpFormatter();
        CommandLine commandLine = null;
        DefaultParser parser = new DefaultParser();
        hf.setOptionComparator(null);
        hf.setWidth(92);
        if (args == null || args.length == 0) {
            ioTPrinter.println("Too few params input, please check the following hint.");
            hf.printHelp("ExportSchema", options, true);
            System.exit(1);
        }
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            ioTPrinter.println(e.getMessage());
            hf.printHelp("ExportSchema", options, true);
            System.exit(1);
        }
        if (commandLine.hasOption("help")) {
            hf.printHelp("ExportSchema", options, true);
            System.exit(1);
        }
        try {
            ExportSchema.parseBasicParams(commandLine);
            ExportSchema.parseSpecialParams(commandLine);
        }
        catch (ArgsErrorException e) {
            ioTPrinter.println("Args args: " + e.getMessage());
            ioTPrinter.println("Use -help for more information");
            System.exit(1);
        }
        catch (Exception e) {
            ioTPrinter.println("Encounter an error, because " + e.getMessage());
            System.exit(1);
        }
        System.exit(ExportSchema.exportToTargetPath());
    }

    private static int exportToTargetPath() {
        try {
            if (sqlDialectTree.booleanValue()) {
                ExportSchemaTree exportSchema = new ExportSchemaTree();
                ((AbstractExportSchema)exportSchema).init();
                if (sqlDialectTree.booleanValue() && queryPath == null) {
                    LineReader lineReader = JlineUtils.getLineReader(new CliContext(System.in, System.out, System.err, ExitType.EXCEPTION), username, host, port);
                    String pathPattern = lineReader.readLine("Export Data> please input path pattern: ");
                    ioTPrinter.println(pathPattern);
                    String[] values = pathPattern.trim().split(";");
                    for (int i = 0; i < values.length; ++i) {
                        if (StringUtils.isBlank((CharSequence)values[i])) continue;
                        ((AbstractExportSchema)exportSchema).exportSchemaToCsvFile(values[i], i);
                    }
                } else {
                    ((AbstractExportSchema)exportSchema).exportSchemaToCsvFile(queryPath, 0);
                }
            } else {
                ExportSchemaTable exportSchema = new ExportSchemaTable();
                ((AbstractExportSchema)exportSchema).init();
                ((AbstractExportSchema)exportSchema).exportSchemaToSqlFile();
            }
            return 0;
        }
        catch (InterruptedException e) {
            ioTPrinter.println(String.format("Export schema fail: %s", e.getMessage()));
            Thread.currentThread().interrupt();
            return 1;
        }
        catch (Exception e) {
            ioTPrinter.println(String.format("Export schema fail: %s", e.getMessage()));
            return 1;
        }
    }

    private static void dumpFromPathFile(AbstractExportSchema exportSchema, String pathFile) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(pathFile));){
            String path;
            int index = 0;
            while ((path = reader.readLine()) != null) {
                exportSchema.exportSchemaToCsvFile(path, index);
                ++index;
            }
        }
    }

    private static void parseSpecialParams(CommandLine commandLine) throws ArgsErrorException {
        targetDirectory = ExportSchema.checkRequiredArg("t", "target", commandLine, null);
        queryPath = commandLine.getOptionValue("path");
        targetFile = commandLine.getOptionValue("pfn");
        targetFile = ExportSchema.checkRequiredArg("pfn", "prefix_file_name", commandLine, "dump");
        String timeoutString = commandLine.getOptionValue("timeout");
        if (timeoutString != null) {
            timeout = Long.parseLong(timeoutString);
        }
        if (!targetDirectory.endsWith("/") && !targetDirectory.endsWith("\\")) {
            targetDirectory = targetDirectory + File.separator;
        }
        if (commandLine.getOptionValue("lpf") != null) {
            linesPerFile = Integer.parseInt(commandLine.getOptionValue("lpf"));
        }
        database = commandLine.getOptionValue("db");
        table = commandLine.getOptionValue("table");
        String sqlDialectValue = ExportSchema.checkRequiredArg("sql_dialect", "sql_dialect", commandLine, "tree");
        if ("table".equalsIgnoreCase(sqlDialectValue)) {
            sqlDialectTree = false;
            if (StringUtils.isBlank((CharSequence)database)) {
                ioTPrinter.println(String.format("The database param is required when sql_dialect is table ", new Object[0]));
                System.exit(1);
            } else if (StringUtils.isNotBlank((CharSequence)database) && "information_schema".equalsIgnoreCase(database)) {
                ioTPrinter.println(String.format("Does not support exporting system databases %s", database));
                System.exit(1);
            }
        }
    }
}

