/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.it.env.cluster.node;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.iotdb.it.env.cluster.ClusterConstant;
import org.apache.iotdb.it.env.cluster.EnvUtils;
import org.apache.iotdb.it.env.cluster.config.MppBaseConfig;
import org.apache.iotdb.it.env.cluster.config.MppCommonConfig;
import org.apache.iotdb.it.env.cluster.config.MppJVMConfig;
import org.apache.iotdb.it.framework.IoTDBTestLogger;
import org.apache.iotdb.itbase.env.BaseNodeWrapper;
import org.slf4j.Logger;

public abstract class AbstractNodeWrapper
implements BaseNodeWrapper {
    private static final Logger logger = IoTDBTestLogger.logger;
    protected final String testClassName;
    protected final String testMethodName;
    protected final int[] portList;
    protected final int jmxPort;
    protected final MppJVMConfig jvmConfig;
    protected final int clusterIndex;
    protected final boolean isMultiCluster;
    protected Process instance;
    private final String nodeAddress;
    private int nodePort;
    private final int metricPort;
    private final long startTime;
    private List<String> killPoints = new ArrayList<String>();
    protected final Properties mutableNodeProperties = new Properties();
    protected final Properties mutableCommonProperties = new Properties();
    protected final Properties clusterConfigProperties = new Properties();
    protected final Properties immutableNodeProperties = new Properties();
    protected final Properties immutableCommonProperties = new Properties();
    protected final MppCommonConfig outputCommonConfig = new MppCommonConfig();

    protected AbstractNodeWrapper(String testClassName, String testMethodName, int[] portList, int clusterIndex, boolean isMultiCluster, long startTime) {
        this.testClassName = testClassName;
        this.testMethodName = testMethodName;
        this.portList = portList;
        this.nodeAddress = "127.0.0.1";
        this.nodePort = portList[0];
        this.metricPort = portList[portList.length - 2];
        this.jmxPort = this.portList[portList.length - 1];
        this.immutableCommonProperties.setProperty("udf_lib_dir", "");
        this.immutableCommonProperties.setProperty("trigger_lib_dir", "");
        this.immutableCommonProperties.setProperty("pipe_lib_dir", "");
        this.immutableCommonProperties.setProperty("mqtt_host", "");
        this.immutableCommonProperties.setProperty("mqtt_port", "");
        this.immutableCommonProperties.setProperty("rest_service_port", "");
        this.immutableCommonProperties.setProperty("influxdb_rpc_port", "");
        this.jvmConfig = this.initVMConfig();
        this.clusterIndex = clusterIndex;
        this.isMultiCluster = isMultiCluster;
        this.startTime = startTime;
    }

    @Override
    public void createNodeDir() {
        String destPath = this.getNodePath();
        try {
            try {
                if (new File(destPath).exists()) {
                    PathUtils.deleteDirectory((Path)Paths.get(destPath, new String[0]));
                }
            }
            catch (NoSuchFileException noSuchFileException) {
                // empty catch block
            }
            try (Stream<Path> s = Files.walk(Paths.get(ClusterConstant.TEMPLATE_NODE_PATH, new String[0]), new FileVisitOption[0]);){
                s.forEach(source -> {
                    Path destination = Paths.get(destPath, source.toString().substring(ClusterConstant.TEMPLATE_NODE_PATH.length()));
                    try {
                        Files.copy(source, destination, LinkOption.NOFOLLOW_LINKS, StandardCopyOption.COPY_ATTRIBUTES);
                    }
                    catch (IOException e) {
                        logger.error("Got error copying files to node dest dir", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                });
            }
        }
        catch (IOException ex) {
            logger.error("Copy node dir failed", (Throwable)ex);
            throw new AssertionError();
        }
    }

    @Override
    public void createLogDir() {
        try {
            FileUtils.createParentDirectories((File)new File(this.getLogPath()));
        }
        catch (IOException ex) {
            logger.error("Copy node dir failed", (Throwable)ex);
            throw new AssertionError();
        }
    }

    @Override
    public void destroyDir() {
        Throwable lastException = null;
        for (int i = 0; i < 10; ++i) {
            try {
                PathUtils.deleteDirectory((Path)Paths.get(this.getNodePath(), new String[0]));
                return;
            }
            catch (IOException ex) {
                lastException = ex;
                try {
                    TimeUnit.SECONDS.sleep(1L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new AssertionError((Object)("Delete node dir failed. " + e));
                }
            }
        }
        lastException.printStackTrace();
        throw new AssertionError((Object)"Delete node dir failed.");
    }

    public final void changeConfig(MppBaseConfig nodeConfig, MppCommonConfig commonConfig, @Nullable MppJVMConfig jvmConfig) {
        try {
            MppBaseConfig outputNodeConfig = nodeConfig.emptyClone();
            this.reloadMutableFields();
            this.outputCommonConfig.updateProperties(this.mutableCommonProperties);
            outputNodeConfig.updateProperties(this.mutableNodeProperties);
            this.outputCommonConfig.updateProperties(this.getDefaultCommonConfigPath());
            outputNodeConfig.updateProperties(this.getDefaultNodeConfigPath());
            this.reloadClusterConfigurations();
            this.outputCommonConfig.updateProperties(this.clusterConfigProperties);
            this.outputCommonConfig.updateProperties(commonConfig);
            outputNodeConfig.updateProperties(nodeConfig);
            this.outputCommonConfig.updateProperties(this.immutableCommonProperties);
            outputNodeConfig.updateProperties(this.immutableNodeProperties);
            this.outputCommonConfig.persistent(this.getSystemConfigPath());
            outputNodeConfig.persistent(this.getSystemConfigPath());
        }
        catch (IOException ex) {
            throw new AssertionError((Object)("Change the config of node failed. " + ex));
        }
        this.jvmConfig.override(jvmConfig);
    }

    private void reloadClusterConfigurations() {
        String valueStr = System.getProperty("ClusterConfigurations");
        if (valueStr == null) {
            return;
        }
        try {
            switch (EnvUtils.getValueOfIndex(valueStr, this.clusterIndex)) {
                case "LightWeightStandaloneMode": {
                    this.clusterConfigProperties.setProperty("config_node_consensus_protocol_class", EnvUtils.fromConsensusAbbrToFullName(System.getProperty("lightWeightStandaloneMode.configNodeConsensus")));
                    this.clusterConfigProperties.setProperty("schema_region_consensus_protocol_class", EnvUtils.fromConsensusAbbrToFullName(System.getProperty("lightWeightStandaloneMode.schemaRegionConsensus")));
                    this.clusterConfigProperties.setProperty("data_region_consensus_protocol_class", EnvUtils.fromConsensusAbbrToFullName(System.getProperty("lightWeightStandaloneMode.dataRegionConsensus")));
                    this.clusterConfigProperties.setProperty("schema_replication_factor", System.getProperty("lightWeightStandaloneMode.schemaRegionReplicaNumber"));
                    this.clusterConfigProperties.setProperty("data_replication_factor", System.getProperty("lightWeightStandaloneMode.dataRegionReplicaNumber"));
                    break;
                }
                case "ScalableSingleNodeMode": {
                    this.clusterConfigProperties.setProperty("config_node_consensus_protocol_class", EnvUtils.fromConsensusAbbrToFullName(System.getProperty("scalableSingleNodeMode.configNodeConsensus")));
                    this.clusterConfigProperties.setProperty("schema_region_consensus_protocol_class", EnvUtils.fromConsensusAbbrToFullName(System.getProperty("scalableSingleNodeMode.schemaRegionConsensus")));
                    this.clusterConfigProperties.setProperty("data_region_consensus_protocol_class", EnvUtils.fromConsensusAbbrToFullName(System.getProperty("scalableSingleNodeMode.dataRegionConsensus")));
                    this.clusterConfigProperties.setProperty("schema_replication_factor", System.getProperty("scalableSingleNodeMode.schemaRegionReplicaNumber"));
                    this.clusterConfigProperties.setProperty("data_replication_factor", System.getProperty("scalableSingleNodeMode.dataRegionReplicaNumber"));
                    break;
                }
                case "HighPerformanceMode": {
                    this.clusterConfigProperties.setProperty("config_node_consensus_protocol_class", EnvUtils.fromConsensusAbbrToFullName(System.getProperty("highPerformanceMode.configNodeConsensus")));
                    this.clusterConfigProperties.setProperty("schema_region_consensus_protocol_class", EnvUtils.fromConsensusAbbrToFullName(System.getProperty("highPerformanceMode.schemaRegionConsensus")));
                    this.clusterConfigProperties.setProperty("data_region_consensus_protocol_class", EnvUtils.fromConsensusAbbrToFullName(System.getProperty("highPerformanceMode.dataRegionConsensus")));
                    this.clusterConfigProperties.setProperty("schema_replication_factor", System.getProperty("highPerformanceMode.schemaRegionReplicaNumber"));
                    this.clusterConfigProperties.setProperty("data_replication_factor", System.getProperty("highPerformanceMode.dataRegionReplicaNumber"));
                    break;
                }
                case "StrongConsistencyClusterMode": {
                    this.clusterConfigProperties.setProperty("config_node_consensus_protocol_class", EnvUtils.fromConsensusAbbrToFullName(System.getProperty("strongConsistencyClusterMode.configNodeConsensus")));
                    this.clusterConfigProperties.setProperty("schema_region_consensus_protocol_class", EnvUtils.fromConsensusAbbrToFullName(System.getProperty("strongConsistencyClusterMode.schemaRegionConsensus")));
                    this.clusterConfigProperties.setProperty("data_region_consensus_protocol_class", EnvUtils.fromConsensusAbbrToFullName(System.getProperty("strongConsistencyClusterMode.dataRegionConsensus")));
                    this.clusterConfigProperties.setProperty("schema_replication_factor", System.getProperty("strongConsistencyClusterMode.schemaRegionReplicaNumber"));
                    this.clusterConfigProperties.setProperty("data_replication_factor", System.getProperty("strongConsistencyClusterMode.dataRegionReplicaNumber"));
                    break;
                }
                case "PipeConsensusBatchMode": {
                    this.clusterConfigProperties.setProperty("config_node_consensus_protocol_class", EnvUtils.fromConsensusAbbrToFullName(System.getProperty("pipeConsensusBatchMode.configNodeConsensus")));
                    this.clusterConfigProperties.setProperty("schema_region_consensus_protocol_class", EnvUtils.fromConsensusAbbrToFullName(System.getProperty("pipeConsensusBatchMode.schemaRegionConsensus")));
                    this.clusterConfigProperties.setProperty("data_region_consensus_protocol_class", EnvUtils.fromConsensusAbbrToFullName(System.getProperty("pipeConsensusBatchMode.dataRegionConsensus")));
                    this.clusterConfigProperties.setProperty("schema_replication_factor", System.getProperty("pipeConsensusBatchMode.schemaRegionReplicaNumber"));
                    this.clusterConfigProperties.setProperty("data_replication_factor", System.getProperty("pipeConsensusBatchMode.dataRegionReplicaNumber"));
                    this.clusterConfigProperties.setProperty("iot_consensus_v2_mode", "batch");
                    break;
                }
                case "PipeConsensusStreamMode": {
                    this.clusterConfigProperties.setProperty("config_node_consensus_protocol_class", EnvUtils.fromConsensusAbbrToFullName(System.getProperty("pipeConsensusStreamMode.configNodeConsensus")));
                    this.clusterConfigProperties.setProperty("schema_region_consensus_protocol_class", EnvUtils.fromConsensusAbbrToFullName(System.getProperty("pipeConsensusStreamMode.schemaRegionConsensus")));
                    this.clusterConfigProperties.setProperty("data_region_consensus_protocol_class", EnvUtils.fromConsensusAbbrToFullName(System.getProperty("pipeConsensusStreamMode.dataRegionConsensus")));
                    this.clusterConfigProperties.setProperty("schema_replication_factor", System.getProperty("pipeConsensusStreamMode.schemaRegionReplicaNumber"));
                    this.clusterConfigProperties.setProperty("data_replication_factor", System.getProperty("pipeConsensusStreamMode.dataRegionReplicaNumber"));
                    this.clusterConfigProperties.setProperty("iot_consensus_v2_mode", "stream");
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public void start() {
        try {
            File stdoutFile = new File(this.getLogPath());
            ArrayList<String> startCmd = new ArrayList<String>();
            startCmd.add(ClusterConstant.JAVA_CMD);
            if (!SystemUtils.IS_JAVA_1_8) {
                startCmd.add("--add-opens=java.base/java.util.concurrent=ALL-UNNAMED");
                startCmd.add("--add-opens=java.base/java.lang=ALL-UNNAMED");
                startCmd.add("--add-opens=java.base/java.util=ALL-UNNAMED");
                startCmd.add("--add-opens=java.base/java.nio=ALL-UNNAMED");
                startCmd.add("--add-opens=java.base/java.io=ALL-UNNAMED");
                startCmd.add("--add-opens=java.base/java.net=ALL-UNNAMED");
            }
            String libPath = System.getProperty("user.dir") + File.separator + "target" + File.separator + "template-node-share" + File.separator + "lib" + File.separator;
            File directory = new File(libPath);
            String osName = System.getProperty("os.name").toLowerCase();
            String server_node_lib_path = "";
            if (directory.exists() && directory.isDirectory() && !osName.contains("win")) {
                File[] files;
                for (File file : files = directory.listFiles()) {
                    if (!file.getName().startsWith("iotdb-server")) continue;
                    server_node_lib_path = libPath + file.getName() + ":" + ClusterConstant.TEMPLATE_NODE_LIB_PATH;
                    break;
                }
            } else {
                server_node_lib_path = ClusterConstant.TEMPLATE_NODE_LIB_PATH;
            }
            startCmd.addAll(Arrays.asList("-Dcom.sun.management.jmxremote.port=" + this.jmxPort, "-Dcom.sun.management.jmxremote.rmi.port=" + this.jmxPort, "-Djava.rmi.server.randomIDs=true", "-Dcom.sun.management.jmxremote.ssl=false", "-Dcom.sun.management.jmxremote.authenticate=false", "-Djava.rmi.server.hostname=" + this.getIp(), "-Xms" + this.jvmConfig.getInitHeapSize() + "m", "-Xmx" + this.jvmConfig.getMaxHeapSize() + "m", "-Duser.timezone=" + this.jvmConfig.getTimezone(), "-XX:MaxDirectMemorySize=" + this.jvmConfig.getMaxDirectMemorySize() + "m", "-Djdk.nio.maxCachedBufferSize=262144", "-DintegrationTestKillPoints=" + this.killPoints.toString(), "-cp", server_node_lib_path));
            this.addStartCmdParams(startCmd);
            FileUtils.write((File)stdoutFile, (CharSequence)(String.join((CharSequence)" ", startCmd) + "\n\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
            ProcessBuilder processBuilder = new ProcessBuilder(startCmd).redirectOutput(ProcessBuilder.Redirect.appendTo(stdoutFile)).redirectError(ProcessBuilder.Redirect.appendTo(stdoutFile));
            processBuilder.environment().put("CLASSPATH", ClusterConstant.TEMPLATE_NODE_LIB_PATH);
            this.instance = processBuilder.start();
            logger.info("In test {} {} started.", (Object)this.getTestLogDirName(), (Object)this.getId());
        }
        catch (IOException ex) {
            throw new AssertionError((Object)("Start node failed. " + ex));
        }
    }

    @Override
    public void stop() {
        if (this.instance == null) {
            return;
        }
        this.instance.destroy();
        try {
            if (!this.instance.waitFor(20L, TimeUnit.SECONDS)) {
                logger.warn("Node {} does not exit within 20s, killing it", (Object)this.getId());
                if (!this.instance.destroyForcibly().waitFor(10L, TimeUnit.SECONDS)) {
                    logger.error("Cannot forcibly stop node {}", (Object)this.getId());
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error("Waiting node to shutdown error.", (Throwable)e);
        }
    }

    @Override
    public void stopForcibly() {
        if (this.instance == null) {
            return;
        }
        try {
            this.instance.destroyForcibly().waitFor(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error("Waiting node to shutdown error.", (Throwable)e);
        }
    }

    @Override
    public boolean isAlive() {
        return this.instance != null && this.instance.isAlive();
    }

    @Override
    public final String getIp() {
        return this.nodeAddress;
    }

    @Override
    public final int getPort() {
        return this.nodePort;
    }

    @Override
    public int getMetricPort() {
        return this.metricPort;
    }

    public void setPort(int port) {
        this.nodePort = port;
    }

    @Override
    public final String getIpAndPortString() {
        return this.getIp() + ":" + this.getPort();
    }

    protected String workDirFilePath(String dirName, String fileName) {
        return this.getNodePath() + File.separator + dirName + File.separator + fileName;
    }

    protected String getLogPath() {
        return this.getLogDirPath() + File.separator + this.getId() + ".log";
    }

    public String getLogDirPath() {
        String baseDir = System.getProperty("user.dir") + File.separator + "target" + File.separator + "cluster-logs" + File.separator + this.getTestLogDirName() + File.separator + EnvUtils.getTimeForLogDirectory(this.startTime);
        if (!this.isMultiCluster) {
            return baseDir;
        }
        return baseDir + File.separator + this.getClusterIdStr();
    }

    private String getClusterIdStr() {
        return this.clusterIndex + "-" + this.outputCommonConfig.getClusterConfigStr();
    }

    public String getNodePath() {
        return System.getProperty("user.dir") + File.separator + "target" + File.separator + this.getId();
    }

    public String getDataPath() {
        return this.getNodePath() + File.separator + "data" + File.separator + this.getNodeType() + File.separator + "data";
    }

    abstract String getNodeType();

    public void dumpJVMSnapshot(String testCaseName) {
        JMXServiceURL url;
        try {
            url = new JMXServiceURL(String.format("service:jmx:rmi:///jndi/rmi://127.0.0.1:%d/jmxrmi", this.jmxPort));
        }
        catch (MalformedURLException e) {
            logger.error("Construct JMX URL failed", (Throwable)e);
            return;
        }
        try (JMXConnector connector = JMXConnectorFactory.connect(url);){
            MBeanServerConnection mbsc = connector.getMBeanServerConnection();
            ThreadMXBean tmbean = ManagementFactory.newPlatformMXBeanProxy(mbsc, "java.lang:type=Threading", ThreadMXBean.class);
            ThreadInfo[] threadInfos = tmbean.dumpAllThreads(true, true);
            long[] deadlockIds = tmbean.findDeadlockedThreads();
            LocalDateTime currentTime = LocalDateTime.now();
            try (PrintWriter output = new PrintWriter(this.getLogDirPath() + File.separator + testCaseName + "_" + this.getId() + "-threads.dump");){
                output.printf("# Captured at %s%n", currentTime);
                output.println("==================\n");
                if (deadlockIds != null && deadlockIds.length > 0) {
                    output.printf("Detect DEADLOCK threads!%n", new Object[0]);
                    for (long deadlockId : deadlockIds) {
                        ThreadInfo ti = tmbean.getThreadInfo(deadlockId);
                        output.printf("%s #%d%n", ti.getThreadName(), ti.getThreadId());
                    }
                    output.println("==================\n");
                }
                for (ThreadInfo threadInfo : threadInfos) {
                    this.dumpThread(output, threadInfo);
                }
            }
        }
        catch (IOException e) {
            logger.error("Connect with MBeanServer {} failed", (Object)url.getURLPath(), (Object)e);
        }
    }

    private void dumpThread(PrintWriter output, ThreadInfo ti) {
        StringBuilder sb = new StringBuilder("\"" + ti.getThreadName() + "\"");
        sb.append(" #").append(ti.getThreadId());
        sb.append(" ").append((Object)ti.getThreadState()).append("\n");
        if (ti.getLockName() != null) {
            sb.append("Waiting on: ").append(ti.getLockName()).append("\n");
        }
        if (ti.getLockOwnerName() != null) {
            sb.append("Locked by: ").append(ti.getLockOwnerName()).append(" #").append(ti.getLockOwnerId()).append("\n");
        }
        HashMap<StackTraceElement, MonitorInfo> lockInfoMap = new HashMap<StackTraceElement, MonitorInfo>();
        for (MonitorInfo monitor : ti.getLockedMonitors()) {
            lockInfoMap.put(monitor.getLockedStackFrame(), monitor);
        }
        for (StackTraceElement ele : ti.getStackTrace()) {
            if (lockInfoMap.containsKey(ele)) {
                MonitorInfo monitorInfo = (MonitorInfo)lockInfoMap.get(ele);
                sb.append("  ").append("- lock ").append(monitorInfo.getClassName()).append("@").append(Integer.toHexString(monitorInfo.getIdentityHashCode())).append("\n");
            }
            sb.append("  ").append(ele).append("\n");
        }
        sb.append("\n");
        output.print(sb);
    }

    protected String getTestLogDirName() {
        if (this.testMethodName == null) {
            return this.testClassName;
        }
        return this.testClassName + File.separator + this.testMethodName;
    }

    public void setKillPoints(List<String> killPoints) {
        this.killPoints = killPoints;
    }

    private String getKillPoints() {
        return this.killPoints.toString();
    }

    protected abstract void reloadMutableFields();

    protected abstract void renameFile();

    protected abstract String getSystemConfigPath();

    protected abstract String getDefaultNodeConfigPath();

    protected abstract String getDefaultCommonConfigPath();

    protected abstract void addStartCmdParams(List<String> var1);

    public abstract String getSystemPropertiesPath();

    protected abstract MppJVMConfig initVMConfig();

    @Override
    public void executeJstack() {
        this.executeJstack(arg_0 -> ((Logger)logger).info(arg_0));
    }

    @Override
    public void executeJstack(String testCaseName) {
        String fileName = this.getLogDirPath() + File.separator + testCaseName + "_" + this.getId() + "-threads.jstack";
        try (PrintWriter output = new PrintWriter(fileName);){
            this.executeJstack(output::println);
        }
        catch (IOException e) {
            logger.warn("IOException occurred when executing Jstack for {}", (Object)this.getId(), (Object)e);
        }
        logger.info("Jstack execution output can be found at {}", (Object)fileName);
    }

    private void executeJstack(Consumer<String> consumer) {
        long pid = this.getPid();
        if (pid == -1L) {
            logger.warn("Failed to get pid for {} before executing Jstack", (Object)this.getId());
            return;
        }
        String command = "jstack -l " + pid;
        logger.info("Executing command {} for {}", (Object)command, (Object)this.getId());
        try {
            Process process = Runtime.getRuntime().exec(command);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    consumer.accept(line);
                }
            }
            int exitCode = process.waitFor();
            logger.info("Command {} exited with code {}", (Object)command, (Object)exitCode);
        }
        catch (IOException e) {
            logger.warn("IOException occurred when executing Jstack for {}", (Object)this.getId(), (Object)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warn("InterruptedException occurred when executing Jstack for {}", (Object)this.getId(), (Object)e);
        }
    }

    @Override
    public long getPid() {
        long l;
        block10: {
            JMXServiceURL url;
            try {
                url = new JMXServiceURL(String.format("service:jmx:rmi:///jndi/rmi://127.0.0.1:%d/jmxrmi", this.jmxPort));
            }
            catch (MalformedURLException ignored) {
                return -1L;
            }
            JMXConnector connector = JMXConnectorFactory.connect(url);
            try {
                MBeanServerConnection mbsc = connector.getMBeanServerConnection();
                RuntimeMXBean rmbean = ManagementFactory.newPlatformMXBeanProxy(mbsc, "java.lang:type=Runtime", RuntimeMXBean.class);
                l = Long.parseLong(rmbean.getName().split("@")[0]);
                if (connector == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (connector != null) {
                        try {
                            connector.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable ignored) {
                    return -1L;
                }
            }
            connector.close();
        }
        return l;
    }

    public Process getInstance() {
        return this.instance;
    }

    public int[] getPortList() {
        return this.portList;
    }
}

